/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.variables;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.variables.ChangeExpressionPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class ChangeExpressionPacketImpl
implements ChangeExpressionPacket {
    private final long threadId;
    private final int frameIndex;
    private final String newExpression;
    private final int index;

    public static ChangeExpressionPacketImpl read(DataInputStream in) throws IOException {
        return new ChangeExpressionPacketImpl(in);
    }

    private ChangeExpressionPacketImpl(DataInputStream in) throws IOException {
        this.threadId = in.readLong();
        this.frameIndex = in.readInt();
        this.newExpression = in.readUTF();
        this.index = in.readInt();
    }

    public ChangeExpressionPacketImpl(long threadId, int frameIndex, String newExpression, int index) {
        this.threadId = threadId;
        this.frameIndex = frameIndex;
        this.newExpression = newExpression;
        this.index = index;
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.CHANGE_EXPRESSION_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeLong(this.threadId);
        out.writeInt(this.frameIndex);
        out.writeUTF(this.newExpression);
        out.writeInt(this.index);
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Thread identifier             : " + this.threadId);
        stream.println("    Stack frame index             : " + this.frameIndex);
        stream.println("    New expression                : " + this.newExpression);
        stream.println("    Expression index              : " + this.index);
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public int getFrameIndex() {
        return this.frameIndex;
    }

    @Override
    public String getNewExpression() {
        return this.newExpression;
    }

    @Override
    public int getExpressionIndex() {
        return this.index;
    }

    public int hashCode() {
        return (int)(this.threadId >> 32 ^ this.threadId) ^ this.frameIndex ^ this.index ^ (this.newExpression == null ? 0 : this.newExpression.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeExpressionPacketImpl other = (ChangeExpressionPacketImpl)obj;
        if (this.newExpression == null ? other.newExpression != null : !this.newExpression.equals(other.newExpression)) {
            return false;
        }
        return this.threadId == other.threadId && this.frameIndex == other.frameIndex && this.index == other.index;
    }
}

