/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.variables;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.variables.EvalExpressionPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public class EvalExpressionPacketImpl
implements EvalExpressionPacket {
    private final int[] expressionIndices;

    public static EvalExpressionPacketImpl read(DataInputStream in) throws IOException {
        return new EvalExpressionPacketImpl(in);
    }

    private EvalExpressionPacketImpl(DataInputStream in) throws IOException {
        this.expressionIndices = new int[in.readInt()];
        for (int i = 0; i < this.expressionIndices.length; ++i) {
            this.expressionIndices[i] = in.readInt();
        }
    }

    public EvalExpressionPacketImpl(int[] expressionIndices) {
        this.expressionIndices = expressionIndices;
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.EVAL_EXPRESSION_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.expressionIndices.length);
        for (int index : this.expressionIndices) {
            out.writeInt(index);
        }
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Expression indices: " + Arrays.toString(this.expressionIndices));
    }

    public int hashCode() {
        return Arrays.hashCode(this.expressionIndices);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EvalExpressionPacketImpl) {
            return Arrays.equals(((EvalExpressionPacketImpl)obj).expressionIndices, this.expressionIndices);
        }
        return false;
    }

    @Override
    public int[] getExpressionIndices() {
        return this.expressionIndices;
    }
}

