/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.variables;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.variables.AbstractVariableFilterPacket;
import com.sap.jvm.debugging.controller.packets.variables.LocalVariableFilterPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public final class LocalVariableFilterPacketImpl
extends AbstractVariableFilterPacket
implements LocalVariableFilterPacket {
    private final boolean returnValuesEnabled;
    private final boolean ignoreLocalVarStoredReturnValues;
    private final boolean ignoreReturnValuesUsedAsParameter;
    private final boolean ignoreReturnValuesUsedAsReceiver;
    private final String[] returnValueMethodsToIgnore;

    public static LocalVariableFilterPacketImpl read(DataInputStream in) throws IOException {
        return new LocalVariableFilterPacketImpl(in);
    }

    private LocalVariableFilterPacketImpl(DataInputStream in) throws IOException {
        super(in);
        this.returnValuesEnabled = in.available() > 0 ? in.readBoolean() : false;
        this.ignoreLocalVarStoredReturnValues = in.available() > 0 ? in.readBoolean() : false;
        this.returnValueMethodsToIgnore = new String[in.available() >= 4 ? in.readInt() : 0];
        for (int i = 0; i < this.returnValueMethodsToIgnore.length; ++i) {
            this.returnValueMethodsToIgnore[i] = in.readUTF();
        }
        this.ignoreReturnValuesUsedAsParameter = in.available() > 0 ? in.readBoolean() : false;
        this.ignoreReturnValuesUsedAsReceiver = in.available() > 0 ? in.readBoolean() : false;
    }

    public LocalVariableFilterPacketImpl(boolean showStatics, boolean showConstants, boolean showSyntheticVariables, boolean showLogicalStructures, boolean returnValuesEnabled, boolean ignoreLocalVarStoredReturnValues, boolean ignoreReturnValuesUsedAsParameter, boolean ignoreReturnValuesUsedAsReceiver, String ... returnValueMethodsToIgnore) {
        super(showStatics, showConstants, showSyntheticVariables, showLogicalStructures);
        this.returnValuesEnabled = returnValuesEnabled;
        this.ignoreLocalVarStoredReturnValues = ignoreLocalVarStoredReturnValues;
        this.ignoreReturnValuesUsedAsParameter = ignoreReturnValuesUsedAsParameter;
        this.ignoreReturnValuesUsedAsReceiver = ignoreReturnValuesUsedAsReceiver;
        this.returnValueMethodsToIgnore = (String[])returnValueMethodsToIgnore.clone();
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.LOCAL_VARIABLE_FILTER_TAG;
    }

    @Override
    public boolean includeReturnValuesAsVariables() {
        return this.returnValuesEnabled;
    }

    @Override
    public boolean ignoreReturnValuesStoredInLocalVars() {
        return this.ignoreLocalVarStoredReturnValues;
    }

    @Override
    public String[] getRegexpsForMethodsToIgnore() {
        return (String[])this.returnValueMethodsToIgnore.clone();
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        super.write(out);
        out.writeBoolean(this.returnValuesEnabled);
        out.writeBoolean(this.ignoreLocalVarStoredReturnValues);
        out.writeInt(this.returnValueMethodsToIgnore.length);
        for (int i = 0; i < this.returnValueMethodsToIgnore.length; ++i) {
            out.writeUTF(this.returnValueMethodsToIgnore[i]);
        }
        out.writeBoolean(this.ignoreReturnValuesUsedAsParameter);
        out.writeBoolean(this.ignoreReturnValuesUsedAsReceiver);
    }

    @Override
    public void print(PrintStream stream) {
        super.print(stream);
        stream.println("    Show return values            : " + (this.returnValuesEnabled ? "yes" : "no"));
        stream.println("    Ignore local stored return val: " + (this.ignoreLocalVarStoredReturnValues ? "yes" : "no"));
        stream.println("    Ignore parametger return val  : " + (this.ignoreReturnValuesUsedAsParameter ? "yes" : "no"));
        stream.println("    Ignore receiver return val    : " + (this.ignoreReturnValuesUsedAsReceiver ? "yes" : "no"));
        for (String regexp : this.returnValueMethodsToIgnore) {
            stream.println("    Ignoring return val of method : " + regexp);
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ ((this.returnValuesEnabled ? 2 : 0) | (this.ignoreLocalVarStoredReturnValues ? 2 : 0) | (this.ignoreReturnValuesUsedAsParameter ? 4 : 0) | (this.ignoreReturnValuesUsedAsReceiver ? 8 : 0) | Arrays.hashCode(this.returnValueMethodsToIgnore));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocalVariableFilterPacketImpl other = (LocalVariableFilterPacketImpl)obj;
        return super.equals(obj) && this.returnValuesEnabled == other.returnValuesEnabled && this.ignoreLocalVarStoredReturnValues == other.ignoreLocalVarStoredReturnValues && this.ignoreReturnValuesUsedAsParameter == other.ignoreReturnValuesUsedAsParameter && this.ignoreReturnValuesUsedAsReceiver == other.ignoreReturnValuesUsedAsReceiver && Arrays.equals(this.returnValueMethodsToIgnore, other.returnValueMethodsToIgnore);
    }

    @Override
    public boolean ignoreReturnValuesUsedAsParameter() {
        return this.ignoreReturnValuesUsedAsParameter;
    }

    @Override
    public boolean ignoreReturnValuesUsedAsReceiver() {
        return this.ignoreReturnValuesUsedAsReceiver;
    }
}

