/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.variables;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.variables.RemoveDetailFormattersPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public final class RemoveDetailFormattersPacketImpl
implements RemoveDetailFormattersPacket {
    private final String[] classNames;

    public static RemoveDetailFormattersPacketImpl read(DataInputStream in) throws IOException {
        return new RemoveDetailFormattersPacketImpl(in);
    }

    private RemoveDetailFormattersPacketImpl(DataInputStream in) throws IOException {
        int size = in.readInt();
        this.classNames = new String[size];
        for (int i = 0; i < size; ++i) {
            this.classNames[i] = in.readUTF();
        }
    }

    public RemoveDetailFormattersPacketImpl(String[] classNames) {
        this.classNames = (String[])classNames.clone();
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.REMOVE_DETAIL_FORMATTERS_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.classNames.length);
        for (int i = 0; i < this.classNames.length; ++i) {
            out.writeUTF(this.classNames[i]);
        }
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        for (int i = 0; i < this.classNames.length; ++i) {
            stream.println("    " + i + ". Detail Formatter            : " + this.classNames[i]);
        }
    }

    @Override
    public int getNumberOfFormatters() {
        return this.classNames.length;
    }

    @Override
    public String getClassName(int index) {
        return this.classNames[index];
    }

    public int hashCode() {
        return Arrays.hashCode(this.classNames);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RemoveDetailFormattersPacketImpl other = (RemoveDetailFormattersPacketImpl)obj;
        return Arrays.equals(this.classNames, other.classNames);
    }
}

