/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.variables;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.variables.RemoveExpressionPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class RemoveExpressionPacketImpl
implements RemoveExpressionPacket {
    private final long threadId;
    private final int frameIndex;
    private final String expression;
    private final int index;

    public static RemoveExpressionPacketImpl read(DataInputStream in) throws IOException {
        return new RemoveExpressionPacketImpl(in);
    }

    private RemoveExpressionPacketImpl(DataInputStream in) throws IOException {
        this.threadId = in.readLong();
        this.frameIndex = in.readInt();
        this.expression = in.readUTF();
        this.index = in.readInt();
    }

    public RemoveExpressionPacketImpl(long threadId, int frameIndex, String expression, int index) {
        this.threadId = threadId;
        this.frameIndex = frameIndex;
        this.expression = expression;
        this.index = index;
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.REMOVE_EXPRESSION_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeLong(this.threadId);
        out.writeInt(this.frameIndex);
        out.writeUTF(this.expression);
        out.writeInt(this.index);
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        stream.println("    Thread identifier             : " + this.threadId);
        stream.println("    Stack frame index             : " + this.frameIndex);
        stream.println("    Expression                    : " + this.expression);
        stream.println("    Expression index              : " + this.index);
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public int getFrameIndex() {
        return this.frameIndex;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public int getExpressionIndex() {
        return this.index;
    }

    public int hashCode() {
        return (int)(this.threadId >> 32 ^ this.threadId) ^ this.frameIndex ^ this.index ^ (this.expression == null ? 0 : this.expression.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RemoveExpressionPacketImpl other = (RemoveExpressionPacketImpl)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        return this.threadId == other.threadId && this.frameIndex == other.frameIndex && this.index == other.index;
    }
}

