/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.variables;

import com.sap.jvm.debugging.controller.packets.DebuggingTag;
import com.sap.jvm.debugging.controller.packets.PacketHandler;
import com.sap.jvm.debugging.controller.packets.variables.RemoveLogicalStructurePacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public final class RemoveLogicalStructuresPacketImpl
implements RemoveLogicalStructurePacket {
    private final String[] classNames;

    public static RemoveLogicalStructuresPacketImpl read(DataInputStream in) throws IOException {
        return new RemoveLogicalStructuresPacketImpl(in);
    }

    private RemoveLogicalStructuresPacketImpl(DataInputStream in) throws IOException {
        int size = in.readInt();
        this.classNames = new String[size];
        for (int i = 0; i < size; ++i) {
            this.classNames[i] = in.readUTF();
        }
    }

    public RemoveLogicalStructuresPacketImpl(String[] classNames) {
        this.classNames = (String[])classNames.clone();
    }

    @Override
    public void dispatch(PacketHandler handler) {
        handler.handle(this);
    }

    @Override
    public DebuggingTag getType() {
        return DebuggingTag.REMOVE_LOGICAL_STRUCTURES_TAG;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.classNames.length);
        for (int i = 0; i < this.classNames.length; ++i) {
            out.writeUTF(this.classNames[i]);
        }
    }

    @Override
    public void print(PrintStream stream) {
        stream.println((Object)this.getType());
        for (int i = 0; i < this.classNames.length; ++i) {
            stream.println("    " + i + ". Logical Structure Definition: " + this.classNames[i]);
        }
    }

    @Override
    public int getNumberOfLogicalStructures() {
        return this.classNames.length;
    }

    @Override
    public String getClassName(int index) {
        return this.classNames[index];
    }

    public int hashCode() {
        return Arrays.hashCode(this.classNames);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RemoveLogicalStructuresPacketImpl other = (RemoveLogicalStructuresPacketImpl)obj;
        return Arrays.equals(this.classNames, other.classNames);
    }
}

