/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.packets.variables;

import com.sap.jvm.debugging.presentation.VariableTreeNode;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class VariableTreeNodeImpl
implements VariableTreeNode {
    private final int index;
    private final String name;
    private final long id;
    private final boolean synthetic;

    public VariableTreeNodeImpl(DataInputStream in) throws IOException {
        this.index = in.readInt();
        this.name = in.readUTF();
        this.id = in.readLong();
        this.synthetic = in.readBoolean();
    }

    public VariableTreeNodeImpl(int index, String name, long id, boolean synthtetic) {
        this.index = index;
        this.name = name;
        this.id = id;
        this.synthetic = synthtetic;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.index);
        out.writeUTF(this.name);
        out.writeLong(this.id);
        out.writeBoolean(this.synthetic);
    }

    public void print(PrintStream stream, String indent) {
        stream.format("%s%d. %s (%sid=%d)", indent, this.index, this.name, this.synthetic ? "s " : "", this.id);
        stream.println();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getObjectId() {
        return this.id;
    }

    @Override
    public boolean isSynthetic() {
        return this.synthetic;
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        result = 37 * result + (int)(this.id ^ this.id >>> 32);
        result = 37 * result + this.index;
        result = 37 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 37 * result + (this.synthetic ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VariableTreeNodeImpl other = (VariableTreeNodeImpl)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.id == other.id && this.index == other.index && this.synthetic == other.synthetic;
    }
}

