/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.controller.tasks;

import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class TaskExecutor
implements Runnable {
    public static final long POLLING_PERIOD_MS = 500L;
    private final BlockingQueue<Runnable> taskQueue;
    private volatile boolean closed = false;
    private volatile boolean finished = false;
    private volatile long tasksExecuted = 0L;
    private final Tracer tracer;

    public TaskExecutor(BlockingQueue<Runnable> queue, Object context) {
        this.taskQueue = queue;
        this.tracer = Trace.get((String)"com.sap.jvm.debugging.controller.tasks.executor", (Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.tracer.debug("Executor: Waiting for new task...");
            while (!this.closed) {
                Runnable task = null;
                try {
                    task = this.taskQueue.poll(500L, TimeUnit.MILLISECONDS);
                    if (task == null) continue;
                    this.tracer.debug("Executor: Received new task, executing it...");
                    task.run();
                    this.tracer.debug("Executor: Waiting for new task...");
                }
                catch (Throwable e) {
                    if (task == null) {
                        this.tracer.warn(e, "Exception while polling task queue");
                    } else {
                        this.tracer.warn(e, "Exception while executing task: " + task);
                    }
                    this.tracer.debug("Executor: Waiting for new task...");
                }
                finally {
                    if (task == null) continue;
                    ++this.tasksExecuted;
                }
            }
        }
        finally {
            this.tracer.debug("Executor: Stopped.");
            this.finished = true;
        }
    }

    public void stop() {
        this.tracer.debug("Executor: Stopping...");
        this.closed = true;
    }

    public long getNrOfTasksExecuted() {
        return this.tasksExecuted;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

