/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl;

import com.sap.jvm.debugging.Debugger;
import com.sap.jvm.debugging.ThreadChanges;
import com.sap.jvm.debugging.ThreadStateListener;
import com.sap.jvm.debugging.breakpoints.Breakpoint;
import com.sap.jvm.debugging.breakpoints.ExceptionBreakpoint;
import com.sap.jvm.debugging.breakpoints.LineBreakpoint;
import com.sap.jvm.debugging.breakpoints.MethodBciBreakpoint;
import com.sap.jvm.debugging.breakpoints.MethodEntryBreakpoint;
import com.sap.jvm.debugging.breakpoints.MethodExitBreakpoint;
import com.sap.jvm.debugging.breakpoints.MethodLineBreakpoint;
import com.sap.jvm.debugging.breakpoints.TypeLineBreakpoint;
import com.sap.jvm.debugging.breakpoints.WatchPoint;
import com.sap.jvm.debugging.decompiler.AnnotatedPrintStream;
import com.sap.jvm.debugging.impl.ExpressionEvaluationManager;
import com.sap.jvm.debugging.impl.ThreadManager;
import com.sap.jvm.debugging.impl.ThreadNotificationService;
import com.sap.jvm.debugging.impl.breakpoints.AbstractBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.BreakpointManager;
import com.sap.jvm.debugging.impl.breakpoints.ExceptionBreakpointImpl;
import com.sap.jvm.debugging.impl.breakpoints.LineBreakpointImpl;
import com.sap.jvm.debugging.impl.breakpoints.MethodBciBreakpointImpl;
import com.sap.jvm.debugging.impl.breakpoints.MethodEntryBreakpointImpl;
import com.sap.jvm.debugging.impl.breakpoints.MethodExitBreakpointImpl;
import com.sap.jvm.debugging.impl.breakpoints.MethodLineBreakpointImpl;
import com.sap.jvm.debugging.impl.breakpoints.TypeLineBreakpointImpl;
import com.sap.jvm.debugging.impl.breakpoints.WatchPointImpl;
import com.sap.jvm.debugging.impl.decompiler.AnnotatedPrintStreamImpl;
import com.sap.jvm.debugging.impl.decompiler.ConstantPoolEntry;
import com.sap.jvm.debugging.impl.decompiler.Decompiler;
import com.sap.jvm.debugging.impl.decompiler.Disassembler;
import com.sap.jvm.debugging.impl.types.ClassHandleImpl;
import com.sap.jvm.debugging.impl.types.FrameHandleImpl;
import com.sap.jvm.debugging.impl.types.ThreadHandleImpl;
import com.sap.jvm.debugging.types.ClassHandle;
import com.sap.jvm.debugging.types.FrameHandle;
import com.sap.jvm.debugging.types.ThreadHandle;
import com.sap.jvm.jdi.IncompatibleThreadStateException;
import com.sap.jvm.jdi.Method;
import com.sap.jvm.jdi.ObjectReference;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.StackFrame;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.jdi.VMDisconnectedException;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.jdi.connect.Connector;
import com.sap.jvm.jdi.connect.IllegalConnectorArgumentsException;
import com.sap.jvm.jdi.connect.spi.Connection;
import com.sap.jvm.jdi.connect.spi.TransportService;
import com.sap.jvm.jdi.event.BreakpointEvent;
import com.sap.jvm.jdi.event.ClassPrepareEvent;
import com.sap.jvm.jdi.event.Event;
import com.sap.jvm.jdi.event.EventIterator;
import com.sap.jvm.jdi.event.EventQueue;
import com.sap.jvm.jdi.event.EventSet;
import com.sap.jvm.jdi.event.ExceptionEvent;
import com.sap.jvm.jdi.event.MethodEntryEvent;
import com.sap.jvm.jdi.event.MethodExitEvent;
import com.sap.jvm.jdi.event.StepEvent;
import com.sap.jvm.jdi.event.ThreadDeathEvent;
import com.sap.jvm.jdi.event.ThreadStartEvent;
import com.sap.jvm.jdi.event.VMStartEvent;
import com.sap.jvm.jdi.event.WatchpointEvent;
import com.sap.jvm.jdi.request.ClassPrepareRequest;
import com.sap.jvm.tools.jdi.GenericAttachingConnector;
import com.sap.jvm.tools.jdi.SocketConnection;
import com.sap.jvm.tools.jdi.SocketListeningConnector;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import com.sap.jvm.util.misc.SocketAdapter;
import com.sap.jvm.util.misc.SocketAdapterFactory;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;

public class DebuggerImpl
implements Debugger,
Runnable {
    private static final long POLLING_PERIOD_MS = 500L;
    private static final byte[] JDWP_HANDSHAKE = new byte[]{74, 68, 87, 80, 45, 72, 97, 110, 100, 115, 104, 97, 107, 101};
    private final EventQueue queue;
    private final ThreadManager threadManager;
    private final BreakpointManager breakpointManager;
    private final ExpressionEvaluationManager expressionManager;
    private volatile boolean running;
    private boolean includeReturnValues;
    private boolean ignoreLocalVarStored;
    private boolean ignoreParam;
    private boolean ignoreThis;
    private String[] methodsToIgnoreInReturnValues;
    private final ClassPrepareRequest classPrepareRequest;
    private final ThreadNotificationService notificationService;
    private final Tracer tracer;
    private EventSet vmStartEvent;
    private boolean started;
    private final boolean waitForStart;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        final Object breakpointLock = new Object();
        final ThreadHandle[] bpThreads = new ThreadHandle[1];
        DebuggerImpl db = DebuggerImpl.create(args[0], Integer.parseInt(args[1]), new ThreadStateListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void threadStateChanged(Debugger debugger, ThreadChanges changes) {
                System.out.println("Thread started: ");
                for (ThreadHandle thread : changes.getStartedThreads()) {
                    System.out.println(thread.getName() + " (" + thread.getId() + ")");
                }
                System.out.println("Thread stopped: ");
                for (ThreadHandle thread : changes.getStoppedThreads()) {
                    System.out.println(thread.getName() + " (" + thread.getId() + ")");
                }
                System.out.println("Thread state changed: ");
                for (ThreadHandle thread : changes.getChangedThreads()) {
                    System.out.println(thread.getName() + " (" + thread.getId() + "): " + (thread.isSuspended() ? " suspended" : "running"));
                    if (thread.getBreakpointsHit().length > 0) {
                        bpThreads[0] = thread;
                        for (Breakpoint breakpoint : thread.getBreakpointsHit()) {
                            System.out.println("Breakpoint hit: " + breakpoint);
                        }
                    }
                    if (!thread.isSuspended()) continue;
                    for (FrameHandle frame : thread.getFrames()) {
                        System.out.println("    " + frame);
                    }
                }
                if (bpThreads[0] != null) {
                    Object object = breakpointLock;
                    synchronized (object) {
                        breakpointLock.notify();
                    }
                }
            }

            @Override
            public void vmDisconnected() {
                System.out.println("Disconnected");
            }
        }, null, "", false);
        db.resumeAll();
        for (int i = 0; i < 3; ++i) {
            Thread.sleep((int)(Math.random() * 1000.0));
            ThreadHandle[] threads = db.threadManager.getAllThreads();
            if (threads.length <= 0) continue;
            ThreadHandle thread = threads[(int)(Math.random() * (double)threads.length)];
            thread.suspend();
            thread.resume();
        }
        MethodEntryBreakpoint bp = db.createMethodEntryBreakpoint("java.lang.String.hashCode");
        bp.setEnabled(true);
        Object object = breakpointLock;
        synchronized (object) {
            while (bpThreads[0] == null) {
                breakpointLock.wait();
            }
            bpThreads[0].resume();
        }
        Thread.sleep((int)(Math.random() * 1000.0));
    }

    private DebuggerImpl(VirtualMachine vm, ThreadStateListener threadListener, Object context, String sessionSuffix, boolean waitForStart) throws IOException {
        vm.setTraceContext(context);
        vm.setConstantPoolMappingCreator(new ConstantPoolMapper());
        String sessionName = sessionSuffix == null ? "" : sessionSuffix;
        this.tracer = Trace.get((String)"com.sap.jvm.debugging.core.event.handler", (Object)context);
        this.queue = vm.eventQueue();
        this.waitForStart = waitForStart;
        this.expressionManager = new ExpressionEvaluationManager(context);
        this.breakpointManager = new BreakpointManager(vm, this.expressionManager, context);
        this.notificationService = new ThreadNotificationService(threadListener, this, context, sessionName);
        this.threadManager = new ThreadManager(this, this.notificationService, vm, this.expressionManager, context);
        this.running = true;
        this.classPrepareRequest = vm.eventRequestManager().createClassPrepareRequest();
        Thread eventThread = new Thread((Runnable)this, "Debugger-JDI-EventHandler" + sessionName);
        eventThread.setDaemon(true);
        eventThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.classPrepareRequest.setSuspendPolicy(1);
        this.classPrepareRequest.enable();
        if (!this.waitForStart) {
            this.notificationService.start(new InitialThreadsUpdater());
        }
        while (this.running) {
            EventSet eventSet = null;
            try {
                eventSet = this.queue.remove(500L);
                if (eventSet == null) {
                    continue;
                }
            }
            catch (InterruptedException ex) {
                continue;
            }
            catch (VMDisconnectedException ex) {
                this.tracer.debug("Debugger VM has been disconnected. Exiting, bye!");
                this.notificationService.stop();
                return;
            }
            ArrayList<AbstractBreakpoint> breakpoints = new ArrayList<AbstractBreakpoint>();
            ArrayList<ThreadReference> breakpointThreads = new ArrayList<ThreadReference>();
            HashMap<ThreadReference, ObjectReference> exceptions = new HashMap<ThreadReference, ObjectReference>();
            DebuggerImpl debuggerImpl = this;
            synchronized (debuggerImpl) {
                EventIterator eit = eventSet.eventIterator();
                boolean keepSuspended = false;
                boolean isStartEvent = false;
                while (eit.hasNext()) {
                    AbstractBreakpoint breakpoint;
                    Event event = eit.nextEvent();
                    String details = "";
                    if (event instanceof ClassPrepareEvent) {
                        details = " (" + ((ClassPrepareEvent)event).referenceType().name() + ")";
                    }
                    String detailsf = details;
                    this.tracer.debug(() -> "Event: " + event + detailsf);
                    if (event instanceof ThreadStartEvent) {
                        this.notificationService.add(new ThreadStartUpdater((ThreadStartEvent)event));
                        keepSuspended = true;
                        continue;
                    }
                    if (event instanceof ThreadDeathEvent) {
                        this.notificationService.add(new ThreadDeathUpdater((ThreadDeathEvent)event));
                        keepSuspended = true;
                        continue;
                    }
                    if (event instanceof ClassPrepareEvent) {
                        this.breakpointManager.handleClassPrepare((ClassPrepareEvent)event);
                        continue;
                    }
                    if (event instanceof BreakpointEvent) {
                        BreakpointEvent breakpointEvent = (BreakpointEvent)event;
                        breakpoint = this.breakpointManager.getBreakpointFor(breakpointEvent);
                        if (breakpoint == null) continue;
                        breakpoints.add(breakpoint);
                        breakpointThreads.add(breakpointEvent.thread());
                        keepSuspended = true;
                        continue;
                    }
                    if (event instanceof MethodExitEvent) {
                        MethodExitEvent methodExitEvent = (MethodExitEvent)event;
                        breakpoint = this.breakpointManager.getBreakpointFor(methodExitEvent);
                        if (breakpoint == null) continue;
                        breakpoints.add(breakpoint);
                        breakpointThreads.add(methodExitEvent.thread());
                        keepSuspended = true;
                        continue;
                    }
                    if (event instanceof MethodEntryEvent) {
                        MethodEntryEvent methodEntryEvent = (MethodEntryEvent)event;
                        breakpoint = this.breakpointManager.getBreakpointFor(methodEntryEvent);
                        if (breakpoint == null) continue;
                        breakpoints.add(breakpoint);
                        breakpointThreads.add(methodEntryEvent.thread());
                        keepSuspended = true;
                        continue;
                    }
                    if (event instanceof ExceptionEvent) {
                        ExceptionEvent exceptionEvent = (ExceptionEvent)event;
                        breakpoint = this.breakpointManager.getBreakpointFor(exceptionEvent);
                        if (breakpoint == null) continue;
                        breakpoints.add(breakpoint);
                        breakpointThreads.add(exceptionEvent.thread());
                        exceptions.put(exceptionEvent.thread(), exceptionEvent.exception());
                        keepSuspended = true;
                        continue;
                    }
                    if (event instanceof WatchpointEvent) {
                        WatchpointEvent watchpointEvent = (WatchpointEvent)event;
                        breakpoint = this.breakpointManager.getBreakpointFor(watchpointEvent);
                        if (breakpoint == null) continue;
                        breakpoints.add(breakpoint);
                        breakpointThreads.add(watchpointEvent.thread());
                        keepSuspended = true;
                        continue;
                    }
                    if (event instanceof StepEvent) {
                        this.notificationService.add(new ThreadStepUpdater((StepEvent)event));
                        keepSuspended = true;
                        continue;
                    }
                    if (!(event instanceof VMStartEvent) || !this.waitForStart || this.started) continue;
                    isStartEvent = true;
                    keepSuspended = true;
                }
                if (!keepSuspended) {
                    eventSet.resume();
                } else if (isStartEvent) {
                    assert (this.vmStartEvent == null);
                    this.vmStartEvent = eventSet;
                } else if (!breakpoints.isEmpty()) {
                    this.notificationService.add(new BreakpointUpdater(breakpoints, breakpointThreads, exceptions, eventSet.suspendPolicy() == 2));
                }
            }
        }
        this.tracer.debug("Disconnecting debugger from VM. Exiting, bye!");
        this.notificationService.stop();
        try {
            this.queue.virtualMachine().dispose();
        }
        catch (VMDisconnectedException e) {
            this.tracer.debug("Caught VMDisconnectedException at the end of DebuggerThread. Probably due to shutdown.");
        }
    }

    @Override
    public void disconnect() {
        this.running = false;
    }

    @Override
    public MethodEntryBreakpoint createMethodEntryBreakpoint(String method) {
        return new MethodEntryBreakpointImpl(this.breakpointManager, method);
    }

    @Override
    public MethodExitBreakpoint createMethodExitBreakpoint(String method) {
        return new MethodExitBreakpointImpl(this.breakpointManager, method);
    }

    @Override
    public MethodLineBreakpoint createMethodLineBreakpoint(String method, int lineNr, boolean isRelative) {
        return new MethodLineBreakpointImpl(this.breakpointManager, method, lineNr, isRelative);
    }

    @Override
    public MethodBciBreakpoint createMethodBciBreakpoint(String method, int bci) {
        return new MethodBciBreakpointImpl(this.breakpointManager, method, bci);
    }

    @Override
    public ExceptionBreakpoint createExceptionBreakpoint(String exception, boolean isCaught, boolean isUncaught, boolean subtypes) {
        return new ExceptionBreakpointImpl(this.breakpointManager, exception, isCaught, isUncaught, subtypes);
    }

    @Override
    public WatchPoint createWatchPoint(String className, String fieldName, boolean isAccess, boolean isModification) {
        return new WatchPointImpl(this.breakpointManager, className, fieldName, isAccess, isModification);
    }

    @Override
    public LineBreakpoint createLineBreakpoint(String file, int lineNr, String className) {
        return new LineBreakpointImpl(this.breakpointManager, file, lineNr, className);
    }

    @Override
    public TypeLineBreakpoint createTypeLineBreakpoint(int lineNr, String className) {
        return new TypeLineBreakpointImpl(this.breakpointManager, lineNr, className);
    }

    @Override
    public void setSkipAllBreakpoints(boolean skipAllBreakpoints) {
        this.breakpointManager.setSkipAllBreakpoints(skipAllBreakpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        DebuggerImpl debuggerImpl = this;
        synchronized (debuggerImpl) {
            if (!this.started) {
                if (this.waitForStart) {
                    this.notificationService.start(new InitialThreadsUpdater());
                }
                this.started = true;
                if (this.vmStartEvent != null) {
                    this.vmStartEvent.resume();
                }
                this.vmStartEvent = null;
            }
        }
    }

    @Override
    public void resumeAll() {
        this.threadManager.resumeAll();
    }

    @Override
    public void suspendAll() {
        this.threadManager.suspendAll();
    }

    @Override
    public void exitVm(int exitCode) {
        this.queue.virtualMachine().exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String redefineClasses(Map<String, byte[]> classBytes) {
        VirtualMachine vm = this.queue.virtualMachine();
        HashMap<ReferenceType, byte[]> classToBytes = new HashMap<ReferenceType, byte[]>();
        for (Map.Entry<String, byte[]> entry : classBytes.entrySet()) {
            this.tracer.debug(() -> "Redefining class " + (String)entry.getKey());
            List<ReferenceType> classesByName = vm.classesByName(entry.getKey());
            for (ReferenceType clazz : classesByName) {
                if (!clazz.isPrepared()) continue;
                classToBytes.put(clazz, entry.getValue());
            }
        }
        String message = null;
        try {
            vm.redefineClasses(classToBytes);
        }
        catch (ClassCircularityError | ClassFormatError | NoClassDefFoundError | UnsupportedOperationException | VerifyError e) {
            message = e.getClass().getName() + (e.getMessage() == null ? "" : ": " + e.getMessage());
        }
        for (ReferenceType clazz : classToBytes.keySet()) {
            this.breakpointManager.handleNewClass(clazz);
        }
        if (message == null) {
            block18: for (ThreadHandle thread : this.threadManager.getAllThreads()) {
                if (!thread.isSuspended()) continue;
                Lock classRedefinitionLock = this.expressionManager.getClassRedefinitionLock(thread.getId());
                Lock evaluationLock = this.expressionManager.getEvaluationLock(thread.getId());
                this.expressionManager.lockEvaluationLock(classRedefinitionLock);
                try {
                    this.expressionManager.lockEvaluationLock(evaluationLock);
                    thread.refresh();
                    FrameHandle[] frames = thread.getFrames();
                    for (int i = frames.length - 2; i >= 0; --i) {
                        StackFrame f = ((FrameHandleImpl)frames[i]).getFrame();
                        Method method = f.location().method();
                        if (!method.isObsolete()) continue;
                        this.tracer.debug(() -> "Found obsolete method in thread '" + thread.getName() + "': " + method);
                        ThreadHandleImpl t = (ThreadHandleImpl)thread;
                        try {
                            t.getReference().popFrames(f);
                            thread.refresh();
                            try {
                                this.expressionManager.unlockEvaluationLock(evaluationLock);
                            }
                            finally {
                                evaluationLock = null;
                            }
                            thread.stepInto();
                        }
                        catch (IncompatibleThreadStateException e) {
                            this.tracer.warn((Throwable)e, "Impossible exception while popping frames from thread \"" + thread.getName() + "\"");
                        }
                        continue block18;
                    }
                }
                finally {
                    try {
                        if (evaluationLock != null) {
                            this.expressionManager.unlockEvaluationLock(evaluationLock);
                        }
                    }
                    finally {
                        this.expressionManager.unlockEvaluationLock(classRedefinitionLock);
                    }
                }
            }
        }
        return message;
    }

    @Override
    public AnnotatedPrintStream getDisassembly(ClassHandle clazz) {
        return this.getDisassembly(((ClassHandleImpl)clazz).getReferenceType());
    }

    @Override
    public AnnotatedPrintStream getDisassembly(String className, long classObjectId) {
        return this.getDisassembly(this.getClassByName(className, classObjectId));
    }

    @Override
    public AnnotatedPrintStream getDecompiledCode(ClassHandle clazz) {
        return this.getDecompiledCode(((ClassHandleImpl)clazz).getReferenceType());
    }

    @Override
    public AnnotatedPrintStream getDecompiledCode(String className, long classObjectId) {
        return this.getDecompiledCode(this.getClassByName(className, classObjectId));
    }

    @Override
    public void setReturnValuesAsVariables(boolean enabled, boolean ignoreLocalVarStored, boolean ignoreParam, boolean ignoreThis, String[] methodsToIgnore) {
        this.includeReturnValues = enabled;
        this.ignoreLocalVarStored = ignoreLocalVarStored;
        this.ignoreParam = ignoreParam;
        this.ignoreThis = ignoreThis;
        this.methodsToIgnoreInReturnValues = methodsToIgnore;
    }

    public boolean includeReturnValues() {
        return this.includeReturnValues;
    }

    public boolean ignoreReturnValuesStoredInLocalVars() {
        return this.ignoreLocalVarStored;
    }

    public boolean ignoreReturnValuesUsedAsParameter() {
        return this.ignoreParam;
    }

    public boolean ignoreReturnValuesUsedAsReceiver() {
        return this.ignoreThis;
    }

    public boolean shouldShowReturnValue(String method) {
        for (String regexp : this.methodsToIgnoreInReturnValues) {
            if (!method.matches(regexp)) continue;
            return false;
        }
        return true;
    }

    private ReferenceType getClassByName(String className, long classObjectId) {
        List<ReferenceType> classes = this.queue.virtualMachine().classesByName(className);
        if (classes.size() == 0) {
            throw new IllegalStateException("Class '" + className + "' not found");
        }
        ReferenceType clazz = null;
        if (classObjectId == 0L) {
            clazz = classes.get(0);
        } else {
            for (ReferenceType ref : classes) {
                if (ref.classObject().uniqueID() != classObjectId) continue;
                clazz = ref;
                break;
            }
        }
        if (clazz == null) {
            throw new IllegalStateException("Class '" + className + "' with id " + classObjectId + " not found");
        }
        return clazz;
    }

    private AnnotatedPrintStream getDisassembly(ReferenceType clazz) {
        AnnotatedPrintStreamImpl result = new AnnotatedPrintStreamImpl(clazz);
        new Disassembler(clazz).print(result);
        return result;
    }

    private AnnotatedPrintStream getDecompiledCode(ReferenceType clazz) {
        AnnotatedPrintStreamImpl result = new AnnotatedPrintStreamImpl(clazz);
        new Decompiler(clazz).print(result, null);
        return result;
    }

    @Override
    public AnnotatedPrintStream createStream(String className, long classObjectId) {
        return new AnnotatedPrintStreamImpl(className, classObjectId);
    }

    public static DebuggerImpl create(String hostame, int port, ThreadStateListener threadListener, Object context, String sessionSuffix, boolean waitForStart) throws IOException {
        Socket socket = new Socket(hostame, port);
        socket.getOutputStream().write(JDWP_HANDSHAKE);
        byte[] response = new byte[JDWP_HANDSHAKE.length];
        socket.getInputStream().read(response);
        if (!Arrays.equals(JDWP_HANDSHAKE, response)) {
            socket.close();
            throw new IOException("Initial handshake failed");
        }
        return DebuggerImpl.create(SocketAdapterFactory.getForSocket((Socket)socket), threadListener, context, sessionSuffix, waitForStart);
    }

    public static DebuggerImpl create(SocketAdapter socket, ThreadStateListener threadListener, Object context, String sessionSuffix, boolean waitForStart) throws IOException {
        GenericAttachingConnector vmConnector = new GenericAttachingConnector(new OpenedSocketTransportService(socket), true);
        try {
            return new DebuggerImpl(vmConnector.attach(vmConnector.defaultArguments()), threadListener, context, sessionSuffix, waitForStart);
        }
        catch (IllegalConnectorArgumentsException e) {
            throw new IOException("Connector arguments are wrong", e);
        }
    }

    public static DebuggerImpl create(int port, ThreadStateListener threadListener, Object context, String sessionSuffix, boolean waitForStart) throws IOException {
        SocketListeningConnector vmConnector = new SocketListeningConnector();
        Map<String, Connector.Argument> arguments = vmConnector.defaultArguments();
        arguments.get("port").setValue(Integer.toString(port));
        try {
            String address = vmConnector.startListening(arguments);
            Tracer tr = Trace.get((String)"com.sap.jvm.debugging.core.event.handler", (Object)context);
            if (port == 0) {
                tr.warn(() -> "Listening on " + address + " for connection requests by debuggee.");
            } else {
                tr.debug(() -> "Listening on " + address + " for connection requests by debuggee.");
            }
            DebuggerImpl result = new DebuggerImpl(vmConnector.accept(arguments), threadListener, context, sessionSuffix, waitForStart);
            vmConnector.stopListening(arguments);
            return result;
        }
        catch (IllegalConnectorArgumentsException e) {
            IOException e2 = new IOException("Connector arguments are wrong");
            e2.initCause(e);
            throw e2;
        }
    }

    private class ConstantPoolMapper
    implements VirtualMachine.ConstantPoolMappingCreator {
        private ConstantPoolMapper() {
        }

        @Override
        public Map<String, String> createNameMapping(byte[] constantPool, int constantPoolEntries) {
            HashMap<String, String> result = new HashMap<String, String>();
            DataInputStream di = new DataInputStream(new ByteArrayInputStream(constantPool));
            try {
                ConstantPoolEntry[] cp;
                for (ConstantPoolEntry entry : cp = Decompiler.readConstantPool(constantPoolEntries, di)) {
                    if (entry == null || entry.getType() != 7) continue;
                    entry.resolve(cp);
                    String fullName = entry.getExternalClass();
                    int lastDot = fullName.lastIndexOf(46);
                    if (lastDot < 0) {
                        result.put(fullName, fullName);
                        continue;
                    }
                    result.put(fullName.substring(lastDot + 1), fullName);
                }
            }
            catch (IOException e) {
                DebuggerImpl.this.tracer.warn((Throwable)e, "Exception while creating class name mapping from constant pool");
            }
            return result;
        }
    }

    private static class OpenedSocketTransportService
    extends TransportService {
        private final SocketAdapter socket;

        public OpenedSocketTransportService(SocketAdapter socket) {
            this.socket = socket;
        }

        @Override
        public String name() {
            return "opened socket";
        }

        @Override
        public String description() {
            return "opened socket";
        }

        @Override
        public TransportService.Capabilities capabilities() {
            return new TransportService.Capabilities(){

                @Override
                public boolean supportsMultipleConnections() {
                    return false;
                }

                @Override
                public boolean supportsHandshakeTimeout() {
                    return false;
                }

                @Override
                public boolean supportsAttachTimeout() {
                    return false;
                }

                @Override
                public boolean supportsAcceptTimeout() {
                    return false;
                }
            };
        }

        @Override
        public Connection attach(String address, long attachTimeout, long handshakeTimeout) throws IOException {
            return new SocketConnection(this.socket);
        }

        @Override
        public TransportService.ListenKey startListening(String address) throws IOException {
            throw new RuntimeException("Not supported");
        }

        @Override
        public TransportService.ListenKey startListening() throws IOException {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void stopListening(TransportService.ListenKey listenKey) throws IOException {
            throw new RuntimeException("Not supported");
        }

        @Override
        public Connection accept(TransportService.ListenKey listenKey, long acceptTimeout, long handshakeTimeout) throws IOException {
            return new SocketConnection(this.socket);
        }
    }

    private class BreakpointUpdater
    extends ThreadUpdater {
        private final List<AbstractBreakpoint> breakpoints;
        private final List<ThreadReference> breakpointThreads;
        private final Map<ThreadReference, ObjectReference> exceptions;
        private final boolean suspendAll;

        public BreakpointUpdater(List<AbstractBreakpoint> breakpoints, List<ThreadReference> breakpointThreads, Map<ThreadReference, ObjectReference> exceptions, boolean suspendAll) {
            this.breakpoints = breakpoints;
            this.breakpointThreads = breakpointThreads;
            this.exceptions = exceptions;
            this.suspendAll = suspendAll;
        }

        @Override
        public ThreadChanges call() throws Exception {
            DebuggerImpl.this.threadManager.handleBreakpoints(this.breakpoints, this.breakpointThreads, this.exceptions, this.suspendAll);
            return super.call();
        }
    }

    private class ThreadStepUpdater
    extends ThreadUpdater {
        private final StepEvent event;

        public ThreadStepUpdater(StepEvent event) {
            this.event = event;
        }

        @Override
        public ThreadChanges call() throws Exception {
            DebuggerImpl.this.threadManager.handleStepEvent(this.event);
            return super.call();
        }
    }

    private class ThreadDeathUpdater
    extends ThreadUpdater {
        private final ThreadDeathEvent event;

        public ThreadDeathUpdater(ThreadDeathEvent event) {
            this.event = event;
        }

        @Override
        public ThreadChanges call() throws Exception {
            ThreadHandle handle = DebuggerImpl.this.threadManager.handleThreadDeathEvent(this.event);
            return ThreadChanges.createForStopped(new ThreadHandle[]{handle});
        }
    }

    private class ThreadStartUpdater
    extends ThreadUpdater {
        private final ThreadStartEvent event;

        public ThreadStartUpdater(ThreadStartEvent event) {
            this.event = event;
        }

        @Override
        public ThreadChanges call() throws Exception {
            ThreadHandle handle = DebuggerImpl.this.threadManager.handleThreadStartEvent(this.event);
            return ThreadChanges.createForStarted(new ThreadHandle[]{handle});
        }
    }

    private class ThreadUpdater
    implements Callable<ThreadChanges> {
        private ThreadUpdater() {
        }

        @Override
        public ThreadChanges call() throws Exception {
            return ThreadChanges.createForChanged(DebuggerImpl.this.threadManager.getAllThreadsInternal());
        }
    }

    private class InitialThreadsUpdater
    implements Callable<ThreadChanges> {
        private InitialThreadsUpdater() {
        }

        @Override
        public ThreadChanges call() throws Exception {
            return ThreadChanges.createForStarted(DebuggerImpl.this.threadManager.handleVmStart());
        }
    }
}

