/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl;

import com.sap.jvm.jdi.ClassNotLoadedException;
import com.sap.jvm.jdi.IncompatibleThreadStateException;
import com.sap.jvm.jdi.InvalidTypeException;
import com.sap.jvm.jdi.InvocationException;
import com.sap.jvm.jdi.Method;
import com.sap.jvm.jdi.ObjectCollectedException;
import com.sap.jvm.jdi.ObjectReference;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.jdi.Value;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.tools.example.debug.expr.ExpressionParser;
import com.sap.jvm.tools.example.debug.expr.ParseException;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ExpressionEvaluationManager {
    private static final int LOCK_PERIOD_MS = 10;
    private final ConcurrentMap<Long, Long> evaluatingThreads = new ConcurrentHashMap<Long, Long>();
    private final ConcurrentMap<Long, Lock> expressionLocks = new ConcurrentHashMap<Long, Lock>();
    private final ConcurrentMap<Long, Lock> classRedefinitionLocks = new ConcurrentHashMap<Long, Lock>();
    private final Lock unknownThreadLock = new ReentrantLock();
    private final Tracer tracer;

    public ExpressionEvaluationManager(Object context) {
        this.tracer = Trace.get((String)"com.sap.jvm.debugging.core.expressions", (Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evaluate(String expr, VirtualMachine vm, ExpressionParser.GetFrame frameGetter, long threadId) throws ParseException, InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        Lock classRefinitionLock = this.getClassRedefinitionLock(threadId);
        Lock lock = this.getEvaluationLock(threadId);
        this.lockEvaluationLock(classRefinitionLock);
        this.lockEvaluationLock(lock);
        assert (!this.evaluatingThreads.containsKey(threadId));
        this.evaluatingThreads.put(threadId, threadId);
        if (frameGetter.get().thread().hasTopNativeFrame()) {
            throw new IncompatibleThreadStateException("Cannot evaluate expressions while having a native top frame");
        }
        ObjectCollectedException exception = null;
        for (int i = 0; i < 2; ++i) {
            try {
                Value value = ExpressionParser.evaluate(expr, vm, frameGetter);
                return value;
            }
            catch (ObjectCollectedException e) {
                Trace.warn((Throwable)e, () -> "Object collected during expression evaluation: expression=" + expr);
                exception = e;
                continue;
            }
        }
        Trace.error(exception, () -> "Object collected during expression evaluation: expression=" + expr);
        throw exception;
        {
            finally {
                try {
                    this.evaluatingThreads.remove(threadId);
                }
                finally {
                    this.unlockEvaluationLock(lock);
                }
            }
        }
        finally {
            this.unlockEvaluationLock(classRefinitionLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value invokeMethod(ObjectReference ref, ThreadReference thread, Method method, List<? extends Value> arguments) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        Lock classRefinitionLock = this.getClassRedefinitionLock(thread.uniqueID());
        Lock lock = this.getEvaluationLock(thread.uniqueID());
        this.lockEvaluationLock(classRefinitionLock);
        try {
            Value value;
            this.lockEvaluationLock(lock);
            try {
                assert (!this.evaluatingThreads.containsKey(thread.uniqueID()));
                this.evaluatingThreads.put(thread.uniqueID(), thread.uniqueID());
                if (thread.hasTopNativeFrame()) {
                    throw new IncompatibleThreadStateException("Cannot invoke methods while having a native top frame");
                }
                value = ref.invokeMethod(thread, method, arguments, 1);
            }
            catch (Throwable throwable) {
                try {
                    this.evaluatingThreads.remove(thread.uniqueID());
                }
                finally {
                    this.unlockEvaluationLock(lock);
                }
                throw throwable;
            }
            try {
                this.evaluatingThreads.remove(thread.uniqueID());
            }
            finally {
                this.unlockEvaluationLock(lock);
            }
            return value;
        }
        finally {
            this.unlockEvaluationLock(classRefinitionLock);
        }
    }

    public boolean isEvaluatingExpression(long threadId) {
        return this.evaluatingThreads.containsKey(threadId);
    }

    public Lock getEvaluationLock(long threadId) {
        Lock result = (Lock)this.expressionLocks.get(threadId);
        if (result != null) {
            return result;
        }
        this.tracer.warn("Expression-Evaluation: Lock requested for unknown thread with id " + threadId);
        return this.unknownThreadLock;
    }

    public Lock getClassRedefinitionLock(long threadId) {
        Lock result = (Lock)this.classRedefinitionLocks.get(threadId);
        if (result != null) {
            return result;
        }
        this.tracer.warn("Expression-Evaluation: Lock requested for unknown thread with id " + threadId);
        return this.unknownThreadLock;
    }

    public void lockEvaluationLock(Lock lock) {
        int i = 0;
        while (true) {
            ++i;
            try {
                if (lock.tryLock(10L, TimeUnit.MILLISECONDS)) {
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (i % 100 == 0) {
                this.tracer.warn("Expression-Evaluation: Failed to acquire lock in " + i + ". iteration.");
                continue;
            }
            int fi = i;
            this.tracer.debug(() -> "Expression-Evaluation: Failed to acquire lock in " + fi + ". iteration.");
        }
    }

    public void unlockEvaluationLock(Lock lock) {
        lock.unlock();
    }

    public void threadStarted(long threadId) {
        assert (!this.expressionLocks.containsKey(threadId));
        this.expressionLocks.putIfAbsent(threadId, new ReentrantLock());
        assert (!this.classRedefinitionLocks.containsKey(threadId));
        this.classRedefinitionLocks.putIfAbsent(threadId, new ReentrantLock());
    }

    public void threadStopped(long threadId) {
        assert (this.expressionLocks.containsKey(threadId));
        this.expressionLocks.remove(threadId);
        assert (this.classRedefinitionLocks.containsKey(threadId));
        this.classRedefinitionLocks.remove(threadId);
    }
}

