/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl;

import com.sap.jvm.debugging.impl.DebuggerImpl;
import com.sap.jvm.debugging.impl.decompiler.ByteCode;
import com.sap.jvm.debugging.impl.decompiler.ByteCodeReader;
import com.sap.jvm.debugging.impl.decompiler.ConstantPoolEntry;
import com.sap.jvm.debugging.impl.decompiler.MethodInfo;
import com.sap.jvm.debugging.impl.decompiler.TrackingStack;
import com.sap.jvm.debugging.impl.decompiler.TrackingStackCreator;
import com.sap.jvm.debugging.impl.decompiler.ast.Type;
import com.sap.jvm.tools.jdi.StackTracker;
import com.sap.jvm.tools.jdi.StackTrackerEntry;
import com.sap.jvm.util.misc.SignatureHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class StackTrackerHelper {
    private final LinkedHashMap<String, StackTrackerEntry> entries = new LinkedHashMap();
    private final LinkedHashMap<ReturnKey, StackTrackerEntry> returnEntries = new LinkedHashMap();

    private StackTrackerHelper(TrackingStackCreator tsc, int[] bcis, boolean includeParameters, DebuggerImpl debugger) {
        int[] allBics = tsc.getBcis();
        HashSet<Integer> realBcis = new HashSet<Integer>();
        for (int bci : bcis == null ? allBics : bcis) {
            realBcis.add(bci);
        }
        MethodInfo methodInfo = tsc.getMethodInfo();
        byte[] code = methodInfo.getCode();
        Iterator iterator = realBcis.iterator();
        while (iterator.hasNext()) {
            int i;
            int slot;
            int bci;
            bci = (Integer)iterator.next();
            int bc = tsc.getByteCode(bci);
            if (debugger.includeReturnValues() && ByteCode.isNonInvokeDynamikCall(bc)) {
                int nextBc;
                boolean shouldTrack;
                int nextBci = bci + ByteCode.getSize(bci, methodInfo);
                TrackingStack stack = tsc.getStack(nextBci);
                int tos = stack.size() - 1;
                boolean bl = shouldTrack = tos >= 0 && stack.get(0)[0] == bci;
                if (debugger.ignoreReturnValuesStoredInLocalVars() && ByteCode.isLocalVariableStore(nextBc = tsc.getByteCode(nextBci))) {
                    shouldTrack = false;
                }
                if (debugger.ignoreReturnValuesUsedAsParameter() || debugger.ignoreReturnValuesUsedAsReceiver()) {
                    for (int bci2 : allBics) {
                        int[] s2;
                        int[] s1;
                        if (bci2 == bci || !ByteCode.isNonInvokeDynamikCall(tsc.getByteCode(bci2))) continue;
                        TrackingStack stack1 = tsc.getStack(bci2);
                        TrackingStack stack2 = tsc.getStack(bci2 + ByteCode.getSize(bci2, methodInfo));
                        int b1 = stack1.size() - 1;
                        for (int b2 = stack2.size() - 1; b1 >= 0 && b2 >= 0 && Arrays.equals(s1 = stack1.get(b1), s2 = stack2.get(b2)); --b1, --b2) {
                        }
                        boolean isThis = tsc.getByteCode(bci2) != 184;
                        for (slot = b1; slot >= 0; --slot) {
                            int[] s = stack1.get(slot);
                            if (s.length == 1 && s[0] == bci) {
                                if (isThis && debugger.ignoreReturnValuesUsedAsReceiver()) {
                                    shouldTrack = false;
                                    break;
                                }
                                if (isThis || !debugger.ignoreReturnValuesUsedAsParameter()) break;
                                shouldTrack = false;
                                break;
                            }
                            isThis = false;
                        }
                        if (!shouldTrack) break;
                    }
                }
                if (shouldTrack) {
                    int slot2 = tos;
                    if (stack.getTypes(0)[0].isSecondSlotType()) {
                        --slot2;
                    }
                    StackTrackerEntry entry = new StackTrackerEntry(nextBci, stack.getTypes(0)[0].getInternalType(), slot2);
                    ByteCodeReader reader = new ByteCodeReader(code, bci + ByteCode.getByteCodeParameterOffset(bc));
                    int cpSlot = reader.readUint16();
                    ReturnKey key = new ReturnKey(methodInfo.getCpEntry(cpSlot), bci);
                    if (debugger.shouldShowReturnValue(key.full)) {
                        this.returnEntries.put(key, entry);
                    }
                }
            }
            if (!includeParameters || !realBcis.contains(bci) || !ByteCode.isNonInvokeDynamikCall(bc)) continue;
            ByteCodeReader reader = new ByteCodeReader(code, bci + ByteCode.getByteCodeParameterOffset(bc));
            int cpSlot = reader.readUint16();
            String methodName = methodInfo.getCpEntry(cpSlot).getReferenceName();
            String methodSig = methodInfo.getCpEntry(cpSlot).getReferenceType();
            TrackingStack stack = tsc.getStack(bci);
            int tos = stack.size() - 1;
            boolean hasThis = bc != 184;
            ArrayList<Type> parameters = new ArrayList<Type>();
            if (hasThis) {
                parameters.add(new Type("L" + methodName.replace('.', '/') + ";"));
            }
            boolean inArray = false;
            boolean inObject = false;
            StringBuilder curr = new StringBuilder();
            char[] b2 = methodSig.toCharArray();
            int isThis = b2.length;
            for (slot = 0; slot < isThis; ++slot) {
                char c = b2[slot];
                curr.append(c);
                if (c == '(') {
                    curr = new StringBuilder();
                    continue;
                }
                if (c == ')') break;
                if (c == '[') {
                    inArray = true;
                    continue;
                }
                if (c == 'L') {
                    inObject = true;
                    continue;
                }
                if (c == 'Z' || c == 'B' || c == 'S' || c == 'C' || c == 'I' || c == 'F' || c == 'J' || c == 'D') {
                    if (!inArray && !inObject) {
                        parameters.add(new Type(curr.toString()));
                        curr = new StringBuilder();
                    }
                    if (!inArray || inObject) continue;
                    parameters.add(new Type(curr.toString()));
                    curr = new StringBuilder();
                    inArray = false;
                    continue;
                }
                if (c != ';') continue;
                parameters.add(new Type(curr.toString()));
                inArray = false;
                inObject = false;
            }
            int slot3 = tos;
            int[] slots = new int[parameters.size()];
            for (i = parameters.size() - 1; i >= 0; --i) {
                slots[i] = slot3;
                if (stack.getTypes(tos - slot3)[0].isSecondSlotType()) {
                    slots[i] = slot3 - 1;
                    slot3 -= 2;
                    continue;
                }
                --slot3;
            }
            for (i = 0; i < parameters.size(); ++i) {
                slot3 = slots[i];
                StackTrackerEntry entry = new StackTrackerEntry(bci, stack.getTypes(tos - slot3)[0].getInternalType(), slot3);
                String paramName = hasThis ? (i == 0 ? "this" : "param" + i) : "param" + (i + 1);
                String name = this.getUniqueName("<" + methodName + " '" + paramName + "' value>", "<" + methodName + " call %i '" + paramName + "' value>");
                this.entries.put(name, entry);
            }
        }
        if (debugger.includeReturnValues()) {
            HashMap<String, Integer> counts = new HashMap<String, Integer>();
            for (ReturnKey key : this.returnEntries.keySet()) {
                HashSet<String> ownNames = new HashSet<String>();
                for (String name : key.names) {
                    if (ownNames.contains(name)) continue;
                    ownNames.add(name);
                    if (counts.containsKey(name)) {
                        counts.put(name, 1 + (Integer)counts.get(name));
                        continue;
                    }
                    counts.put(name, 1);
                }
            }
            block10: for (ReturnKey key : this.returnEntries.keySet()) {
                StackTrackerEntry entry = this.returnEntries.get(key);
                for (String name : key.names) {
                    if ((Integer)counts.get(name) != 1) continue;
                    this.entries.put("<" + name + " returns>", entry);
                    continue block10;
                }
            }
        }
    }

    public static LinkedHashMap<String, StackTrackerEntry> getEntriesForStackTracker(TrackingStackCreator tsc, StackTracker tracker, boolean includeParameters, DebuggerImpl debugger) {
        Object prevBcis;
        LinkedHashSet<Integer> bcis = new LinkedHashSet<Integer>();
        for (StackTrackerEntry entry : tracker) {
            bcis.add(entry.getBci());
            if (!debugger.includeReturnValues() || (prevBcis = tsc.getPrevBcis(entry.getBci())) == null || ((ArrayList)prevBcis).size() != 1) continue;
            bcis.add((Integer)((ArrayList)prevBcis).get(0));
        }
        int[] bciArray = new int[bcis.size()];
        int i = 0;
        prevBcis = bcis.iterator();
        while (prevBcis.hasNext()) {
            int bci;
            bciArray[i] = bci = ((Integer)prevBcis.next()).intValue();
            ++i;
        }
        StackTrackerHelper helper = new StackTrackerHelper(tsc, bciArray, includeParameters, debugger);
        LinkedHashMap<String, StackTrackerEntry> result = new LinkedHashMap<String, StackTrackerEntry>();
        for (Map.Entry<String, StackTrackerEntry> entry : helper.entries.entrySet()) {
            StackTrackerEntry realEntry = tracker.get(entry.getValue().getBci(), entry.getValue().getSlot());
            if (realEntry == null || !realEntry.isValid()) continue;
            result.put(entry.getKey(), realEntry);
        }
        return result;
    }

    public static StackTracker getStackTrackerForBcis(TrackingStackCreator tsc, int[] bcis, boolean includeParameters, DebuggerImpl debugger) {
        StackTrackerHelper helper = new StackTrackerHelper(tsc, bcis, includeParameters, debugger);
        StackTracker result = new StackTracker();
        for (StackTrackerEntry entry : helper.entries.values()) {
            result.add(entry);
        }
        return result;
    }

    private String getUniqueName(String initialName, String template) {
        if (!this.entries.containsKey(initialName)) {
            return initialName;
        }
        for (int i = 2; i < Integer.MAX_VALUE; ++i) {
            String result = template.replace("%i", Integer.toString(i, 10));
            if (this.entries.containsKey(result)) continue;
            return result;
        }
        return null;
    }

    public static class ReturnKey {
        public final int bci;
        public final String[] names;
        public final String full;

        public static String shortenSig(String sig) {
            char[] raw = sig.toCharArray();
            int index = raw.length - 1;
            boolean isInPacakge = false;
            for (int i = index; i >= 0; --i) {
                char c = raw[i];
                if (isInPacakge) {
                    if (c == ',' || c == ' ' || c == ')' || c == '(') {
                        isInPacakge = false;
                    }
                } else if (c == '.') {
                    isInPacakge = true;
                }
                if (isInPacakge) continue;
                raw[index] = raw[i];
                --index;
            }
            return new String(raw, index + 1, raw.length - index - 1);
        }

        public ReturnKey(ConstantPoolEntry cpEntry, int bci) {
            this.bci = bci;
            String methodName = cpEntry.getReferenceName();
            String fullClassName = cpEntry.getReferenceClass().replace('/', '.');
            String shortClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
            String fullSig = SignatureHelper.toExternalSignature((String)cpEntry.getReferenceType());
            String fullSigNoReturn = fullSig.substring(0, fullSig.indexOf(41) + 1);
            String shortSig = ReturnKey.shortenSig(fullSig);
            String shortSigNoReturn = ReturnKey.shortenSig(fullSigNoReturn);
            String singleMethod = shortSigNoReturn.length() < 15 ? methodName + shortSigNoReturn : methodName + "(...)";
            this.full = fullClassName + "." + methodName + fullSig;
            this.names = new String[]{shortClassName + "." + singleMethod, fullClassName + "." + singleMethod, shortClassName + "." + methodName + shortSigNoReturn, fullClassName + "." + methodName + shortSigNoReturn, shortClassName + "." + methodName + shortSig, fullClassName + "." + methodName + shortSig, shortClassName + "." + methodName + fullSigNoReturn, fullClassName + "." + methodName + fullSigNoReturn, shortClassName + "." + methodName + fullSig, fullClassName + "." + methodName + fullSig, shortClassName + "." + singleMethod + " @ bci " + bci};
        }

        public int hashCode() {
            return this.bci;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ReturnKey) {
                return ((ReturnKey)obj).bci == this.bci;
            }
            return false;
        }
    }
}

