/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl;

import com.sap.jvm.debugging.ThreadChanges;
import com.sap.jvm.debugging.breakpoints.Breakpoint;
import com.sap.jvm.debugging.impl.DebuggerImpl;
import com.sap.jvm.debugging.impl.ExpressionEvaluationManager;
import com.sap.jvm.debugging.impl.ThreadNotificationService;
import com.sap.jvm.debugging.impl.breakpoints.AbstractBreakpoint;
import com.sap.jvm.debugging.impl.types.ThreadHandleImpl;
import com.sap.jvm.debugging.types.ThreadHandle;
import com.sap.jvm.jdi.BooleanValue;
import com.sap.jvm.jdi.Field;
import com.sap.jvm.jdi.ObjectReference;
import com.sap.jvm.jdi.PrimitiveValue;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.jdi.event.StepEvent;
import com.sap.jvm.jdi.event.ThreadDeathEvent;
import com.sap.jvm.jdi.event.ThreadStartEvent;
import com.sap.jvm.jdi.request.StepRequest;
import com.sap.jvm.jdi.request.ThreadDeathRequest;
import com.sap.jvm.jdi.request.ThreadStartRequest;
import com.sap.jvm.tools.jdi.StackTracker;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class ThreadManager {
    private final HashMap<Long, ThreadHandleImpl> threads;
    private final HashSet<Long> runningThreads;
    private final HashMap<Long, StepRequest> stepRequests;
    private final VirtualMachine vm;
    private final ThreadStartRequest startRequest;
    private final ThreadDeathRequest stopRequest;
    private final ThreadNotificationService notificationService;
    private volatile boolean daemonFieldInitialized = false;
    private Field daemonField = null;
    private final Tracer tracer;
    private final ExpressionEvaluationManager expressionManager;
    private final DebuggerImpl debugger;

    public ThreadManager(DebuggerImpl debugger, ThreadNotificationService service, VirtualMachine vm, ExpressionEvaluationManager expressionManager, Object context) throws IOException {
        this.debugger = debugger;
        this.tracer = Trace.get((String)"com.sap.jvm.debugging.impl.threadmanager", (Object)context);
        this.threads = new HashMap();
        this.runningThreads = new HashSet();
        this.stepRequests = new HashMap();
        this.notificationService = service;
        this.vm = vm;
        this.expressionManager = expressionManager;
        this.startRequest = vm.eventRequestManager().createThreadStartRequest();
        this.stopRequest = vm.eventRequestManager().createThreadDeathRequest();
        this.startRequest.setSuspendPolicy(1);
        this.stopRequest.setSuspendPolicy(1);
        this.startRequest.enable();
        this.stopRequest.enable();
    }

    public DebuggerImpl getDebugger() {
        return this.debugger;
    }

    public ExpressionEvaluationManager getExpressionManager() {
        return this.expressionManager;
    }

    public ThreadHandle handleThreadStartEvent(ThreadStartEvent event) {
        boolean isNew;
        assert (this.notificationService.isInNotificationThread());
        if (event.request() != this.startRequest) {
            this.tracer.debug(() -> "Got thread start event for thread '" + event.thread().name() + "'@" + event.thread().uniqueID() + ", but had the wrong request.");
            return null;
        }
        ThreadHandleImpl handle = new ThreadHandleImpl(this, event.thread(), true, null, false, false);
        boolean bl = isNew = this.threads.put(handle.getId(), handle) == null;
        if (isNew) {
            this.expressionManager.threadStarted(handle.getId());
        }
        this.tracer.debug(() -> "Got thread start event for thread '" + handle.getName() + "'@" + handle.getId() + " which is " + (isNew ? "new" : "old"));
        this.runningThreads.add(handle.getId());
        handle.resumeByVmImpl();
        handle.resumeImpl();
        return handle;
    }

    public ThreadHandle[] handleVmStart() {
        assert (this.notificationService.isInNotificationThread());
        for (ThreadReference thread : this.vm.allThreads()) {
            ThreadHandleImpl handle = new ThreadHandleImpl(this, thread, true, null, false, false);
            assert (!this.threads.containsKey(handle.getId()));
            this.threads.put(handle.getId(), handle);
            this.expressionManager.threadStarted(handle.getId());
            this.runningThreads.add(handle.getId());
        }
        if (this.tracer.getTraceLevel().debug()) {
            for (ThreadHandleImpl handle : this.threads.values()) {
                this.tracer.debug(() -> "Got VM start event with thread '" + handle.getName() + "'@" + handle.getId());
            }
        }
        return this.threads.values().toArray(new ThreadHandle[this.threads.size()]);
    }

    public ThreadHandle handleThreadDeathEvent(ThreadDeathEvent event) {
        assert (this.notificationService.isInNotificationThread());
        if (event.request() != this.stopRequest) {
            this.tracer.debug(() -> "Got thread stop event for thread '" + event.thread().name() + "'@" + event.thread().uniqueID() + ", but had the wrong request.");
            return null;
        }
        ThreadHandleImpl handle = new ThreadHandleImpl(this, event.thread(), true, null, false, false);
        boolean wasPresent = this.threads.remove(handle.getId()) != null;
        this.expressionManager.threadStopped(handle.getId());
        this.tracer.debug(() -> "Got thread stop event for thread '" + handle.getName() + "'@" + handle.getId() + " which was " + (wasPresent ? "present" : "not present"));
        this.runningThreads.remove(handle.getId());
        handle.resumeByVmImpl();
        handle.resumeImpl();
        return handle;
    }

    public void handleBreakpoints(List<AbstractBreakpoint> breakpoints, List<ThreadReference> breakpointThreads, Map<ThreadReference, ObjectReference> exceptions, boolean suspendAll) {
        assert (this.notificationService.isInNotificationThread());
        if (suspendAll) {
            for (ThreadHandle thread : this.getAllThreadsInternal()) {
                this.abortStep(thread, "Breakpoint With Suspsend All");
            }
            this.runningThreads.clear();
        } else {
            for (ThreadReference thread : breakpointThreads) {
                ThreadHandle handle = this.threads.get(thread.uniqueID());
                if (handle != null) {
                    this.abortStep(handle, "Breakpoint");
                }
                this.runningThreads.remove(thread.uniqueID());
            }
        }
        this.updateAllThreadsImpl(breakpoints, breakpointThreads, exceptions, -1L);
    }

    public void handleStepEvent(StepEvent event) {
        assert (this.notificationService.isInNotificationThread());
        assert (this.stepRequests.containsKey(event.thread().uniqueID()));
        this.stepRequests.remove(event.thread().uniqueID());
        event.request().disable();
        this.runningThreads.remove(event.thread().uniqueID());
        this.updateAllThreads(event.thread().uniqueID());
    }

    private void updateAllThreads(long stepEndedThread) {
        this.updateAllThreadsImpl(Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), stepEndedThread);
    }

    private void updateAllThreadsImpl(List<AbstractBreakpoint> breakpoints, List<ThreadReference> breakpointThreads, Map<ThreadReference, ObjectReference> exceptions, long stepEndedThread) {
        assert (this.notificationService.isInNotificationThread());
        HashMap<Long, ThreadHandleImpl> oldThreads = new HashMap<Long, ThreadHandleImpl>(this.threads);
        HashMap<Long, ThreadHandleImpl> copy = this.tracer.getTraceLevel().debug() ? new HashMap<Long, ThreadHandleImpl>(this.threads) : null;
        HashSet<Long> oldRunningThreads = new HashSet<Long>(this.runningThreads);
        boolean knownDumped = false;
        this.threads.clear();
        this.runningThreads.clear();
        for (ThreadReference thread : this.vm.allThreads()) {
            ThreadHandleImpl oldHandle = (ThreadHandleImpl)oldThreads.get(thread.uniqueID());
            if (oldHandle == null) {
                if (!this.tracer.getTraceLevel().debug()) continue;
                this.tracer.debug(() -> "Thread '" + thread.name() + "'@" + thread.uniqueID() + " was ignored during update since it was not known already");
                if (knownDumped) continue;
                knownDumped = true;
                this.tracer.debug(() -> "The following " + oldThreads.size() + " threads are already known:");
                for (ThreadHandleImpl thr : oldThreads.values()) {
                    this.tracer.debug(() -> "    Thread '" + thr.getName() + "'@" + thr.getId());
                }
                this.tracer.debug(() -> "The following " + oldThreads.size() + " ids are already known:");
                Iterator<Object> iterator = oldThreads.keySet().iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    this.tracer.debug(() -> "    Id " + id);
                }
                continue;
            }
            boolean stepping = false;
            boolean asRunning = oldRunningThreads.contains(thread.uniqueID());
            if (asRunning && oldHandle.isStepping()) {
                stepping = true;
            }
            ThreadHandleImpl handle = new ThreadHandleImpl(this, thread, asRunning, exceptions.get(thread), stepping, thread.uniqueID() == stepEndedThread);
            if (asRunning) {
                this.runningThreads.add(thread.uniqueID());
            } else if (!handle.isSuspended()) {
                this.runningThreads.add(thread.uniqueID());
            }
            if (handle.isSuspended() && oldHandle.getBreakpointsHit().length > 0 && handle.equalsLocation(oldHandle)) {
                handle.setBreakpointsHit(oldHandle.getBreakpointsHit());
                if (oldHandle.getException() != null && handle.getException() == null) {
                    handle.setException(oldHandle.getException());
                }
            }
            this.threads.put(handle.getId(), handle);
            ArrayList<AbstractBreakpoint> threadBreakpoints = new ArrayList<AbstractBreakpoint>();
            for (int i = 0; i < breakpoints.size(); ++i) {
                if (breakpointThreads.get(i) != thread) continue;
                threadBreakpoints.add(breakpoints.get(i));
            }
            if (threadBreakpoints.isEmpty()) continue;
            handle.setBreakpointsHit(threadBreakpoints.toArray(new Breakpoint[threadBreakpoints.size()]));
        }
        if (this.tracer.getTraceLevel().debug() && copy != null) {
            Iterator<Object> iterator = copy.keySet().iterator();
            while (iterator.hasNext()) {
                long id = (Long)((Object)iterator.next());
                if (this.threads.containsKey(id)) continue;
                this.tracer.debug(() -> "After update the old thread '" + ((ThreadHandle)copy.get(id)).getName() + "'@" + ((ThreadHandle)copy.get(id)).getId() + " was no longer present in the new thread list");
            }
            iterator = this.threads.keySet().iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                if (copy.containsKey(id)) continue;
                this.tracer.debug(() -> "After update the new thread '" + this.threads.get(id).getName() + "'@" + this.threads.get(id).getId() + " was not already present in the old thread list");
            }
        }
    }

    public ThreadHandle[] getAllThreads() {
        final ThreadListSnapshot result = new ThreadListSnapshot();
        FutureTask<ThreadChanges> task = new FutureTask<ThreadChanges>(new Callable<ThreadChanges>(){

            @Override
            public ThreadChanges call() throws Exception {
                ThreadListSnapshot.access$102(result, ThreadManager.this.getAllThreadsInternal());
                return null;
            }
        });
        this.notificationService.add(task);
        while (true) {
            try {
                task.get();
            }
            catch (InterruptedException e) {
                continue;
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            break;
        }
        return result.result;
    }

    public ThreadHandle[] getAllThreadsInternal() {
        assert (this.notificationService.isInNotificationThread());
        ThreadHandle[] result = this.threads.values().toArray(new ThreadHandle[this.threads.size()]);
        this.updateAllThreads(-1L);
        return result;
    }

    public void resumeAll() {
        this.notificationService.add(new Callable<ThreadChanges>(){

            @Override
            public ThreadChanges call() throws Exception {
                ThreadManager.this.runningThreads.clear();
                for (ThreadReference thread : ThreadManager.this.vm.allThreads()) {
                    while (thread.suspendCount() > 1) {
                        thread.resume();
                    }
                    thread.setStackTracker(new StackTracker());
                    ThreadManager.this.runningThreads.add(thread.uniqueID());
                }
                ThreadManager.this.vm.resume();
                ThreadManager.this.updateAllThreads(-1L);
                return ThreadChanges.createForChanged(ThreadManager.this.getAllThreadsInternal());
            }
        });
    }

    public void suspendAll() {
        this.notificationService.add(new Callable<ThreadChanges>(){

            @Override
            public ThreadChanges call() throws Exception {
                for (ThreadHandle thread : ThreadManager.this.getAllThreadsInternal()) {
                    ThreadManager.this.abortStep(thread, "Suspend All");
                }
                ThreadManager.this.runningThreads.clear();
                ThreadManager.this.vm.suspend();
                ThreadManager.this.updateAllThreads(-1L);
                return ThreadChanges.createForChanged(ThreadManager.this.getAllThreadsInternal());
            }
        });
    }

    public void suspendThread(final ThreadHandleImpl thread) {
        this.notificationService.add(new Callable<ThreadChanges>(){

            @Override
            public ThreadChanges call() throws Exception {
                ThreadManager.this.abortStep(thread, "Thread Suspend");
                ThreadManager.this.runningThreads.remove(thread.getId());
                thread.suspendImpl();
                ThreadManager.this.updateAllThreads(-1L);
                return ThreadChanges.createForChanged(ThreadManager.this.getAllThreadsInternal());
            }
        });
    }

    public void resumeThread(final ThreadHandleImpl thread) {
        this.notificationService.add(new Callable<ThreadChanges>(){

            @Override
            public ThreadChanges call() throws Exception {
                ThreadManager.this.runningThreads.add(thread.getId());
                thread.resumeByVmImpl();
                thread.resumeImpl();
                ThreadManager.this.updateAllThreads(-1L);
                return ThreadChanges.createForChanged(ThreadManager.this.getAllThreadsInternal());
            }
        });
    }

    public boolean canStep(ThreadHandle thread) {
        assert (this.notificationService.isInNotificationThread());
        if (!thread.isSuspended()) {
            this.tracer.debug(() -> "Could not step since thread " + thread.getName() + " is not suspended");
            return false;
        }
        if (this.expressionManager.isEvaluatingExpression(thread.getId())) {
            this.tracer.debug(() -> "Could not step since thread " + thread.getName() + " is evaluating an expression");
            return false;
        }
        if (this.stepRequests.containsKey(thread.getId())) {
            this.tracer.debug(() -> "Could not step since thread " + thread.getName() + " is already stepping");
            return false;
        }
        return true;
    }

    public void abortStep(ThreadHandle thread, String reason) {
        assert (this.notificationService.isInNotificationThread());
        if (!this.stepRequests.containsKey(thread.getId())) {
            this.tracer.debug(() -> "Could not abort step for reason '" + reason + "' since thread " + thread.getName() + " is not stepping");
            return;
        }
        this.tracer.debug(() -> "Aborting stepping for reason '" + reason + "' in thread " + thread.getName());
        StepRequest pendingRequest = this.stepRequests.remove(thread.getId());
        pendingRequest.disable();
    }

    public void stepThread(final ThreadHandleImpl thread, final int size, final int depth) {
        this.notificationService.add(new Callable<ThreadChanges>(){

            @Override
            public ThreadChanges call() throws Exception {
                if (!ThreadManager.this.canStep(thread)) {
                    return null;
                }
                ThreadManager.this.tracer.debug(() -> "Beging stepping in " + thread.getName() + " with depth " + depth + " and size " + size);
                StepRequest request = ThreadManager.this.vm.eventRequestManager().createStepRequest(thread.getReference(), size, depth);
                request.addCountFilter(1);
                request.setSuspendPolicy(1);
                assert (!ThreadManager.this.stepRequests.containsKey(thread.getId()));
                ThreadManager.this.stepRequests.put(thread.getId(), request);
                request.enable();
                ThreadManager.this.runningThreads.add(thread.getId());
                ThreadHandleImpl handle = (ThreadHandleImpl)ThreadManager.this.threads.get(thread.getId());
                handle = handle == null ? thread : handle;
                handle.setStepping(true);
                thread.resumeByVmImpl();
                thread.resumeImpl();
                ThreadManager.this.updateAllThreads(-1L);
                return ThreadChanges.createForChanged(ThreadManager.this.getAllThreadsInternal());
            }
        });
    }

    public boolean isDaemonThread(ThreadReference thread) {
        if (!this.daemonFieldInitialized) {
            ReferenceType threadType = thread.referenceType();
            Field field = threadType.fieldByName("daemon");
            if (field == null) {
                field = threadType.fieldByName("isDaemon");
            }
            if (field != null && "Z".equals(field.signature())) {
                this.daemonField = field;
            }
            this.daemonFieldInitialized = true;
        }
        PrimitiveValue value = null;
        if (this.daemonField != null) {
            value = (BooleanValue)thread.getValue(this.daemonField);
        }
        return value == null ? false : value.booleanValue();
    }

    private static class ThreadListSnapshot {
        private ThreadHandle[] result;

        private ThreadListSnapshot() {
        }

        static /* synthetic */ ThreadHandle[] access$102(ThreadListSnapshot x0, ThreadHandle[] x1) {
            x0.result = x1;
            return x1;
        }
    }
}

