/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl;

import com.sap.jvm.debugging.Debugger;
import com.sap.jvm.debugging.ThreadChanges;
import com.sap.jvm.debugging.ThreadStateListener;
import com.sap.jvm.jdi.VMDisconnectedException;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public final class ThreadNotificationService
implements Runnable {
    private static final long POLLING_PERIOD_MS = 500L;
    private final BlockingQueue<FutureTask<ThreadChanges>> queue = new LinkedBlockingQueue<FutureTask<ThreadChanges>>();
    private volatile boolean stopped = false;
    private final ThreadStateListener threadListener;
    private final Debugger debugger;
    private final Thread notificationThread;
    private final Tracer tracer;

    public ThreadNotificationService(ThreadStateListener threadListener, Debugger debugger, Object context, String sessionSuffix) {
        this.threadListener = threadListener;
        this.debugger = debugger;
        this.tracer = Trace.get((String)"com.sap.jvm.debugging.core.thread.notification", (Object)context);
        String sessionName = sessionSuffix == null ? "" : sessionSuffix;
        this.notificationThread = new Thread((Runnable)this, "ThreadNotificationService" + sessionName);
        this.notificationThread.setDaemon(true);
    }

    public synchronized void start(Callable<ThreadChanges> task) {
        ArrayList tasks = new ArrayList();
        this.queue.drainTo(tasks);
        this.queue.add(new FutureTask<ThreadChanges>(task));
        this.queue.addAll(tasks);
        this.notificationThread.start();
    }

    private boolean handleTask() {
        FutureTask<ThreadChanges> task = null;
        try {
            task = this.queue.poll(500L, TimeUnit.MILLISECONDS);
            if (task != null) {
                task.run();
                ThreadChanges changes = task.get();
                if (changes != null) {
                    this.threadListener.threadStateChanged(this.debugger, changes);
                    return true;
                }
            }
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof VMDisconnectedException) {
                this.stopped = true;
            } else {
                this.tracer.warn(t, "Exception while running task: " + task);
            }
        }
        catch (Exception e) {
            if (task == null) {
                this.tracer.warn((Throwable)e, "Exception while waiting for task");
            }
            this.tracer.warn((Throwable)e, "Exception while running task: " + task);
        }
        return false;
    }

    @Override
    public void run() {
        while (!this.stopped) {
            this.handleTask();
        }
        this.threadListener.vmDisconnected();
    }

    public void stop() {
        this.stopped = true;
    }

    public synchronized void add(FutureTask<ThreadChanges> task) {
        boolean success = false;
        while (!success) {
            try {
                this.queue.put(task);
                success = true;
            }
            catch (InterruptedException e) {
                Trace.warn((Throwable)e, (String)"Interrupted during put to queue");
            }
        }
    }

    public synchronized void add(Callable<ThreadChanges> task) {
        boolean success = false;
        while (!success) {
            try {
                this.queue.put(new FutureTask<ThreadChanges>(task));
                success = true;
            }
            catch (InterruptedException e) {
                Trace.warn((Throwable)e, (String)"Interrupted during put to queue");
            }
        }
    }

    public boolean isInNotificationThread() {
        return Thread.currentThread() == this.notificationThread;
    }
}

