/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.breakpoints;

import com.sap.jvm.debugging.breakpoints.Breakpoint;
import com.sap.jvm.debugging.breakpoints.BreakpointLocation;
import com.sap.jvm.debugging.impl.breakpoints.BreakpointManager;
import com.sap.jvm.debugging.impl.types.FrameHandleImpl;
import com.sap.jvm.jdi.BooleanValue;
import com.sap.jvm.jdi.IncompatibleThreadStateException;
import com.sap.jvm.jdi.Location;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.StackFrame;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.jdi.Value;
import com.sap.jvm.jdi.VoidValue;
import com.sap.jvm.jdi.event.LocatableEvent;
import com.sap.jvm.tools.example.debug.expr.ExpressionParser;
import com.sap.jvm.tracing.Trace;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractBreakpoint
implements Breakpoint {
    private boolean enabled;
    protected final BreakpointManager manager;
    private final Set<Long> ignoredThreads = new HashSet<Long>();
    private final Set<BreakpointLocation> ignoredLocations = new HashSet<BreakpointLocation>();
    private final Set<BreakpointLocation> includedLocations = new HashSet<BreakpointLocation>();
    private int hitCount = -1;
    private int specifiedHitCount = -1;
    private boolean booleanCondition = true;
    private String condition = null;
    private boolean lastConditionValueInitial = false;
    private Value lastConditionValue = null;
    private final Set<Breakpoint.ConditionFailureListener> listeners = new HashSet<Breakpoint.ConditionFailureListener>();
    private boolean suspendsThread = true;

    public AbstractBreakpoint(BreakpointManager manager) {
        this.manager = manager;
    }

    public abstract boolean isForClass(ReferenceType var1);

    public abstract void addLocations(ReferenceType var1, List<Location> var2);

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.handleNewEnableState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIgnoredThreads(long[] threadIds) {
        Set<Long> set = this.ignoredThreads;
        synchronized (set) {
            this.ignoredThreads.clear();
            for (long threadId : threadIds) {
                this.ignoredThreads.add(threadId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getIgnoredThreads() {
        Set<Long> set = this.ignoredThreads;
        synchronized (set) {
            long[] result = new long[this.ignoredThreads.size()];
            int i = 0;
            for (long threadId : this.ignoredThreads) {
                result[i++] = threadId;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIgnoredLocations(BreakpointLocation[] locations) {
        Set<BreakpointLocation> set = this.ignoredLocations;
        synchronized (set) {
            this.ignoredLocations.clear();
            this.ignoredLocations.addAll(Arrays.asList(locations));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BreakpointLocation[] getIgnoredLocations() {
        Set<BreakpointLocation> set = this.ignoredLocations;
        synchronized (set) {
            return this.ignoredLocations.toArray(new BreakpointLocation[this.ignoredLocations.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIncludedLocations(BreakpointLocation[] locations) {
        Set<BreakpointLocation> set = this.includedLocations;
        synchronized (set) {
            this.includedLocations.clear();
            this.includedLocations.addAll(Arrays.asList(locations));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BreakpointLocation[] getIncludedLocations() {
        Set<BreakpointLocation> set = this.includedLocations;
        synchronized (set) {
            return this.includedLocations.toArray(new BreakpointLocation[this.includedLocations.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHitCount(int count) {
        AbstractBreakpoint abstractBreakpoint = this;
        synchronized (abstractBreakpoint) {
            this.specifiedHitCount = this.hitCount = count > 1 ? count : -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHitCount() {
        AbstractBreakpoint abstractBreakpoint = this;
        synchronized (abstractBreakpoint) {
            return this.hitCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLastSpecifiedHitCount() {
        AbstractBreakpoint abstractBreakpoint = this;
        synchronized (abstractBreakpoint) {
            return this.specifiedHitCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBooleanCondition(String expression) {
        if (expression != null && expression.trim().length() > 0) {
            AbstractBreakpoint abstractBreakpoint = this;
            synchronized (abstractBreakpoint) {
                this.booleanCondition = true;
                this.condition = expression;
                this.lastConditionValueInitial = true;
                this.lastConditionValue = null;
            }
        } else {
            this.removeCondition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueChangeCondition(String expression) {
        if (expression != null && expression.trim().length() > 0) {
            AbstractBreakpoint abstractBreakpoint = this;
            synchronized (abstractBreakpoint) {
                this.booleanCondition = false;
                this.condition = expression;
                this.lastConditionValueInitial = true;
                this.lastConditionValue = null;
            }
        } else {
            this.removeCondition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBooleanCondition() {
        AbstractBreakpoint abstractBreakpoint = this;
        synchronized (abstractBreakpoint) {
            return this.booleanCondition ? this.condition : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValueChangeCondition() {
        AbstractBreakpoint abstractBreakpoint = this;
        synchronized (abstractBreakpoint) {
            return this.booleanCondition ? null : this.condition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCondition() {
        AbstractBreakpoint abstractBreakpoint = this;
        synchronized (abstractBreakpoint) {
            this.condition = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConditionFailureListener(Breakpoint.ConditionFailureListener l) {
        Set<Breakpoint.ConditionFailureListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConditionFailureListener(Breakpoint.ConditionFailureListener l) {
        Set<Breakpoint.ConditionFailureListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    protected abstract void handleNewEnableState();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isHit(LocatableEvent event) {
        boolean result;
        Object object = this.ignoredThreads;
        synchronized (object) {
            result = !this.ignoredThreads.contains(event.thread().uniqueID());
        }
        if (result) {
            BreakpointLocation l;
            Iterator<BreakpointLocation> iterator;
            BreakpointLocation location = new BreakpointLocation(event.location());
            Set<BreakpointLocation> set = this.ignoredLocations;
            synchronized (set) {
                boolean bl = result = !this.ignoredLocations.contains(location);
                if (result) {
                    iterator = this.ignoredLocations.iterator();
                    while (iterator.hasNext() && (result = !(l = iterator.next()).matches(location))) {
                    }
                }
            }
            if (result) {
                set = this.includedLocations;
                synchronized (set) {
                    if (!this.includedLocations.isEmpty() && !(result = this.includedLocations.contains(location))) {
                        iterator = this.includedLocations.iterator();
                        while (iterator.hasNext() && !(result = (l = iterator.next()).matches(location))) {
                        }
                    }
                }
            }
        }
        if (result) {
            object = this;
            synchronized (object) {
                if (!this.checkCondition(event)) {
                    return false;
                }
                if (this.hitCount != -1) {
                    --this.hitCount;
                    if (this.hitCount > 0) {
                        return false;
                    }
                    this.hitCount = -1;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean checkCondition(LocatableEvent event) {
        if (this.condition != null) {
            final ThreadReference thread = event.thread();
            String errorMessage = null;
            try {
                Value value = this.manager.getExpressionManager().evaluate(this.condition, thread.virtualMachine(), new ExpressionParser.GetFrame(){

                    @Override
                    public StackFrame get() throws IncompatibleThreadStateException {
                        return thread.frame(0);
                    }

                    @Override
                    public Value getVisibleSyntheticVariableByName(StackFrame frame, String name) {
                        return FrameHandleImpl.getVisibleSyntheticVariableByName(frame, name);
                    }
                }, thread.uniqueID());
                if (this.booleanCondition) {
                    if (!(value instanceof BooleanValue)) {
                        errorMessage = "Result of breakpoint conditional expression was not boolean: " + (value == null ? "null" : value.type().name());
                    } else {
                        BooleanValue boolValue = (BooleanValue)value;
                        if (!boolValue.booleanValue()) {
                            return false;
                        }
                    }
                } else if (value instanceof VoidValue) {
                    errorMessage = "Result of breakpoint conditional expression was void";
                } else {
                    if (this.lastConditionValueInitial) {
                        this.lastConditionValueInitial = false;
                    } else {
                        if (value == null && this.lastConditionValue == null) {
                            return false;
                        }
                        if (value != null && value.equals(this.lastConditionValue)) {
                            return false;
                        }
                    }
                    this.lastConditionValue = value;
                }
            }
            catch (Throwable e) {
                Trace.get((String)"com.sap.jvm.debugging.core.breakpoints", (Object)this.manager.getTraceContext()).debug(e, "Error while evaluating conditional breakpoint expression");
                this.lastConditionValueInitial = true;
                this.lastConditionValue = null;
                errorMessage = "Exception during evaluation of breakpoint conditional expression: " + e.getClass().getName() + (e.getMessage() == null ? "" : "\n(" + e.getMessage() + ")");
            }
            if (errorMessage != null) {
                Set<Breakpoint.ConditionFailureListener> set = this.listeners;
                synchronized (set) {
                    for (Breakpoint.ConditionFailureListener l : this.listeners) {
                        l.conditionFailed(this, errorMessage);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean suspendsThread() {
        return this.suspendsThread;
    }

    @Override
    public void setSuspendsThread(boolean suspendsThread) {
        if (suspendsThread != this.suspendsThread) {
            this.suspendsThread = suspendsThread;
            if (this.isEnabled()) {
                this.setEnabled(false);
                this.setEnabled(true);
            }
        }
    }
}

