/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.breakpoints;

import com.sap.jvm.debugging.breakpoints.MethodBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.AbstractBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.BreakpointManager;
import com.sap.jvm.jdi.Method;
import com.sap.jvm.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMethodBreakpoint
extends AbstractBreakpoint
implements MethodBreakpoint {
    private final String methodSpec;

    public AbstractMethodBreakpoint(BreakpointManager manager, String methodSpec) {
        super(manager);
        this.methodSpec = methodSpec;
    }

    @Override
    public String getMethodSpec() {
        return this.methodSpec;
    }

    public String getClassName() {
        String name = this.methodSpec;
        int index = name.indexOf(40);
        if (index >= 0) {
            name = name.substring(0, index);
        }
        index = name.lastIndexOf(46);
        return name.substring(0, index);
    }

    @Override
    public boolean isForClass(ReferenceType type) {
        return this.methodSpec.startsWith(type.name());
    }

    protected List<Method> getMethods(ReferenceType type) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : type.allMethods()) {
            String shortName = method.declaringType().name() + "." + method.name();
            if (this.methodSpec.equals(shortName)) {
                result.add(method);
                continue;
            }
            if (!this.methodSpec.equals(shortName + method.signature())) continue;
            result.add(method);
        }
        return result;
    }

    @Override
    protected void handleNewEnableState() {
        if (this.isEnabled()) {
            this.manager.addMethodBreakpoint(this);
        } else {
            this.manager.removeMethodBreakpoint(this);
        }
    }
}

