/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.breakpoints;

import com.sap.jvm.debugging.impl.ExpressionEvaluationManager;
import com.sap.jvm.debugging.impl.breakpoints.AbstractBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.AbstractMethodBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.ExceptionBreakpointImpl;
import com.sap.jvm.debugging.impl.breakpoints.LineBreakpointImpl;
import com.sap.jvm.debugging.impl.breakpoints.MethodExitBreakpointImpl;
import com.sap.jvm.debugging.impl.breakpoints.TypeLineBreakpointImpl;
import com.sap.jvm.debugging.impl.breakpoints.WatchPointImpl;
import com.sap.jvm.jdi.Field;
import com.sap.jvm.jdi.Location;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.jdi.event.BreakpointEvent;
import com.sap.jvm.jdi.event.ClassPrepareEvent;
import com.sap.jvm.jdi.event.ExceptionEvent;
import com.sap.jvm.jdi.event.LocatableEvent;
import com.sap.jvm.jdi.event.MethodEntryEvent;
import com.sap.jvm.jdi.event.MethodExitEvent;
import com.sap.jvm.jdi.event.WatchpointEvent;
import com.sap.jvm.jdi.request.EventRequest;
import com.sap.jvm.jdi.request.EventRequestManager;
import com.sap.jvm.jdi.request.ExceptionRequest;
import com.sap.jvm.jdi.request.MethodEntryRequest;
import com.sap.jvm.jdi.request.MethodExitRequest;
import com.sap.jvm.jdi.request.WatchpointRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class BreakpointManager {
    private static final AbstractMethodBreakpoint[] EMPTY_METHOD_BREAKPOINTS = new AbstractMethodBreakpoint[0];
    private static final MethodExitBreakpointImpl[] EMPTY_METHOD_EXIT_BREAKPOINTS = new MethodExitBreakpointImpl[0];
    private static final ExceptionBreakpointImpl[] EMPTY_EXCEPTION_BREAKPOINTS = new ExceptionBreakpointImpl[0];
    private static final WatchPointImpl[] EMPTY_WATCH_POINTS = new WatchPointImpl[0];
    private static final LineBreakpointImpl[] EMPTY_LINE_BREAKPOINTS = new LineBreakpointImpl[0];
    private static final TypeLineBreakpointImpl[] EMPTY_TYPE_LINE_BREAKPOINTS = new TypeLineBreakpointImpl[0];
    private final VirtualMachine vm;
    private final ExpressionEvaluationManager expressionManager;
    private final HashSet<AbstractMethodBreakpoint> deferredMethodBreakpoints;
    private final HashSet<MethodExitBreakpointImpl> deferredMethodExitBreakpoints;
    private final HashSet<ExceptionBreakpointImpl> deferredExceptionBreakpoints;
    private final HashSet<WatchPointImpl> deferredWatchPoints;
    private final HashSet<LineBreakpointImpl> deferredLineBreakpoints;
    private final HashSet<TypeLineBreakpointImpl> deferredTypeLineBreakpoints;
    private final HashMap<EventRequest, AbstractBreakpoint> breakpointsForRequest;
    private final HashMap<AbstractBreakpoint, ArrayList<EventRequest>> requestsForBreakpoint;
    private final Object context;
    private boolean skipAllBreakpoints;

    public BreakpointManager(VirtualMachine vm, ExpressionEvaluationManager expressionManager, Object context) {
        this.vm = vm;
        this.expressionManager = expressionManager;
        this.context = context;
        this.deferredMethodBreakpoints = new HashSet();
        this.deferredMethodExitBreakpoints = new HashSet();
        this.deferredExceptionBreakpoints = new HashSet();
        this.deferredWatchPoints = new HashSet();
        this.deferredLineBreakpoints = new HashSet();
        this.deferredTypeLineBreakpoints = new HashSet();
        this.breakpointsForRequest = new HashMap();
        this.requestsForBreakpoint = new HashMap();
    }

    public ExpressionEvaluationManager getExpressionManager() {
        return this.expressionManager;
    }

    public Object getTraceContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMethodBreakpoint(AbstractMethodBreakpoint breakpoint) {
        BreakpointManager breakpointManager = this;
        synchronized (breakpointManager) {
            assert (!this.deferredMethodBreakpoints.contains(breakpoint));
            this.deferredMethodBreakpoints.add(breakpoint);
            this.requestsForBreakpoint.put(breakpoint, new ArrayList());
        }
        this.addForClasses(this.deferredMethodBreakpoints, breakpoint, this.vm.classesByName(breakpoint.getClassName()));
    }

    public void removeMethodBreakpoint(AbstractMethodBreakpoint breakpoint) {
        this.removeRequests(this.deferredMethodBreakpoints, breakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMethodExitBreakpoint(MethodExitBreakpointImpl breakpoint) {
        BreakpointManager breakpointManager = this;
        synchronized (breakpointManager) {
            assert (!this.deferredMethodExitBreakpoints.contains(breakpoint));
            this.deferredMethodExitBreakpoints.add(breakpoint);
            this.requestsForBreakpoint.put(breakpoint, new ArrayList());
        }
        this.addMethodExitForClasses(breakpoint, this.vm.classesByName(breakpoint.getClassName()));
    }

    public void removeMethodExitBreakpoint(MethodExitBreakpointImpl breakpoint) {
        this.removeRequests(this.deferredMethodExitBreakpoints, breakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExceptionBreakpoint(ExceptionBreakpointImpl breakpoint) {
        BreakpointManager breakpointManager = this;
        synchronized (breakpointManager) {
            assert (!this.deferredExceptionBreakpoints.contains(breakpoint));
            this.deferredExceptionBreakpoints.add(breakpoint);
            this.requestsForBreakpoint.put(breakpoint, new ArrayList());
        }
        this.addForExceptions(breakpoint, this.vm.classesByName(breakpoint.getExceptionSpec()));
    }

    public void removeExceptionBreakpoint(ExceptionBreakpointImpl breakpoint) {
        this.removeRequests(this.deferredExceptionBreakpoints, breakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWatchPoint(WatchPointImpl breakpoint) {
        BreakpointManager breakpointManager = this;
        synchronized (breakpointManager) {
            assert (!this.deferredWatchPoints.contains(breakpoint));
            this.deferredWatchPoints.add(breakpoint);
            this.requestsForBreakpoint.put(breakpoint, new ArrayList());
        }
        this.addForWatchPoints(breakpoint, this.vm.classesByName(breakpoint.getClassName()));
    }

    public void removeWatchPoint(WatchPointImpl breakpoint) {
        this.removeRequests(this.deferredWatchPoints, breakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLineBreakpoint(LineBreakpointImpl breakpoint) {
        BreakpointManager breakpointManager = this;
        synchronized (breakpointManager) {
            assert (!this.deferredLineBreakpoints.contains(breakpoint));
            this.deferredLineBreakpoints.add(breakpoint);
            this.requestsForBreakpoint.put(breakpoint, new ArrayList());
        }
        List<ReferenceType> classes = breakpoint.getClassName() != null ? this.vm.classesByName(breakpoint.getClassName()) : this.vm.allClasses();
        this.addForClasses(this.deferredLineBreakpoints, breakpoint, classes);
    }

    public void setSkipAllBreakpoints(boolean skipAllBreakpoints) {
        this.skipAllBreakpoints = skipAllBreakpoints;
    }

    public void removeLineBreakpoint(LineBreakpointImpl breakpoint) {
        this.removeRequests(this.deferredLineBreakpoints, breakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypeLineBreakpoint(TypeLineBreakpointImpl breakpoint) {
        BreakpointManager breakpointManager = this;
        synchronized (breakpointManager) {
            assert (!this.deferredTypeLineBreakpoints.contains(breakpoint));
            this.deferredTypeLineBreakpoints.add(breakpoint);
            this.requestsForBreakpoint.put(breakpoint, new ArrayList());
        }
        ArrayList<ReferenceType> classes = new ArrayList<ReferenceType>();
        for (ReferenceType type : this.vm.classesByName(breakpoint.getClassName())) {
            classes.add(type);
            classes.addAll(type.nestedTypes());
        }
        this.addForClasses(this.deferredTypeLineBreakpoints, breakpoint, classes);
    }

    public void removeTypeLineBreakpoint(TypeLineBreakpointImpl breakpoint) {
        this.removeRequests(this.deferredTypeLineBreakpoints, breakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends AbstractBreakpoint> void removeRequests(HashSet<T> deferredBreakpoints, T breakpoint) {
        ArrayList<EventRequest> requests = null;
        BreakpointManager breakpointManager = this;
        synchronized (breakpointManager) {
            assert (deferredBreakpoints.contains(breakpoint));
            requests = this.requestsForBreakpoint.get(breakpoint);
            this.requestsForBreakpoint.remove(breakpoint);
            deferredBreakpoints.remove(breakpoint);
            for (EventRequest request : requests) {
                this.breakpointsForRequest.remove(request);
            }
        }
        for (EventRequest request : requests) {
            request.disable();
        }
    }

    public void handleClassPrepare(ClassPrepareEvent event) {
        assert (event.referenceType().isPrepared());
        this.handleNewClass(event.referenceType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNewClass(ReferenceType clazz) {
        if (!clazz.isPrepared()) {
            return;
        }
        AbstractMethodBreakpoint[] methodBreakpoints = EMPTY_METHOD_BREAKPOINTS;
        MethodExitBreakpointImpl[] methodExitBreakpoints = EMPTY_METHOD_EXIT_BREAKPOINTS;
        ExceptionBreakpointImpl[] exceptionBreakpoints = EMPTY_EXCEPTION_BREAKPOINTS;
        WatchPointImpl[] watchPoints = EMPTY_WATCH_POINTS;
        LineBreakpointImpl[] lineBreakpoints = EMPTY_LINE_BREAKPOINTS;
        TypeLineBreakpointImpl[] typeLineBreakpoints = EMPTY_TYPE_LINE_BREAKPOINTS;
        AbstractBreakpoint[] abstractBreakpointArray = this;
        synchronized (this) {
            ArrayList<ReferenceType> classes;
            if (this.deferredMethodBreakpoints.size() > 0) {
                methodBreakpoints = this.deferredMethodBreakpoints.toArray(new AbstractMethodBreakpoint[this.deferredMethodBreakpoints.size()]);
            }
            if (this.deferredMethodExitBreakpoints.size() > 0) {
                methodExitBreakpoints = this.deferredMethodExitBreakpoints.toArray(new MethodExitBreakpointImpl[this.deferredMethodExitBreakpoints.size()]);
            }
            if (this.deferredExceptionBreakpoints.size() > 0) {
                exceptionBreakpoints = this.deferredExceptionBreakpoints.toArray(new ExceptionBreakpointImpl[this.deferredExceptionBreakpoints.size()]);
            }
            if (this.deferredWatchPoints.size() > 0) {
                watchPoints = this.deferredWatchPoints.toArray(new WatchPointImpl[this.deferredWatchPoints.size()]);
            }
            if (this.deferredLineBreakpoints.size() > 0) {
                lineBreakpoints = this.deferredLineBreakpoints.toArray(new LineBreakpointImpl[this.deferredLineBreakpoints.size()]);
            }
            if (this.deferredTypeLineBreakpoints.size() > 0) {
                typeLineBreakpoints = this.deferredTypeLineBreakpoints.toArray(new TypeLineBreakpointImpl[this.deferredTypeLineBreakpoints.size()]);
            }
            // ** MonitorExit[abstractBreakpointArray] (shouldn't be in output)
            for (AbstractMethodBreakpoint abstractMethodBreakpoint : methodBreakpoints) {
                if (!abstractMethodBreakpoint.isForClass(clazz)) continue;
                classes = new ArrayList<ReferenceType>();
                classes.add(clazz);
                super.addForClasses(this.deferredMethodBreakpoints, abstractMethodBreakpoint, classes);
            }
            for (AbstractBreakpoint abstractBreakpoint : methodExitBreakpoints) {
                if (!((MethodExitBreakpointImpl)abstractBreakpoint).isForClass(clazz)) continue;
                classes = new ArrayList();
                classes.add(clazz);
                super.addMethodExitForClasses((MethodExitBreakpointImpl)abstractBreakpoint, classes);
            }
            for (AbstractBreakpoint abstractBreakpoint : exceptionBreakpoints) {
                if (!((ExceptionBreakpointImpl)abstractBreakpoint).isForClass(clazz)) continue;
                classes = new ArrayList();
                classes.add(clazz);
                super.addForExceptions((ExceptionBreakpointImpl)abstractBreakpoint, classes);
            }
            for (AbstractBreakpoint abstractBreakpoint : watchPoints) {
                if (!((WatchPointImpl)abstractBreakpoint).isForClass(clazz)) continue;
                classes = new ArrayList();
                classes.add(clazz);
                super.addForWatchPoints((WatchPointImpl)abstractBreakpoint, classes);
            }
            for (AbstractBreakpoint abstractBreakpoint : lineBreakpoints) {
                if (!((LineBreakpointImpl)abstractBreakpoint).isForClass(clazz)) continue;
                classes = new ArrayList();
                classes.add(clazz);
                super.addForClasses(this.deferredLineBreakpoints, abstractBreakpoint, classes);
            }
            for (AbstractBreakpoint abstractBreakpoint : typeLineBreakpoints) {
                if (!((TypeLineBreakpointImpl)abstractBreakpoint).isForClass(clazz)) continue;
                classes = new ArrayList();
                classes.add(clazz);
                super.addForClasses(this.deferredTypeLineBreakpoints, abstractBreakpoint, classes);
            }
            return;
        }
    }

    public AbstractBreakpoint getBreakpointFor(BreakpointEvent event) {
        return this.getBreakpointForInternal(event);
    }

    public AbstractBreakpoint getBreakpointFor(MethodEntryEvent event) {
        return this.getBreakpointForInternal(event);
    }

    public AbstractBreakpoint getBreakpointFor(MethodExitEvent event) {
        return this.getBreakpointForInternal(event);
    }

    public AbstractBreakpoint getBreakpointFor(ExceptionEvent event) {
        return this.getBreakpointForInternal(event);
    }

    public AbstractBreakpoint getBreakpointFor(WatchpointEvent event) {
        return this.getBreakpointForInternal(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractBreakpoint getBreakpointForInternal(LocatableEvent event) {
        if (this.skipAllBreakpoints) {
            return null;
        }
        if (this.expressionManager.isEvaluatingExpression(event.thread().uniqueID())) {
            return null;
        }
        AbstractBreakpoint breakpoint = null;
        BreakpointManager breakpointManager = this;
        synchronized (breakpointManager) {
            breakpoint = this.breakpointsForRequest.get(event.request());
        }
        if (breakpoint != null && breakpoint.isHit(event)) {
            return breakpoint;
        }
        return null;
    }

    private <T extends AbstractBreakpoint> void addForClasses(HashSet<T> deferredBreakpoints, T breakpoint, List<ReferenceType> classes) {
        EventRequestManager em = this.vm.eventRequestManager();
        ArrayList<Location> locations = new ArrayList<Location>();
        for (ReferenceType clazz : classes) {
            if (!breakpoint.isForClass(clazz) || !clazz.isPrepared()) continue;
            breakpoint.addLocations(clazz, locations);
        }
        ArrayList<EventRequest> requests = new ArrayList<EventRequest>();
        for (Location location : locations) {
            EventRequest request;
            if (location.codeIndex() < 0L && deferredBreakpoints == this.deferredMethodBreakpoints) {
                MethodEntryRequest entryRequest = em.createMethodEntryRequest();
                entryRequest.addClassFilter(location.declaringType());
                request = entryRequest;
            } else {
                request = em.createBreakpointRequest(location);
            }
            request.setSuspendPolicy(this.getSuspendType(breakpoint));
            request.enable();
            requests.add(request);
        }
        this.setRequests(deferredBreakpoints, breakpoint, requests);
    }

    private void addMethodExitForClasses(MethodExitBreakpointImpl breakpoint, List<ReferenceType> classes) {
        EventRequestManager em = this.vm.eventRequestManager();
        ArrayList<ReferenceType> locations = new ArrayList<ReferenceType>();
        for (ReferenceType clazz : classes) {
            if (!breakpoint.isForClass(clazz) || !clazz.isPrepared()) continue;
            locations.add(clazz);
        }
        ArrayList<EventRequest> requests = new ArrayList<EventRequest>();
        for (ReferenceType type : locations) {
            MethodExitRequest request = em.createMethodExitRequest();
            request.setSuspendPolicy(this.getSuspendType(breakpoint));
            request.addClassFilter(type);
            request.enable();
            requests.add(request);
        }
        this.setRequests(this.deferredMethodExitBreakpoints, breakpoint, requests);
    }

    private void addForExceptions(ExceptionBreakpointImpl breakpoint, List<ReferenceType> classes) {
        ArrayList<EventRequest> requests = new ArrayList<EventRequest>();
        EventRequestManager em = this.vm.eventRequestManager();
        for (ReferenceType clazz : classes) {
            if (!clazz.isPrepared()) continue;
            ExceptionRequest request = em.createExceptionRequest(clazz, breakpoint.isCaught(), breakpoint.isUncaught());
            request.setSuspendPolicy(this.getSuspendType(breakpoint));
            request.enable();
            requests.add(request);
        }
        this.setRequests(this.deferredExceptionBreakpoints, breakpoint, requests);
    }

    private void addForWatchPoints(WatchPointImpl breakpoint, List<ReferenceType> classes) {
        ArrayList<EventRequest> requests = new ArrayList<EventRequest>();
        EventRequestManager em = this.vm.eventRequestManager();
        for (ReferenceType clazz : classes) {
            WatchpointRequest request;
            Field field;
            if (!clazz.isPrepared() || (field = clazz.fieldByName(breakpoint.getFieldName())) == null) continue;
            if (breakpoint.isAccess()) {
                request = em.createAccessWatchpointRequest(field);
                request.setSuspendPolicy(this.getSuspendType(breakpoint));
                request.enable();
                requests.add(request);
            }
            if (!breakpoint.isModification()) continue;
            request = em.createModificationWatchpointRequest(field);
            request.setSuspendPolicy(this.getSuspendType(breakpoint));
            request.enable();
            requests.add(request);
        }
        this.setRequests(this.deferredWatchPoints, breakpoint, requests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized <T extends AbstractBreakpoint> void setRequests(HashSet<T> deferredBreakpoints, T breakpoint, ArrayList<EventRequest> requests) {
        BreakpointManager breakpointManager = this;
        synchronized (breakpointManager) {
            if (deferredBreakpoints.contains(breakpoint)) {
                ArrayList<EventRequest> oldRequests = this.requestsForBreakpoint.get(breakpoint);
                if (oldRequests != null) {
                    oldRequests.addAll(requests);
                } else {
                    this.requestsForBreakpoint.put(breakpoint, requests);
                }
                for (EventRequest request : requests) {
                    this.breakpointsForRequest.put(request, breakpoint);
                }
            } else {
                for (EventRequest request : requests) {
                    request.disable();
                }
            }
        }
    }

    private int getSuspendType(AbstractBreakpoint breakpoint) {
        return breakpoint.suspendsThread() ? 1 : 2;
    }
}

