/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.breakpoints;

import com.sap.jvm.debugging.breakpoints.ExceptionBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.AbstractBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.BreakpointManager;
import com.sap.jvm.jdi.Location;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.event.ExceptionEvent;
import com.sap.jvm.jdi.event.LocatableEvent;
import java.util.List;

public final class ExceptionBreakpointImpl
extends AbstractBreakpoint
implements ExceptionBreakpoint {
    private final String exceptionSpec;
    private final boolean isCaught;
    private final boolean isUncaught;
    private final boolean breakAtSubtypes;

    public ExceptionBreakpointImpl(BreakpointManager manager, String exceptionSpec, boolean isCaught, boolean isUncaught, boolean subtypes) {
        super(manager);
        this.exceptionSpec = exceptionSpec;
        this.isCaught = isCaught;
        this.isUncaught = isUncaught;
        this.breakAtSubtypes = subtypes;
    }

    @Override
    public boolean isForClass(ReferenceType type) {
        return this.exceptionSpec.equals(type.name());
    }

    @Override
    public void addLocations(ReferenceType type, List<Location> locations) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleNewEnableState() {
        if (this.isEnabled()) {
            this.manager.addExceptionBreakpoint(this);
        } else {
            this.manager.removeExceptionBreakpoint(this);
        }
    }

    @Override
    public String getExceptionSpec() {
        return this.exceptionSpec;
    }

    @Override
    public boolean isCaught() {
        return this.isCaught;
    }

    @Override
    public boolean isUncaught() {
        return this.isUncaught;
    }

    @Override
    public boolean breaksAtSubtypes() {
        return this.breakAtSubtypes;
    }

    @Override
    protected boolean isHit(LocatableEvent event) {
        return event instanceof ExceptionEvent && (this.breakAtSubtypes || this.exceptionSpec.equals(((ExceptionEvent)event).exception().type().name())) && super.isHit(event);
    }

    public String toString() {
        return "exception " + this.exceptionSpec;
    }
}

