/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.breakpoints;

import com.sap.jvm.debugging.breakpoints.LineBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.AbstractBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.BreakpointManager;
import com.sap.jvm.jdi.AbsentInformationException;
import com.sap.jvm.jdi.Location;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.event.BreakpointEvent;
import com.sap.jvm.jdi.event.LocatableEvent;
import java.util.List;

public final class LineBreakpointImpl
extends AbstractBreakpoint
implements LineBreakpoint {
    private final String fileSpec;
    private final int lineNr;
    private final String className;

    public LineBreakpointImpl(BreakpointManager manager, String fileSpec, int lineNr, String className) {
        super(manager);
        this.fileSpec = fileSpec.replace('\\', '/');
        this.lineNr = lineNr;
        this.className = className;
    }

    @Override
    public boolean isForClass(ReferenceType type) {
        try {
            for (String path : type.sourcePaths(null)) {
                if (!this.fileSpec.equals(path.replace('\\', '/'))) continue;
                return true;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void addLocations(ReferenceType type, List<Location> locations) {
        assert (this.isForClass(type));
        try {
            locations.addAll(type.locationsOfLine(this.lineNr));
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
    }

    @Override
    protected void handleNewEnableState() {
        if (this.isEnabled()) {
            this.manager.addLineBreakpoint(this);
        } else {
            this.manager.removeLineBreakpoint(this);
        }
    }

    @Override
    public int lineNr() {
        return this.lineNr;
    }

    @Override
    public String getFilename() {
        return this.fileSpec;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    protected boolean isHit(LocatableEvent event) {
        Location location = event.location();
        try {
            return event instanceof BreakpointEvent && location.lineNumber() == this.lineNr && this.fileSpec.equals(location.sourcePath().replace('\\', '/')) && super.isHit(event);
        }
        catch (AbsentInformationException e) {
            return false;
        }
    }

    public String toString() {
        return "breakpoint at line " + this.lineNr + " in " + this.fileSpec;
    }
}

