/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.breakpoints;

import com.sap.jvm.debugging.breakpoints.MethodBciBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.AbstractMethodBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.BreakpointManager;
import com.sap.jvm.jdi.Location;
import com.sap.jvm.jdi.Method;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.event.BreakpointEvent;
import com.sap.jvm.jdi.event.LocatableEvent;
import java.util.List;

public class MethodBciBreakpointImpl
extends AbstractMethodBreakpoint
implements MethodBciBreakpoint {
    private final int bci;

    public MethodBciBreakpointImpl(BreakpointManager manager, String methodSpec, int bci) {
        super(manager, methodSpec);
        this.bci = bci;
    }

    @Override
    public int getByteCodeIndex() {
        return this.bci;
    }

    @Override
    public void addLocations(ReferenceType type, List<Location> locations) {
        assert (this.isForClass(type));
        for (Method method : this.getMethods(type)) {
            Location l = method.locationOfCodeIndex(this.bci);
            if (l == null) continue;
            locations.add(l);
        }
    }

    public String toString() {
        return "breakpoint at byte code index " + this.bci + " in " + this.getMethodSpec();
    }

    @Override
    protected boolean isHit(LocatableEvent event) {
        return event instanceof BreakpointEvent && super.isHit(event);
    }
}

