/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.breakpoints;

import com.sap.jvm.debugging.breakpoints.MethodEntryBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.AbstractMethodBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.BreakpointManager;
import com.sap.jvm.jdi.Location;
import com.sap.jvm.jdi.Method;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.event.BreakpointEvent;
import com.sap.jvm.jdi.event.LocatableEvent;
import com.sap.jvm.jdi.event.MethodEntryEvent;
import java.util.List;

public class MethodEntryBreakpointImpl
extends AbstractMethodBreakpoint
implements MethodEntryBreakpoint {
    public MethodEntryBreakpointImpl(BreakpointManager manager, String methodSpec) {
        super(manager, methodSpec);
    }

    @Override
    public void addLocations(ReferenceType type, List<Location> locations) {
        assert (this.isForClass(type));
        for (Method method : this.getMethods(type)) {
            Location location = method.location();
            if (location == null) continue;
            locations.add(location);
        }
    }

    public String toString() {
        return "breakpoint at method entry of " + this.getMethodSpec();
    }

    @Override
    protected boolean isHit(LocatableEvent event) {
        if (event instanceof BreakpointEvent) {
            return super.isHit(event);
        }
        Method method = event.location().method();
        String shortName = method.declaringType().name() + "." + method.name();
        boolean isHit = false;
        if (this.getMethodSpec().equals(shortName)) {
            isHit = true;
        } else if (this.getMethodSpec().equals(shortName + method.signature())) {
            isHit = true;
        }
        return isHit && event instanceof MethodEntryEvent && super.isHit(event);
    }
}

