/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.breakpoints;

import com.sap.jvm.debugging.breakpoints.MethodExitBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.AbstractBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.BreakpointManager;
import com.sap.jvm.jdi.Location;
import com.sap.jvm.jdi.Method;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.event.LocatableEvent;
import com.sap.jvm.jdi.event.MethodExitEvent;
import java.util.List;

public class MethodExitBreakpointImpl
extends AbstractBreakpoint
implements MethodExitBreakpoint {
    private final String methodSpec;

    public MethodExitBreakpointImpl(BreakpointManager manager, String methodSpec) {
        super(manager);
        this.methodSpec = methodSpec;
    }

    @Override
    public String getMethodSpec() {
        return this.methodSpec;
    }

    public String getClassName() {
        String name = this.methodSpec;
        int index = name.indexOf(40);
        if (index >= 0) {
            name = name.substring(0, index);
        }
        index = name.lastIndexOf(46);
        return name.substring(0, index);
    }

    @Override
    public boolean isForClass(ReferenceType type) {
        return this.methodSpec.startsWith(type.name());
    }

    @Override
    public void addLocations(ReferenceType type, List<Location> locations) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleNewEnableState() {
        if (this.isEnabled()) {
            this.manager.addMethodExitBreakpoint(this);
        } else {
            this.manager.removeMethodExitBreakpoint(this);
        }
    }

    @Override
    protected boolean isHit(LocatableEvent event) {
        Method method = event.location().method();
        String shortName = method.declaringType().name() + "." + method.name();
        boolean isHit = false;
        if (this.getMethodSpec().equals(shortName)) {
            isHit = true;
        } else if (this.getMethodSpec().equals(shortName + method.signature())) {
            isHit = true;
        }
        return isHit && event instanceof MethodExitEvent && super.isHit(event);
    }

    public String toString() {
        return "breakpoint at method exit of " + this.getMethodSpec();
    }
}

