/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.breakpoints;

import com.sap.jvm.debugging.breakpoints.MethodLineBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.AbstractMethodBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.BreakpointManager;
import com.sap.jvm.jdi.AbsentInformationException;
import com.sap.jvm.jdi.Location;
import com.sap.jvm.jdi.Method;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.event.BreakpointEvent;
import com.sap.jvm.jdi.event.LocatableEvent;
import java.util.List;

public class MethodLineBreakpointImpl
extends AbstractMethodBreakpoint
implements MethodLineBreakpoint {
    private final int lineNr;
    private final boolean isRelative;

    public MethodLineBreakpointImpl(BreakpointManager manager, String methodSpec, int lineNr, boolean isRelative) {
        super(manager, methodSpec);
        this.lineNr = lineNr;
        this.isRelative = isRelative;
    }

    @Override
    public int lineNr() {
        return this.lineNr;
    }

    @Override
    public boolean isRelative() {
        return this.isRelative;
    }

    @Override
    public void addLocations(ReferenceType type, List<Location> locations) {
        assert (this.isForClass(type));
        for (Method method : this.getMethods(type)) {
            try {
                if (this.isRelative) {
                    List<Location> allLines = method.allLineLocations();
                    int minLineNr = Integer.MAX_VALUE;
                    for (Location location : allLines) {
                        minLineNr = Math.min(minLineNr, location.lineNumber());
                    }
                    if (this.lineNr <= 0) continue;
                    int bestLineNr = minLineNr;
                    for (Location location : allLines) {
                        int relLineNr = location.lineNumber() - minLineNr;
                        if (relLineNr > this.lineNr || location.lineNumber() <= bestLineNr) continue;
                        bestLineNr = location.lineNumber();
                    }
                    for (Location location : allLines) {
                        if (location.lineNumber() != bestLineNr) continue;
                        locations.add(location);
                    }
                    continue;
                }
                locations.addAll(method.locationsOfLine(this.lineNr));
            }
            catch (AbsentInformationException absentInformationException) {}
        }
    }

    public String toString() {
        return "breakpoint at line " + this.lineNr + (this.isRelative ? " (relative)" : "") + " in " + this.getMethodSpec();
    }

    @Override
    protected boolean isHit(LocatableEvent event) {
        return event instanceof BreakpointEvent && super.isHit(event);
    }
}

