/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.breakpoints;

import com.sap.jvm.debugging.breakpoints.TypeLineBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.AbstractBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.BreakpointManager;
import com.sap.jvm.jdi.AbsentInformationException;
import com.sap.jvm.jdi.Location;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.event.BreakpointEvent;
import com.sap.jvm.jdi.event.LocatableEvent;
import java.util.List;

public final class TypeLineBreakpointImpl
extends AbstractBreakpoint
implements TypeLineBreakpoint {
    private final int lineNr;
    private final String className;

    public TypeLineBreakpointImpl(BreakpointManager manager, int lineNr, String className) {
        super(manager);
        this.lineNr = lineNr;
        this.className = className;
    }

    @Override
    public boolean isForClass(ReferenceType type) {
        String name = type.name();
        if (!name.startsWith(this.className)) {
            return false;
        }
        if (name.length() == this.className.length()) {
            return true;
        }
        if (name.length() < this.className.length() + 2) {
            return false;
        }
        return name.charAt(this.className.length()) == '$' && Character.isDigit(name.charAt(this.className.length() + 1));
    }

    @Override
    public void addLocations(ReferenceType type, List<Location> locations) {
        assert (this.isForClass(type));
        try {
            locations.addAll(type.locationsOfLine(this.lineNr));
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
    }

    @Override
    protected void handleNewEnableState() {
        if (this.isEnabled()) {
            this.manager.addTypeLineBreakpoint(this);
        } else {
            this.manager.removeTypeLineBreakpoint(this);
        }
    }

    @Override
    public int lineNr() {
        return this.lineNr;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    protected boolean isHit(LocatableEvent event) {
        Location location = event.location();
        return event instanceof BreakpointEvent && location.lineNumber() == this.lineNr && this.isForClass(location.declaringType()) && super.isHit(event);
    }

    public String toString() {
        return "breakpoint at line " + this.lineNr + " in " + this.className;
    }
}

