/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.breakpoints;

import com.sap.jvm.debugging.breakpoints.WatchPoint;
import com.sap.jvm.debugging.impl.breakpoints.AbstractBreakpoint;
import com.sap.jvm.debugging.impl.breakpoints.BreakpointManager;
import com.sap.jvm.jdi.Location;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.event.LocatableEvent;
import com.sap.jvm.jdi.event.WatchpointEvent;
import java.util.List;

public final class WatchPointImpl
extends AbstractBreakpoint
implements WatchPoint {
    private final String className;
    private final String fieldName;
    private final boolean isAccess;
    private final boolean isModification;

    public WatchPointImpl(BreakpointManager manager, String className, String fieldName, boolean isAccess, boolean isModification) {
        super(manager);
        this.className = className;
        this.fieldName = fieldName;
        this.isAccess = isAccess;
        this.isModification = isModification;
    }

    @Override
    public boolean isForClass(ReferenceType type) {
        return this.className.equals(type.name());
    }

    @Override
    public void addLocations(ReferenceType type, List<Location> locations) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleNewEnableState() {
        if (this.isEnabled()) {
            this.manager.addWatchPoint(this);
        } else {
            this.manager.removeWatchPoint(this);
        }
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public boolean isAccess() {
        return this.isAccess;
    }

    @Override
    public boolean isModification() {
        return this.isModification;
    }

    @Override
    protected boolean isHit(LocatableEvent event) {
        return event instanceof WatchpointEvent && super.isHit(event);
    }

    public String toString() {
        return "access/modification of field " + this.fieldName + " in " + this.className;
    }
}

