/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler;

import com.sap.jvm.debugging.decompiler.AnnotatedPrintStream;
import com.sap.jvm.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnnotatedPrintStreamImpl
implements AnnotatedPrintStream {
    private final List<String> lines = new ArrayList<String>();
    private final Map<String, Integer> annotations = new HashMap<String, Integer>();
    private String context = null;
    private String alternativeContext = null;
    private final String className;
    private final long classObjectId;

    public AnnotatedPrintStreamImpl() {
        this.lines.add("");
        this.className = null;
        this.classObjectId = 0L;
    }

    public AnnotatedPrintStreamImpl(String className, long classObjectId) {
        this.lines.add("");
        this.className = className;
        this.classObjectId = classObjectId;
    }

    public AnnotatedPrintStreamImpl(ReferenceType clazz) {
        this.lines.add("");
        this.className = clazz.name();
        this.classObjectId = clazz.classObject().uniqueID();
    }

    @Override
    public void format(String format, Object ... parameters) {
        this.print(String.format(format, parameters));
    }

    @Override
    public void print(boolean b) {
        this.print(String.valueOf(b));
    }

    @Override
    public void print(char c) {
        this.print(String.valueOf(c));
    }

    @Override
    public void print(int i) {
        this.print(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.print(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.print(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.print(String.valueOf(d));
    }

    @Override
    public void print(CharSequence csq) {
        int index = this.lines.size() - 1;
        this.lines.set(index, this.lines.get(index) + csq);
    }

    @Override
    public void print(Object obj) {
        this.print(String.valueOf(obj));
    }

    @Override
    public void println(boolean b) {
        this.println(String.valueOf(b));
    }

    @Override
    public void println(char c) {
        this.println(String.valueOf(c));
    }

    @Override
    public void println(int i) {
        this.println(String.valueOf(i));
    }

    @Override
    public void println(long l) {
        this.println(String.valueOf(l));
    }

    @Override
    public void println(float f) {
        this.println(String.valueOf(f));
    }

    @Override
    public void println(double d) {
        this.println(String.valueOf(d));
    }

    @Override
    public void println(CharSequence csq) {
        int index = this.lines.size() - 1;
        this.lines.set(index, this.lines.get(index) + csq);
        this.println();
    }

    @Override
    public void println(Object obj) {
        this.println(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.lines.add("");
    }

    @Override
    public void printStackTrace(Throwable t) {
        Throwable current = t;
        boolean cause = false;
        do {
            if (cause) {
                this.print("Caused by: ");
            }
            this.println(t);
            StackTraceElement[] stack = t.getStackTrace();
            for (int i = 0; i < stack.length; ++i) {
                this.println("\tat " + stack[i]);
            }
            cause = true;
        } while ((current = current.getCause()) != null);
    }

    @Override
    public void setContext(String context, String alternativeContext) {
        this.context = context;
        this.alternativeContext = alternativeContext;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public String getAlternativeContext() {
        return this.alternativeContext;
    }

    @Override
    public void setAnnotation(int annotation) {
        this.setAnnotation(annotation, this.lines.size());
    }

    @Override
    public void duplicateAnnotation(int originalAnnotation, int duplicateAnnotation) {
        String key = this.context + ":" + originalAnnotation;
        Integer value = this.annotations.get(key);
        if (value == null) {
            return;
        }
        this.setAnnotation(duplicateAnnotation, value);
    }

    private void setAnnotation(int annotation, int value) {
        String key = this.context + ":" + annotation;
        if (!this.annotations.containsKey(key)) {
            this.annotations.put(key, value);
        }
        if (this.alternativeContext != null && !this.annotations.containsKey(key = this.alternativeContext + ":" + annotation)) {
            this.annotations.put(key, value);
        }
    }

    @Override
    public String[] getResult() {
        return this.lines.toArray(new String[this.lines.size()]);
    }

    @Override
    public Map<String, Integer> getAnnotations() {
        return new HashMap<String, Integer>(this.annotations);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public long getClassObjectId() {
        return this.classObjectId;
    }
}

