/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler;

import com.sap.jvm.debugging.impl.decompiler.ByteCodeReader;
import com.sap.jvm.debugging.impl.decompiler.MethodInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ByteCode {
    public static final int WIDE_OFFSET = 256;
    public static final int nop = 0;
    public static final int aconst_null = 1;
    public static final int iconst_m1 = 2;
    public static final int iconst_0 = 3;
    public static final int iconst_1 = 4;
    public static final int iconst_2 = 5;
    public static final int iconst_3 = 6;
    public static final int iconst_4 = 7;
    public static final int iconst_5 = 8;
    public static final int lconst_0 = 9;
    public static final int lconst_1 = 10;
    public static final int fconst_0 = 11;
    public static final int fconst_1 = 12;
    public static final int fconst_2 = 13;
    public static final int dconst_0 = 14;
    public static final int dconst_1 = 15;
    public static final int bipush = 16;
    public static final int sipush = 17;
    public static final int ldc = 18;
    public static final int ldc_w = 19;
    public static final int ldc2_w = 20;
    public static final int iload = 21;
    public static final int lload = 22;
    public static final int fload = 23;
    public static final int dload = 24;
    public static final int aload = 25;
    public static final int iload_0 = 26;
    public static final int iload_1 = 27;
    public static final int iload_2 = 28;
    public static final int iload_3 = 29;
    public static final int lload_0 = 30;
    public static final int lload_1 = 31;
    public static final int lload_2 = 32;
    public static final int lload_3 = 33;
    public static final int fload_0 = 34;
    public static final int fload_1 = 35;
    public static final int fload_2 = 36;
    public static final int fload_3 = 37;
    public static final int dload_0 = 38;
    public static final int dload_1 = 39;
    public static final int dload_2 = 40;
    public static final int dload_3 = 41;
    public static final int aload_0 = 42;
    public static final int aload_1 = 43;
    public static final int aload_2 = 44;
    public static final int aload_3 = 45;
    public static final int iaload = 46;
    public static final int laload = 47;
    public static final int faload = 48;
    public static final int daload = 49;
    public static final int aaload = 50;
    public static final int baload = 51;
    public static final int caload = 52;
    public static final int saload = 53;
    public static final int istore = 54;
    public static final int lstore = 55;
    public static final int fstore = 56;
    public static final int dstore = 57;
    public static final int astore = 58;
    public static final int istore_0 = 59;
    public static final int istore_1 = 60;
    public static final int istore_2 = 61;
    public static final int istore_3 = 62;
    public static final int lstore_0 = 63;
    public static final int lstore_1 = 64;
    public static final int lstore_2 = 65;
    public static final int lstore_3 = 66;
    public static final int fstore_0 = 67;
    public static final int fstore_1 = 68;
    public static final int fstore_2 = 69;
    public static final int fstore_3 = 70;
    public static final int dstore_0 = 71;
    public static final int dstore_1 = 72;
    public static final int dstore_2 = 73;
    public static final int dstore_3 = 74;
    public static final int astore_0 = 75;
    public static final int astore_1 = 76;
    public static final int astore_2 = 77;
    public static final int astore_3 = 78;
    public static final int iastore = 79;
    public static final int lastore = 80;
    public static final int fastore = 81;
    public static final int dastore = 82;
    public static final int aastore = 83;
    public static final int bastore = 84;
    public static final int castore = 85;
    public static final int sastore = 86;
    public static final int pop = 87;
    public static final int pop2 = 88;
    public static final int dup = 89;
    public static final int dup_x1 = 90;
    public static final int dup_x2 = 91;
    public static final int dup2 = 92;
    public static final int dup2_x1 = 93;
    public static final int dup2_x2 = 94;
    public static final int swap = 95;
    public static final int iadd = 96;
    public static final int ladd = 97;
    public static final int fadd = 98;
    public static final int dadd = 99;
    public static final int isub = 100;
    public static final int lsub = 101;
    public static final int fsub = 102;
    public static final int dsub = 103;
    public static final int imul = 104;
    public static final int lmul = 105;
    public static final int fmul = 106;
    public static final int dmul = 107;
    public static final int idiv = 108;
    public static final int ldiv = 109;
    public static final int fdiv = 110;
    public static final int ddiv = 111;
    public static final int irem = 112;
    public static final int lrem = 113;
    public static final int frem = 114;
    public static final int drem = 115;
    public static final int ineg = 116;
    public static final int lneg = 117;
    public static final int fneg = 118;
    public static final int dneg = 119;
    public static final int ishl = 120;
    public static final int lshl = 121;
    public static final int ishr = 122;
    public static final int lshr = 123;
    public static final int iushr = 124;
    public static final int lushr = 125;
    public static final int iand = 126;
    public static final int land = 127;
    public static final int ior = 128;
    public static final int lor = 129;
    public static final int ixor = 130;
    public static final int lxor = 131;
    public static final int iinc = 132;
    public static final int i2l = 133;
    public static final int i2f = 134;
    public static final int i2d = 135;
    public static final int l2i = 136;
    public static final int l2f = 137;
    public static final int l2d = 138;
    public static final int f2i = 139;
    public static final int f2l = 140;
    public static final int f2d = 141;
    public static final int d2i = 142;
    public static final int d2l = 143;
    public static final int d2f = 144;
    public static final int i2b = 145;
    public static final int i2c = 146;
    public static final int i2s = 147;
    public static final int lcmp = 148;
    public static final int fcmpl = 149;
    public static final int fcmpg = 150;
    public static final int dcmpl = 151;
    public static final int dcmpg = 152;
    public static final int ifeq = 153;
    public static final int ifne = 154;
    public static final int iflt = 155;
    public static final int ifge = 156;
    public static final int ifgt = 157;
    public static final int ifle = 158;
    public static final int if_icmpeq = 159;
    public static final int if_icmpne = 160;
    public static final int if_icmplt = 161;
    public static final int if_icmpge = 162;
    public static final int if_icmpgt = 163;
    public static final int if_icmple = 164;
    public static final int if_acmpeq = 165;
    public static final int if_acmpne = 166;
    public static final int _goto = 167;
    public static final int jsr = 168;
    public static final int ret = 169;
    public static final int tableswitch = 170;
    public static final int lookupswitch = 171;
    public static final int ireturn = 172;
    public static final int lreturn = 173;
    public static final int freturn = 174;
    public static final int dreturn = 175;
    public static final int areturn = 176;
    public static final int _return = 177;
    public static final int getstatic = 178;
    public static final int putstatic = 179;
    public static final int getfield = 180;
    public static final int putfield = 181;
    public static final int invokevirtual = 182;
    public static final int invokespecial = 183;
    public static final int invokestatic = 184;
    public static final int invokeinterface = 185;
    public static final int invokedynamic = 186;
    public static final int _new = 187;
    public static final int newarray = 188;
    public static final int anewarray = 189;
    public static final int arraylength = 190;
    public static final int athrow = 191;
    public static final int checkcast = 192;
    public static final int _instanceof = 193;
    public static final int monitorenter = 194;
    public static final int monitorexit = 195;
    public static final int wide = 196;
    public static final int multianewarray = 197;
    public static final int ifnull = 198;
    public static final int ifnonnull = 199;
    public static final int goto_w = 200;
    public static final int jsr_w = 201;
    public static final int iload_w = 277;
    public static final int lload_w = 278;
    public static final int fload_w = 279;
    public static final int dload_w = 280;
    public static final int aload_w = 281;
    public static final int istore_w = 310;
    public static final int lstore_w = 311;
    public static final int fstore_w = 312;
    public static final int dstore_w = 313;
    public static final int astore_w = 314;
    public static final int ret_w = 425;
    public static final int iinc_w = 388;
    private static Map<Integer, Integer> sizeMapping = new HashMap<Integer, Integer>();
    private static List<String> byteCodeNames = new ArrayList<String>();

    public static int getByteCode(int bci, MethodInfo method) {
        byte[] code = method.getCode();
        int byteCode = code[bci] & 0xFF;
        if (byteCode == 196) {
            byteCode = (code[bci + 1] & 0xFF) + 256;
        }
        return byteCode;
    }

    public static int getByteCodeParameterOffset(int byteCode) {
        if (byteCode >= 256) {
            return 2;
        }
        return 1;
    }

    public static boolean isWide(int byteCode) {
        return byteCode >= 256;
    }

    public static boolean isLocalVariableStore(int byteCode) {
        if (byteCode >= 54 && byteCode <= 78) {
            return true;
        }
        if (byteCode >= 256) {
            return ByteCode.isLocalVariableStore(byteCode - 256);
        }
        return false;
    }

    public static int getSize(int bci, MethodInfo method) {
        int len;
        int byteCode = ByteCode.getByteCode(bci, method);
        if (byteCode == 170) {
            byte[] code = method.getCode();
            int pos = bci + 4 & 0xFFFFFFFC;
            ByteCodeReader reader = new ByteCodeReader(code, pos);
            reader.skip(4);
            int low = reader.readInt32();
            int high = reader.readInt32();
            len = 12 + (high - low + 1) * 4 + pos - bci;
        } else if (byteCode == 171) {
            byte[] code = method.getCode();
            int pos = bci + 4 & 0xFFFFFFFC;
            ByteCodeReader reader = new ByteCodeReader(code, pos);
            reader.skip(4);
            int nr = reader.readInt32();
            len = pos + nr * 8 + 8 - bci;
        } else {
            len = sizeMapping.get(byteCode);
        }
        assert (len > 0);
        return len;
    }

    public static int[] getMatchingByteCodes(String pattern) {
        Pattern regexp = Pattern.compile(pattern);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < byteCodeNames.size(); ++i) {
            String name = byteCodeNames.get(i);
            if (name == null || !regexp.matcher(name).find()) continue;
            result.add(i);
        }
        int[] realResult = new int[result.size()];
        for (int i = 0; i < realResult.length; ++i) {
            realResult[i] = (Integer)result.get(i);
        }
        return realResult;
    }

    public static String getName(int byteCode) {
        return byteCodeNames.get(byteCode);
    }

    private static void addCode(int byteCode, String memonic, String args) {
        int size = 1;
        if (byteCode >= 256) {
            ++size;
        }
        String sizeArgs = args.replaceAll("u8", "-");
        sizeArgs = sizeArgs.replaceAll("u16", "--");
        sizeArgs = sizeArgs.replaceAll("s8", "-");
        sizeArgs = sizeArgs.replaceAll("s16", "--");
        sizeArgs = sizeArgs.replaceAll("s32", "----");
        sizeMapping.put(byteCode, size += sizeArgs.length());
        while (byteCodeNames.size() <= byteCode) {
            byteCodeNames.add(null);
        }
        byteCodeNames.set(byteCode, memonic);
    }

    private static void initializeProperties() {
        ByteCode.addCode(0, "nop", "");
        ByteCode.addCode(1, "aconst_null", "");
        ByteCode.addCode(2, "iconst_m1", "");
        ByteCode.addCode(3, "iconst_0", "");
        ByteCode.addCode(4, "iconst_1", "");
        ByteCode.addCode(5, "iconst_2", "");
        ByteCode.addCode(6, "iconst_3", "");
        ByteCode.addCode(7, "iconst_4", "");
        ByteCode.addCode(8, "iconst_5", "");
        ByteCode.addCode(9, "lconst_0", "");
        ByteCode.addCode(10, "lconst_1", "");
        ByteCode.addCode(11, "fconst_0", "");
        ByteCode.addCode(12, "fconst_1", "");
        ByteCode.addCode(13, "fconst_2", "");
        ByteCode.addCode(14, "dconst_0", "");
        ByteCode.addCode(15, "dconst_1", "");
        ByteCode.addCode(16, "bipush", "s8");
        ByteCode.addCode(17, "sipush", "s16");
        ByteCode.addCode(18, "ldc", "u8");
        ByteCode.addCode(19, "ldc_w", "u16");
        ByteCode.addCode(20, "ldc2_w", "u16");
        ByteCode.addCode(21, "iload", "u8");
        ByteCode.addCode(22, "lload", "u8");
        ByteCode.addCode(23, "fload", "u8");
        ByteCode.addCode(24, "dload", "u8");
        ByteCode.addCode(25, "aload", "u8");
        ByteCode.addCode(26, "iload_0", "");
        ByteCode.addCode(27, "iload_1", "");
        ByteCode.addCode(28, "iload_2", "");
        ByteCode.addCode(29, "iload_3", "");
        ByteCode.addCode(30, "lload_0", "");
        ByteCode.addCode(31, "lload_1", "");
        ByteCode.addCode(32, "lload_2", "");
        ByteCode.addCode(33, "lload_3", "");
        ByteCode.addCode(34, "fload_0", "");
        ByteCode.addCode(35, "fload_1", "");
        ByteCode.addCode(36, "fload_2", "");
        ByteCode.addCode(37, "fload_3", "");
        ByteCode.addCode(38, "dload_0", "");
        ByteCode.addCode(39, "dload_1", "");
        ByteCode.addCode(40, "dload_2", "");
        ByteCode.addCode(41, "dload_3", "");
        ByteCode.addCode(42, "aload_0", "");
        ByteCode.addCode(43, "aload_1", "");
        ByteCode.addCode(44, "aload_2", "");
        ByteCode.addCode(45, "aload_3", "");
        ByteCode.addCode(46, "iaload", "");
        ByteCode.addCode(47, "laload", "");
        ByteCode.addCode(48, "faload", "");
        ByteCode.addCode(49, "daload", "");
        ByteCode.addCode(50, "aaload", "");
        ByteCode.addCode(51, "baload", "");
        ByteCode.addCode(52, "caload", "");
        ByteCode.addCode(53, "saload", "");
        ByteCode.addCode(54, "istore", "u8");
        ByteCode.addCode(55, "lstore", "u8");
        ByteCode.addCode(56, "fstore", "u8");
        ByteCode.addCode(57, "dstore", "u8");
        ByteCode.addCode(58, "astore", "u8");
        ByteCode.addCode(59, "istore_0", "");
        ByteCode.addCode(60, "istore_1", "");
        ByteCode.addCode(61, "istore_2", "");
        ByteCode.addCode(62, "istore_3", "");
        ByteCode.addCode(63, "lstore_0", "");
        ByteCode.addCode(64, "lstore_1", "");
        ByteCode.addCode(65, "lstore_2", "");
        ByteCode.addCode(66, "lstore_3", "");
        ByteCode.addCode(67, "fstore_0", "");
        ByteCode.addCode(68, "fstore_1", "");
        ByteCode.addCode(69, "fstore_2", "");
        ByteCode.addCode(70, "fstore_3", "");
        ByteCode.addCode(71, "dstore_0", "");
        ByteCode.addCode(72, "dstore_1", "");
        ByteCode.addCode(73, "dstore_2", "");
        ByteCode.addCode(74, "dstore_3", "");
        ByteCode.addCode(75, "astore_0", "");
        ByteCode.addCode(76, "astore_1", "");
        ByteCode.addCode(77, "astore_2", "");
        ByteCode.addCode(78, "astore_3", "");
        ByteCode.addCode(79, "iastore", "");
        ByteCode.addCode(80, "lastore", "");
        ByteCode.addCode(81, "fastore", "");
        ByteCode.addCode(82, "dastore", "");
        ByteCode.addCode(83, "aastore", "");
        ByteCode.addCode(84, "bastore", "");
        ByteCode.addCode(85, "castore", "");
        ByteCode.addCode(86, "sastore", "");
        ByteCode.addCode(87, "pop", "");
        ByteCode.addCode(88, "pop2", "");
        ByteCode.addCode(89, "dup", "");
        ByteCode.addCode(90, "dup_x1", "");
        ByteCode.addCode(91, "dup_x2", "");
        ByteCode.addCode(92, "dup2", "");
        ByteCode.addCode(93, "dup2_x1", "");
        ByteCode.addCode(94, "dup2_x2", "");
        ByteCode.addCode(95, "swap", "");
        ByteCode.addCode(96, "iadd", "");
        ByteCode.addCode(97, "ladd", "");
        ByteCode.addCode(98, "fadd", "");
        ByteCode.addCode(99, "dadd", "");
        ByteCode.addCode(100, "isub", "");
        ByteCode.addCode(101, "lsub", "");
        ByteCode.addCode(102, "fsub", "");
        ByteCode.addCode(103, "dsub", "");
        ByteCode.addCode(104, "imul", "");
        ByteCode.addCode(105, "lmul", "");
        ByteCode.addCode(106, "fmul", "");
        ByteCode.addCode(107, "dmul", "");
        ByteCode.addCode(108, "idiv", "");
        ByteCode.addCode(109, "ldiv", "");
        ByteCode.addCode(110, "fdiv", "");
        ByteCode.addCode(111, "ddiv", "");
        ByteCode.addCode(112, "irem", "");
        ByteCode.addCode(113, "lrem", "");
        ByteCode.addCode(114, "frem", "");
        ByteCode.addCode(115, "drem", "");
        ByteCode.addCode(116, "ineg", "");
        ByteCode.addCode(117, "lneg", "");
        ByteCode.addCode(118, "fneg", "");
        ByteCode.addCode(119, "dneg", "");
        ByteCode.addCode(120, "ishl", "");
        ByteCode.addCode(121, "lshl", "");
        ByteCode.addCode(122, "ishr", "");
        ByteCode.addCode(123, "lshr", "");
        ByteCode.addCode(124, "iushr", "");
        ByteCode.addCode(125, "lushr", "");
        ByteCode.addCode(126, "iand", "");
        ByteCode.addCode(127, "land", "");
        ByteCode.addCode(128, "ior", "");
        ByteCode.addCode(129, "lor", "");
        ByteCode.addCode(130, "ixor", "");
        ByteCode.addCode(131, "lxor", "");
        ByteCode.addCode(132, "iinc", "u8s8");
        ByteCode.addCode(133, "i2l", "");
        ByteCode.addCode(134, "i2f", "");
        ByteCode.addCode(135, "i2d", "");
        ByteCode.addCode(136, "l2i", "");
        ByteCode.addCode(137, "l2f", "");
        ByteCode.addCode(138, "l2d", "");
        ByteCode.addCode(139, "f2i", "");
        ByteCode.addCode(140, "f2l", "");
        ByteCode.addCode(141, "f2d", "");
        ByteCode.addCode(142, "d2i", "");
        ByteCode.addCode(143, "d2l", "");
        ByteCode.addCode(144, "d2f", "");
        ByteCode.addCode(145, "i2b", "");
        ByteCode.addCode(146, "i2c", "");
        ByteCode.addCode(147, "i2s", "");
        ByteCode.addCode(148, "lcmp", "");
        ByteCode.addCode(149, "fcmpl", "");
        ByteCode.addCode(150, "fcmpg", "");
        ByteCode.addCode(151, "dcmpl", "");
        ByteCode.addCode(152, "dcmpg", "");
        ByteCode.addCode(153, "ifeq", "u16");
        ByteCode.addCode(154, "ifne", "u16");
        ByteCode.addCode(155, "iflt", "u16");
        ByteCode.addCode(156, "ifge", "u16");
        ByteCode.addCode(157, "ifgt", "u16");
        ByteCode.addCode(158, "ifle", "u16");
        ByteCode.addCode(159, "if_icmpeq", "u16");
        ByteCode.addCode(160, "if_icmpne", "u16");
        ByteCode.addCode(161, "if_icmplt", "u16");
        ByteCode.addCode(162, "if_icmpge", "u16");
        ByteCode.addCode(163, "if_icmpgt", "u16");
        ByteCode.addCode(164, "if_icmple", "u16");
        ByteCode.addCode(165, "if_acmpeq", "u16");
        ByteCode.addCode(166, "if_acmpne", "u16");
        ByteCode.addCode(167, "goto", "u16");
        ByteCode.addCode(168, "jsr", "u16");
        ByteCode.addCode(169, "ret", "u8");
        ByteCode.addCode(170, "tableswitch", "x");
        ByteCode.addCode(171, "lookupswitch", "x");
        ByteCode.addCode(172, "ireturn", "");
        ByteCode.addCode(173, "lreturn", "");
        ByteCode.addCode(174, "freturn", "");
        ByteCode.addCode(175, "dreturn", "");
        ByteCode.addCode(176, "areturn", "");
        ByteCode.addCode(177, "return", "");
        ByteCode.addCode(178, "getstatic", "u16");
        ByteCode.addCode(179, "putstatic", "u16");
        ByteCode.addCode(180, "getfield", "u16");
        ByteCode.addCode(181, "putfield", "u16");
        ByteCode.addCode(182, "invokevirtual", "u16");
        ByteCode.addCode(183, "invokespecial", "u16");
        ByteCode.addCode(184, "invokestatic", "u16");
        ByteCode.addCode(185, "invokeinterface", "u16u8u8");
        ByteCode.addCode(186, "invokedynamic", "u16u8u8");
        ByteCode.addCode(187, "new", "u16");
        ByteCode.addCode(188, "newarray", "u8");
        ByteCode.addCode(189, "anewarray", "u16");
        ByteCode.addCode(190, "arraylength", "");
        ByteCode.addCode(191, "athrow", "");
        ByteCode.addCode(192, "checkcast", "u16");
        ByteCode.addCode(193, "instanceof", "u16");
        ByteCode.addCode(194, "monitorenter", "");
        ByteCode.addCode(195, "monitorexit", "");
        ByteCode.addCode(196, "wide", "x");
        ByteCode.addCode(197, "multianewarray", "u16u8");
        ByteCode.addCode(198, "ifnull", "s16");
        ByteCode.addCode(199, "ifnonnull", "s16");
        ByteCode.addCode(200, "goto_w", "s32");
        ByteCode.addCode(201, "jsr_w", "s32");
        ByteCode.addCode(277, "iload_w", "u16");
        ByteCode.addCode(278, "lload_w", "u16");
        ByteCode.addCode(279, "fload_w", "u16");
        ByteCode.addCode(280, "dload_w", "u16");
        ByteCode.addCode(281, "aload_w", "u16");
        ByteCode.addCode(310, "istore_w", "u16");
        ByteCode.addCode(311, "lstore_w", "u16");
        ByteCode.addCode(312, "fstore_w", "u16");
        ByteCode.addCode(313, "dstore_w", "u16");
        ByteCode.addCode(314, "astore_w", "u16");
        ByteCode.addCode(425, "ret_w", "u16");
        ByteCode.addCode(388, "iinc_w", "u16s16");
    }

    public static boolean hasConstantPoolParameter(int byteCode) {
        switch (byteCode) {
            case 18: 
            case 19: 
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 197: {
                return true;
            }
        }
        return false;
    }

    public static boolean hasOffsetParameter(int byteCode) {
        return ByteCode.isJump(byteCode);
    }

    public static boolean isJump(int byteCode) {
        switch (byteCode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: 
            case 200: 
            case 201: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCall(int byteCode) {
        return byteCode >= 182 && byteCode <= 186;
    }

    public static boolean isNonInvokeDynamikCall(int byteCode) {
        return byteCode >= 182 && byteCode < 186;
    }

    public static int getJumpOffset(int byteCode, ByteCodeReader reader) {
        assert (ByteCode.isJump(byteCode));
        reader.skip(ByteCode.getByteCodeParameterOffset(byteCode));
        switch (byteCode) {
            case 200: 
            case 201: {
                return reader.readInt32();
            }
        }
        return reader.readInt16();
    }

    public static String getTypeForNewArray(int typeCode) {
        switch (typeCode) {
            case 4: {
                return "[Z";
            }
            case 5: {
                return "[C";
            }
            case 6: {
                return "[F";
            }
            case 7: {
                return "[D";
            }
            case 8: {
                return "[B";
            }
            case 9: {
                return "[S";
            }
            case 10: {
                return "[I";
            }
            case 11: {
                return "[J";
            }
        }
        assert (false);
        return null;
    }

    static {
        ByteCode.initializeProperties();
    }
}

