/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler;

public class ByteCodeReader {
    private final byte[] code;
    private int pos;

    public ByteCodeReader(byte[] code, int pos) {
        this.code = code;
        this.pos = pos;
    }

    public boolean isFinished() {
        return this.pos >= this.code.length;
    }

    public void skip(int bytesToSkip) {
        this.pos += bytesToSkip;
    }

    public int readUint8() {
        int result = this.code[this.pos] & 0xFF;
        ++this.pos;
        return result;
    }

    public int readInt8() {
        byte result = this.code[this.pos];
        ++this.pos;
        return result;
    }

    public int readUint16() {
        int result = (this.code[this.pos] & 0xFF) << 8 | this.code[this.pos + 1] & 0xFF;
        this.pos += 2;
        return result;
    }

    public int readInt16() {
        int result = (short)((this.code[this.pos] & 0xFF) << 8) | this.code[this.pos + 1] & 0xFF;
        this.pos += 2;
        return result;
    }

    public int readInt32() {
        int result = (this.code[this.pos] & 0xFF) << 24 | (this.code[this.pos + 1] & 0xFF) << 16 | (this.code[this.pos + 2] & 0xFF) << 8 | this.code[this.pos + 3] & 0xFF;
        this.pos += 4;
        return result;
    }
}

