/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler;

import java.io.DataInput;
import java.io.IOException;

public class ConstantPoolEntry {
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_NameAndType = 12;
    public static final int CONSTANT_MethodHandle = 15;
    public static final int CONSTANT_MethodType = 16;
    public static final int CONSTANT_InvokeDynamic = 18;
    private final int type;
    private final Object unresolvedValue;
    private Object resolvedValue;

    public ConstantPoolEntry(DataInput di) throws IOException {
        this.type = di.readByte();
        switch (this.type) {
            case 1: {
                this.resolvedValue = this.unresolvedValue = di.readUTF();
                break;
            }
            case 3: {
                this.resolvedValue = this.unresolvedValue = Integer.valueOf(di.readInt());
                break;
            }
            case 4: {
                this.resolvedValue = this.unresolvedValue = Float.valueOf(di.readFloat());
                break;
            }
            case 5: {
                this.resolvedValue = this.unresolvedValue = Long.valueOf(di.readLong());
                break;
            }
            case 6: {
                this.resolvedValue = this.unresolvedValue = Double.valueOf(di.readDouble());
                break;
            }
            case 7: 
            case 8: {
                this.unresolvedValue = (int)di.readChar();
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.unresolvedValue = new IndexPair(di.readChar(), di.readChar());
                break;
            }
            case 15: {
                this.unresolvedValue = new IndexPair(di.readByte(), di.readChar());
                break;
            }
            case 16: {
                this.unresolvedValue = Character.valueOf(di.readChar());
                break;
            }
            case 18: {
                this.unresolvedValue = new IndexPair(di.readChar(), di.readChar());
                break;
            }
            default: {
                throw new IOException("Unknown constant pool type " + (this.type & 0xFF));
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public String getString() {
        assert (this.resolvedValue != null);
        return (String)this.resolvedValue;
    }

    public String asFieldDescriptor() {
        if (this.type == 7) {
            return "L" + this.getString() + ";";
        }
        return this.getString();
    }

    public String getExternalClass() {
        return ConstantPoolEntry.getExternalClass(this.getString());
    }

    public static String getExternalClass(String internal) {
        int pos = internal.lastIndexOf(91);
        int dim = 1 + pos;
        String internalType = internal.substring(1 + pos);
        String externalType = null;
        switch (internalType.charAt(0)) {
            case 'Z': {
                externalType = "boolean";
                break;
            }
            case 'B': {
                externalType = "byte";
                break;
            }
            case 'S': {
                externalType = "short";
                break;
            }
            case 'C': {
                externalType = "char";
                break;
            }
            case 'I': {
                externalType = "int";
                break;
            }
            case 'J': {
                externalType = "long";
                break;
            }
            case 'F': {
                externalType = "float";
                break;
            }
            case 'D': {
                externalType = "double";
                break;
            }
            case 'V': {
                externalType = "void";
                break;
            }
            case 'L': {
                externalType = internalType.substring(1, internalType.length() - 1).replace('/', '.');
                break;
            }
            default: {
                if (dim > 0) {
                    internalType = internalType.substring(1, internalType.length() - 1);
                }
                externalType = internalType.replace('/', '.');
            }
        }
        for (int i = 0; i < dim; ++i) {
            externalType = externalType + "[]";
        }
        return externalType;
    }

    public Number getNumericValue() {
        return (Number)this.unresolvedValue;
    }

    public String getReferenceClass() {
        return (String)((ObjectPair)this.resolvedValue).first;
    }

    public String getReferenceName() {
        return (String)((ObjectPair)((ObjectPair)((ObjectPair)this.resolvedValue)).second).first;
    }

    public String getReferenceType() {
        return (String)((ObjectPair)((ObjectPair)this.resolvedValue).second).second;
    }

    public String getNameOfNameAndType() {
        return (String)((ObjectPair)this.resolvedValue).first;
    }

    public String getTypeOfNameAndType() {
        return (String)((ObjectPair)this.resolvedValue).second;
    }

    public String getMethodNameOfInvokeDynamic() {
        return this.getReferenceName();
    }

    public String getMethodSigOfInvokeDynamic() {
        return this.getReferenceType();
    }

    public String getMethodOfInvokeDynamic() {
        return this.getMethodNameOfInvokeDynamic() + this.getMethodSigOfInvokeDynamic();
    }

    public int getBoostrapMethodIndexOfInvokeDynamic() {
        return (Integer)((ObjectPair)this.resolvedValue).first;
    }

    public void resolve(ConstantPoolEntry[] pool) {
        if (this.resolvedValue != null) {
            return;
        }
        switch (this.type) {
            case 7: 
            case 8: {
                this.resolvedValue = pool[(Integer)this.unresolvedValue].getString();
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                IndexPair pair = (IndexPair)this.unresolvedValue;
                pool[pair.first].resolve(pool);
                pool[pair.second].resolve(pool);
                String className = pool[pair.first].getString();
                String nameString = pool[pair.second].getNameOfNameAndType();
                String typeString = pool[pair.second].getTypeOfNameAndType();
                this.resolvedValue = new ObjectPair(className, new ObjectPair(nameString, typeString));
                break;
            }
            case 12: {
                IndexPair pair = (IndexPair)this.unresolvedValue;
                String nameString = pool[pair.first].getString();
                String typeString = pool[pair.second].getString();
                this.resolvedValue = new ObjectPair(nameString, typeString);
                break;
            }
            case 15: {
                String op;
                IndexPair pair = (IndexPair)this.unresolvedValue;
                int kind = pair.first;
                int index = pair.second;
                pool[index].resolve(pool);
                String className = (String)((ObjectPair)pool[index].resolvedValue).first;
                String name = (String)((ObjectPair)((ObjectPair)((ObjectPair)pool[index].resolvedValue)).second).first;
                String typeName = (String)((ObjectPair)((ObjectPair)pool[index].resolvedValue).second).second;
                switch (kind) {
                    case 1: {
                        op = "getfield " + typeName + " " + className + "." + name;
                        break;
                    }
                    case 2: {
                        op = "getstatic" + typeName + " " + className + "." + name;
                        break;
                    }
                    case 3: {
                        op = "putfield" + typeName + " " + className + "." + name;
                        break;
                    }
                    case 4: {
                        op = "putstatic" + typeName + " " + className + "." + name;
                        break;
                    }
                    case 5: {
                        op = "invokevirtual" + typeName + "." + className + name;
                        break;
                    }
                    case 6: {
                        op = "new_invokespecial" + typeName + "." + className + name;
                        break;
                    }
                    case 7: {
                        op = "invokestatic" + typeName + "." + className + name;
                        break;
                    }
                    case 8: {
                        op = "invokespecial" + typeName + "." + className + name;
                        break;
                    }
                    case 9: {
                        op = "invokeinterface" + typeName + "." + className + name;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unresolvable method handle kind " + kind);
                    }
                }
                this.resolvedValue = op;
                break;
            }
            case 16: {
                char index = ((Character)this.unresolvedValue).charValue();
                this.resolvedValue = pool[index].getString();
                break;
            }
            case 18: {
                IndexPair pair = (IndexPair)this.unresolvedValue;
                int bootstrapMethod = pair.first;
                int nameAndType = pair.second;
                pool[nameAndType].resolve(pool);
                this.resolvedValue = new ObjectPair(bootstrapMethod, pool[nameAndType].resolvedValue);
                break;
            }
            default: {
                throw new RuntimeException("Unresolvable constant pool type " + (this.type & 0xFF));
            }
        }
    }

    public boolean isDoubleSlot() {
        return this.type == 6 || this.type == 5;
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "CONSTANT_Utf8: '" + this.resolvedValue + "'";
            }
            case 3: {
                return "CONSTANT_Integer: " + this.resolvedValue;
            }
            case 4: {
                return "CONSTANT_Float: " + this.resolvedValue;
            }
            case 5: {
                return "CONSTANT_Long: " + this.resolvedValue;
            }
            case 6: {
                return "CONSTANT_Double: " + this.resolvedValue;
            }
            case 7: {
                return "CONSTANT_Class: " + this.resolvedValue + " (" + this.unresolvedValue + ")";
            }
            case 8: {
                return "CONSTANT_String: \"" + this.resolvedValue + "\" (" + this.unresolvedValue + ")";
            }
            case 9: {
                return "CONSTANT_Fieldref: " + this.getReferenceClass() + " " + this.getReferenceName() + " " + this.getReferenceType() + " (" + this.unresolvedValue + ")";
            }
            case 10: {
                return "CONSTANT_Methodref: " + this.getReferenceClass() + " " + this.getReferenceName() + " " + this.getReferenceType() + " (" + this.unresolvedValue + ")";
            }
            case 11: {
                return "CONSTANT_InterfaceMethodref: " + this.getReferenceClass() + " " + this.getReferenceName() + " " + this.getReferenceType() + " (" + this.unresolvedValue + ")";
            }
            case 12: {
                return "CONSTANT_NameAndType: " + this.getNameOfNameAndType() + " " + this.getTypeOfNameAndType() + " (" + this.unresolvedValue + ")";
            }
            case 15: {
                return "CONSTANT_MethodHandle: " + this.resolvedValue;
            }
            case 16: {
                return "CONSTANT_MethodType: " + this.resolvedValue;
            }
            case 18: {
                return "CONSTANT_InvokeDynamic: " + this.getMethodOfInvokeDynamic() + " [Boostrap method #" + this.getBoostrapMethodIndexOfInvokeDynamic() + "]";
            }
        }
        return "Unknown type " + this.type;
    }

    private static class ObjectPair {
        public final Object first;
        private final Object second;

        public ObjectPair(Object first, Object second) {
            this.first = first;
            this.second = second;
        }

        public String toString() {
            return "[" + this.first + ", " + this.second + "]";
        }
    }

    private static class IndexPair {
        public final int first;
        private final int second;

        public IndexPair(int first, int second) {
            this.first = first;
            this.second = second;
        }

        public String toString() {
            return "[" + this.first + ", " + this.second + "]";
        }
    }
}

