/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler;

import com.sap.jvm.debugging.impl.decompiler.ConstantPoolEntry;
import com.sap.jvm.debugging.impl.decompiler.Decompiler;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ConstantPoolReferenceDisplay {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("ConstantPoolReferenceDisplay <jar> [<jar> ...]");
            return;
        }
        HashSet<String> references = new HashSet<String>();
        HashSet<String> classes = new HashSet<String>();
        for (String jar : args) {
            ConstantPoolReferenceDisplay.addReferences(references, classes, jar);
        }
        for (String clazz : classes) {
            references.remove(clazz);
        }
        ArrayList<String> result = new ArrayList<String>(references);
        Collections.sort(result, String.CASE_INSENSITIVE_ORDER);
        for (String clazz : result) {
            System.out.println(clazz);
        }
    }

    private static void addReferences(HashSet<String> references, HashSet<String> classes, String jar) throws Exception {
        JarFile file = new JarFile(jar);
        Enumeration<JarEntry> it = file.entries();
        while (it.hasMoreElements()) {
            JarEntry entry = it.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            InputStream is = file.getInputStream(entry);
            BufferedInputStream bis = new BufferedInputStream(is);
            DataInputStream dis = new DataInputStream(bis);
            Decompiler decomp = new Decompiler(dis);
            for (ConstantPoolEntry cpEntry : decomp.getCp()) {
                if (cpEntry == null || cpEntry.getType() != 7) continue;
                references.add(cpEntry.getExternalClass());
            }
            classes.add(decomp.getClassName().replace('/', '.'));
        }
        file.close();
    }
}

