/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler;

import com.sap.jvm.debugging.impl.decompiler.ByteCode;
import com.sap.jvm.debugging.impl.decompiler.ByteCodeReader;
import com.sap.jvm.debugging.impl.decompiler.ExceptionTableEntry;
import com.sap.jvm.debugging.impl.decompiler.MethodInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ControlFlowAnalyzer {
    private static final int[] EMPTY_ARRAY = new int[0];
    private final Map<Integer, List<Integer>> previousBcis = new HashMap<Integer, List<Integer>>();
    private final Map<Integer, List<Integer>> previousExceptionBcis = new HashMap<Integer, List<Integer>>();
    private final Map<Integer, List<Integer>> followingBcis = new HashMap<Integer, List<Integer>>();
    private final Map<Integer, List<Integer>> followingExceptionBcis = new HashMap<Integer, List<Integer>>();

    public ControlFlowAnalyzer(MethodInfo method, boolean debug) {
        HashMap<Integer, List<Integer>> subRoutines2Jsr = new HashMap<Integer, List<Integer>>();
        HashMap<Integer, Integer> ret2Index = new HashMap<Integer, Integer>();
        block16: for (int bci = 0; bci < method.getCode().length; bci += ByteCode.getSize(bci, method)) {
            int byteCode = ByteCode.getByteCode(bci, method);
            switch (byteCode) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    this.addFlow(bci, bci + ByteCode.getSize(bci, method));
                }
                case 167: 
                case 200: {
                    this.addFlow(bci, bci + ByteCode.getJumpOffset(byteCode, new ByteCodeReader(method.getCode(), bci)));
                    continue block16;
                }
                case 168: 
                case 201: {
                    int jsrTarget = bci + ByteCode.getJumpOffset(byteCode, new ByteCodeReader(method.getCode(), bci));
                    this.addFlow(bci, jsrTarget);
                    ControlFlowAnalyzer.addAdjacentInstruction(jsrTarget, subRoutines2Jsr, bci);
                    continue block16;
                }
                case 169: 
                case 425: {
                    ByteCodeReader reader = new ByteCodeReader(method.getCode(), bci);
                    reader.skip(ByteCode.getByteCodeParameterOffset(byteCode));
                    int index = byteCode == 169 ? reader.readUint8() : reader.readUint16();
                    ret2Index.put(bci, index);
                    continue block16;
                }
                case 170: {
                    int pos = bci + 4 & 0xFFFFFFFC;
                    ByteCodeReader reader = new ByteCodeReader(method.getCode(), pos);
                    int defaultOffset = reader.readInt32();
                    this.addFlow(bci, bci + defaultOffset);
                    int low = reader.readInt32();
                    int high = reader.readInt32();
                    for (int i = 0; i < high - low + 1; ++i) {
                        int target = reader.readInt32();
                        if (target == defaultOffset) continue;
                        this.addFlow(bci, bci + target);
                    }
                    continue block16;
                }
                case 171: {
                    int pos = bci + 4 & 0xFFFFFFFC;
                    ByteCodeReader reader = new ByteCodeReader(method.getCode(), pos);
                    int defaultOffset = reader.readInt32();
                    this.addFlow(bci, bci + defaultOffset);
                    int pairs = reader.readInt32();
                    for (int i = 0; i < pairs; ++i) {
                        reader.skip(4);
                        int target = reader.readInt32();
                        if (target == defaultOffset) continue;
                        this.addFlow(bci, bci + target);
                    }
                    continue block16;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    continue block16;
                }
                default: {
                    this.addFlow(bci, bci + ByteCode.getSize(bci, method));
                }
            }
        }
        for (Map.Entry subroutine : subRoutines2Jsr.entrySet()) {
            int returnAddressIndex;
            int storeInstruction = ByteCode.getByteCode((Integer)subroutine.getKey(), method);
            switch (storeInstruction) {
                case 75: {
                    returnAddressIndex = 0;
                    break;
                }
                case 76: {
                    returnAddressIndex = 1;
                    break;
                }
                case 77: {
                    returnAddressIndex = 2;
                    break;
                }
                case 78: {
                    returnAddressIndex = 3;
                    break;
                }
                case 58: 
                case 314: {
                    ByteCodeReader reader = new ByteCodeReader(method.getCode(), (Integer)subroutine.getKey());
                    reader.skip(ByteCode.getByteCodeParameterOffset(storeInstruction));
                    returnAddressIndex = storeInstruction == 58 ? reader.readUint8() : reader.readUint16();
                    break;
                }
                default: {
                    throw new IllegalStateException("Subroutine not storing its return address");
                }
            }
            HashSet<Integer> instructions = new HashSet<Integer>();
            ArrayList<int[]> newInstructions = new ArrayList<int[]>();
            newInstructions.add(new int[]{(Integer)subroutine.getKey()});
            ArrayList tmpInstructions = new ArrayList();
            while (!newInstructions.isEmpty()) {
                tmpInstructions.clear();
                ArrayList<int[]> tmp = newInstructions;
                newInstructions = tmpInstructions;
                tmpInstructions = tmp;
                Iterator iterator = tmpInstructions.iterator();
                while (iterator.hasNext()) {
                    int[] followingInstructions;
                    for (int instr : followingInstructions = (int[])iterator.next()) {
                        if (instructions.contains(instr)) continue;
                        instructions.add(instr);
                        if (ret2Index.containsKey(instr)) {
                            assert (this.getFollowingBcis(instr) == EMPTY_ARRAY);
                            int retIndex = (Integer)ret2Index.get(instr);
                            if (retIndex != returnAddressIndex) {
                                throw new IllegalStateException("Overlapping subroutines");
                            }
                            Iterator iterator2 = ((List)subroutine.getValue()).iterator();
                            while (iterator2.hasNext()) {
                                int jsrSource = (Integer)iterator2.next();
                                this.addFlow(instr, jsrSource + ByteCode.getSize(jsrSource, method));
                            }
                            continue;
                        }
                        newInstructions.add(this.getFollowingBcis(instr));
                    }
                }
            }
        }
        for (ExceptionTableEntry entry : method.getExceptionTable()) {
            for (int bci = entry.getStart(); bci < entry.getEnd(); bci += ByteCode.getSize(bci, method)) {
                this.addExceptionFlow(bci, entry.getTarget());
            }
        }
        if (debug) {
            for (int bci = 0; bci < method.getCode().length; bci += ByteCode.getSize(bci, method)) {
                int[] previousEx = this.getPreviousExceptionBcis(bci);
                int[] followingEx = this.getFollowingExceptionsBcis(bci);
                System.out.println(Arrays.toString(this.getPreviousBcis(bci)) + (previousEx == EMPTY_ARRAY ? "" : " ex" + Arrays.toString(previousEx)) + " -> " + bci + " -> " + Arrays.toString(this.getFollowingBcis(bci)) + (followingEx == EMPTY_ARRAY ? "" : " ex" + Arrays.toString(followingEx)));
            }
        }
    }

    private void addFlow(int bci, int nextBci) {
        ControlFlowAnalyzer.addAdjacentInstruction(bci, this.followingBcis, nextBci);
        ControlFlowAnalyzer.addAdjacentInstruction(nextBci, this.previousBcis, bci);
    }

    private void addExceptionFlow(int bci, int nextBci) {
        ControlFlowAnalyzer.addAdjacentInstruction(bci, this.followingExceptionBcis, nextBci);
        ControlFlowAnalyzer.addAdjacentInstruction(nextBci, this.previousExceptionBcis, bci);
    }

    private static void addAdjacentInstruction(int bci, Map<Integer, List<Integer>> neighbors, int adjacentBci) {
        List<Integer> list = neighbors.get(bci);
        if (list == null) {
            list = new ArrayList<Integer>();
            neighbors.put(bci, list);
        }
        list.add(adjacentBci);
    }

    public int[] getPreviousBcis(int bci) {
        return ControlFlowAnalyzer.getBcis(bci, bci + 1, this.previousBcis);
    }

    public int[] getFollowingBcis(int bci) {
        return ControlFlowAnalyzer.getBcis(bci, bci + 1, this.followingBcis);
    }

    public int[] getPreviousExceptionBcis(int bci) {
        return ControlFlowAnalyzer.getBcis(bci, bci + 1, this.previousExceptionBcis);
    }

    public int[] getFollowingExceptionsBcis(int bci) {
        return ControlFlowAnalyzer.getBcis(bci, bci + 1, this.followingExceptionBcis);
    }

    public int[] getPreviousBcis(int start, int end) {
        return ControlFlowAnalyzer.getBcis(start, end, this.previousBcis);
    }

    public int[] getFollowingBcis(int start, int end) {
        return ControlFlowAnalyzer.getBcis(start, end, this.followingBcis);
    }

    public int[] getPreviousBcis(int[] bcis) {
        return ControlFlowAnalyzer.getBcis(bcis, this.previousBcis);
    }

    public int[] getFollowingBcis(int[] bcis) {
        return ControlFlowAnalyzer.getBcis(bcis, this.followingBcis);
    }

    private static int[] getBcis(int start, int end, Map<Integer, List<Integer>> neighbors) {
        HashSet<Integer> values = new HashSet<Integer>();
        for (int bci = start; bci < end; ++bci) {
            List<Integer> list = neighbors.get(bci);
            if (list == null || list.size() == 0) continue;
            for (Integer v : list) {
                if (v >= start && v < end) continue;
                values.add(v);
            }
        }
        if (values.isEmpty()) {
            return EMPTY_ARRAY;
        }
        int[] result = new int[values.size()];
        int i = 0;
        Iterator<Object> iterator = values.iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            result[i++] = value;
        }
        return result;
    }

    private static int[] getBcis(int[] bcis, Map<Integer, List<Integer>> neighbors) {
        HashSet<Integer> values = new HashSet<Integer>();
        for (int bci : bcis) {
            List<Integer> list = neighbors.get(bci);
            if (list == null || list.size() == 0) continue;
            for (Integer v : list) {
                values.add(v);
            }
        }
        if (values.isEmpty()) {
            return EMPTY_ARRAY;
        }
        int[] result = new int[values.size()];
        int i = 0;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            result[i++] = value;
        }
        return result;
    }
}

