/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler;

import com.sap.jvm.debugging.decompiler.AnnotatedPrintStream;
import com.sap.jvm.debugging.impl.decompiler.AnnotatedPrintStreamImpl;
import com.sap.jvm.debugging.impl.decompiler.ConstantPoolEntry;
import com.sap.jvm.debugging.impl.decompiler.ExceptionTableEntry;
import com.sap.jvm.debugging.impl.decompiler.FieldInfo;
import com.sap.jvm.debugging.impl.decompiler.LocalVariableTableEntry;
import com.sap.jvm.debugging.impl.decompiler.MethodInfo;
import com.sap.jvm.debugging.impl.decompiler.ast.ASTBuilder;
import com.sap.jvm.debugging.impl.decompiler.ast.Node;
import com.sap.jvm.debugging.impl.decompiler.ast.NodePrinter;
import com.sap.jvm.jdi.ClassType;
import com.sap.jvm.jdi.Field;
import com.sap.jvm.jdi.InterfaceType;
import com.sap.jvm.jdi.Method;
import com.sap.jvm.jdi.ReferenceType;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Decompiler {
    private final int minorVersion;
    private final int majorVersion;
    private final ConstantPoolEntry[] cp;
    private final MethodInfo[] methods;
    private final FieldInfo[] fields;
    private final String className;
    private final String superClass;
    private final String[] interfaces;
    private final int accessFlags;
    private static boolean DEBUG = false;
    private static boolean PRINT_ATTRIBUTES = false;

    public static void main(String[] args) throws Exception {
        for (String file : args) {
            if (file.equals("-d")) {
                DEBUG = true;
            }
            if (file.equals("-a")) {
                PRINT_ATTRIBUTES = true;
                continue;
            }
            if (new File(file).exists()) {
                Decompiler.decompileAll(new File(file));
                continue;
            }
            Decompiler.decompileClass(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void decompileAll(File file) throws Exception {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            void var3_6;
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            boolean bl = false;
            while (var3_6 < n) {
                File child = fileArray[var3_6];
                Decompiler.decompileAll(child);
                ++var3_6;
            }
        } else if (file.getName().endsWith(".class")) {
            System.out.println("Decompiling " + file.getAbsolutePath());
            Decompiler.decompileClass(new FileInputStream(file), null);
        } else if (file.getName().endsWith(".zip") || file.getName().endsWith(".jar")) {
            try (ZipFile zip = new ZipFile(file);){
                for (ZipEntry zipEntry : Collections.list(zip.entries())) {
                    if (!zipEntry.getName().endsWith(".class")) continue;
                    System.out.println("Decompiling " + file.getAbsolutePath() + "#" + zipEntry.getName());
                    Decompiler.decompileClass(zip.getInputStream(zipEntry), null);
                }
            }
        }
    }

    public static void decompileClass(InputStream is, String methodFilter) throws Exception {
        try {
            try {
                new Decompiler(new DataInputStream(new BufferedInputStream(is))).print(System.out, methodFilter);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            is.close();
        }
    }

    public static void decompileClass(Class<?> clazz) throws Exception {
        System.out.println("Decompiling " + clazz.getName());
        Decompiler.decompileClass(clazz.getResourceAsStream("/" + clazz.getName().replace(".", "/") + ".class"), null);
    }

    public static void decompileClass(String className) throws Exception {
        System.out.println("Decompiling " + className);
        if (className.contains("#")) {
            String realClassName = className.split("#")[0];
            String methodFilter = className.split("#")[1];
            Decompiler.decompileClass(Decompiler.class.getResourceAsStream("/" + realClassName.replace(".", "/") + ".class"), methodFilter);
        } else {
            Decompiler.decompileClass(Decompiler.class.getResourceAsStream("/" + className.replace(".", "/") + ".class"), null);
        }
    }

    public Decompiler(DataInput di) throws Exception {
        int magicNumber = di.readInt();
        if (magicNumber != -889275714) {
            throw new RuntimeException("Invalid magic number " + magicNumber);
        }
        this.minorVersion = di.readChar();
        this.majorVersion = di.readChar();
        if (DEBUG) {
            System.out.println("Version " + this.majorVersion + "." + this.minorVersion);
        }
        this.cp = Decompiler.readConstantPool(di.readChar(), di);
        if (DEBUG) {
            for (int i = 1; i < this.cp.length; ++i) {
                System.out.println("Entry " + i + " " + this.cp[i]);
            }
        }
        this.accessFlags = di.readChar();
        this.className = this.cp[di.readChar()].getString();
        char superIndex = di.readChar();
        this.superClass = superIndex != '\u0000' ? this.cp[superIndex].getString() : "<no super>";
        int nrOfInterfaces = di.readChar();
        this.interfaces = new String[nrOfInterfaces];
        for (int i = 0; i < nrOfInterfaces; ++i) {
            this.interfaces[i] = this.cp[di.readChar()].getString();
        }
        this.fields = Decompiler.readFields(di, this.cp);
        if (DEBUG) {
            System.out.println(this.className + " > " + this.superClass + " " + nrOfInterfaces + " interfaces " + this.fields.length + " fields ");
        }
        this.methods = Decompiler.readMethods(di, this.cp, this.className);
        if (PRINT_ATTRIBUTES) {
            int attributes = di.readChar();
            for (int i = 0; i < attributes; ++i) {
                char nameIndex = di.readChar();
                int length = di.readInt();
                if ("InnerClasses".equals(this.cp[nameIndex].getString())) {
                    int clazzes = di.readChar();
                    for (int j = 0; j < clazzes; ++j) {
                        char info = di.readChar();
                        char outer = di.readChar();
                        char inner = di.readChar();
                        char flags = di.readChar();
                        System.out.print("Attribute \"" + this.cp[nameIndex] + "\": " + this.cp[info]);
                        if (outer != '\u0000') {
                            System.out.print(" outer=" + this.cp[outer]);
                        }
                        if (inner != '\u0000') {
                            System.out.print(" inner=" + this.cp[inner]);
                        }
                        if ((flags & '\u0001') != 0) {
                            System.out.print(" public");
                        }
                        if ((flags & 2) != 0) {
                            System.out.print(" private");
                        }
                        if ((flags & 4) != 0) {
                            System.out.print(" protected");
                        }
                        if ((flags & 8) != 0) {
                            System.out.print(" static");
                        }
                        if ((flags & 0x10) != 0) {
                            System.out.print(" final");
                        }
                        if ((flags & 0x200) != 0) {
                            System.out.print(" interface");
                        }
                        if ((flags & 0x400) != 0) {
                            System.out.print(" abstract");
                        }
                        if ((flags & 0x1000) != 0) {
                            System.out.print(" synthetic");
                        }
                        if ((flags & 0x2000) != 0) {
                            System.out.print(" annotation");
                        }
                        if ((flags & 0x4000) != 0) {
                            System.out.print(" enum");
                        }
                        System.out.println();
                    }
                    continue;
                }
                if ("SourceFile".equals(this.cp[nameIndex].getString())) {
                    System.out.println("Attribute \"" + this.cp[nameIndex] + "\": " + this.cp[di.readChar()]);
                    continue;
                }
                System.out.println("Attribute \"" + this.cp[nameIndex] + "\": length=" + length);
                di.skipBytes(length);
            }
        }
    }

    public Decompiler(ReferenceType type) {
        this.minorVersion = type.minorVersion();
        this.majorVersion = type.majorVersion();
        if (DEBUG) {
            System.out.println("Version " + this.majorVersion + "." + this.minorVersion);
        }
        try {
            this.cp = Decompiler.readConstantPool(type.constantPoolCount(), new DataInputStream(new ByteArrayInputStream(type.constantPool())));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (DEBUG) {
            for (int i = 1; i < this.cp.length; ++i) {
                System.out.println("Entry " + i + " " + this.cp[i]);
            }
        }
        this.accessFlags = (type.isPublic() ? 1 : 0) | (type.isFinal() ? 16 : 0) | (type instanceof InterfaceType ? 512 : 0) | (type.isAbstract() ? 1024 : 0) | (type instanceof ClassType && ((ClassType)type).isEnum() ? 16384 : 0);
        this.className = type.name().replace('.', '/');
        if (type instanceof ClassType) {
            ClassType clazz = (ClassType)type;
            ClassType superClazz = clazz.superclass();
            this.superClass = superClazz == null ? "<no super>" : superClazz.name().replace('.', '/');
            List<InterfaceType> superInterfaces = clazz.interfaces();
            this.interfaces = new String[superInterfaces.size()];
            for (int i = 0; i < superInterfaces.size(); ++i) {
                this.interfaces[i] = superInterfaces.get(i).name().replace('.', '/');
            }
        } else {
            this.superClass = "java/lang/Object";
            if (type instanceof InterfaceType) {
                InterfaceType clazz = (InterfaceType)type;
                List<InterfaceType> superInterfaces = clazz.superinterfaces();
                this.interfaces = new String[superInterfaces.size()];
                for (int i = 0; i < superInterfaces.size(); ++i) {
                    this.interfaces[i] = superInterfaces.get(i).name().replace('.', '/');
                }
            } else {
                this.interfaces = new String[0];
            }
        }
        List<Field> jdiFields = type.fields();
        this.fields = new FieldInfo[jdiFields.size()];
        for (int i = 0; i < jdiFields.size(); ++i) {
            this.fields[i] = new FieldInfo(jdiFields.get(i));
        }
        if (DEBUG) {
            System.out.println(this.className + " > " + this.superClass + " " + this.interfaces.length + " interfaces " + this.fields.length + " fields ");
        }
        List<Method> jdiMethods = type.methods();
        this.methods = new MethodInfo[jdiMethods.size()];
        for (int i = 0; i < jdiMethods.size(); ++i) {
            this.methods[i] = new MethodInfo(jdiMethods.get(i), this.cp);
        }
    }

    public void print(PrintStream stream, String methodFilter) {
        AnnotatedPrintStreamImpl annotatedStream = new AnnotatedPrintStreamImpl();
        this.print(annotatedStream, methodFilter);
        for (String line : annotatedStream.getResult()) {
            stream.println(line);
        }
    }

    public MethodInfo[] getMethods() {
        return (MethodInfo[])this.methods.clone();
    }

    public FieldInfo[] getFields() {
        return (FieldInfo[])this.fields.clone();
    }

    public ConstantPoolEntry[] getCp() {
        return (ConstantPoolEntry[])this.cp.clone();
    }

    public String getClassName() {
        return this.className;
    }

    public void print(AnnotatedPrintStream stream, String methodFilter) {
        this.printClass(stream);
        if (methodFilter == null) {
            this.printFields(stream);
        }
        for (MethodInfo method : this.methods) {
            if (methodFilter != null && !method.name.contains(methodFilter)) continue;
            NodePrinter printer = new NodePrinter(stream, method);
            printer.println("");
            printer.startBlock();
            if (method.getCode() == null) continue;
            stream.setContext(method.getFullyQualifiedName(), method.getAlternativeFullyQualifiedName());
            if (method.isNative()) {
                stream.setAnnotation(-1);
            }
            printer.println(method);
            if (!method.isAbstract() && !method.isNative()) {
                ASTBuilder builder = new ASTBuilder(method, DEBUG);
                try {
                    Node root = builder.createAST();
                    root.printOn(printer, false);
                }
                catch (StackOverflowError stackOverflowError) {
                    // empty catch block
                }
            }
            printer.finishMethod();
        }
        stream.println('}');
    }

    private void printClass(AnnotatedPrintStream stream) {
        int trailingSlash = this.className.lastIndexOf(47);
        String name = this.className;
        if (trailingSlash > 0) {
            stream.print("package ");
            stream.print(this.className.substring(0, trailingSlash).replace('/', '.'));
            stream.println(';');
            name = this.className.substring(trailingSlash + 1);
        }
        if (this.isPublic()) {
            stream.print("public ");
        }
        if (this.isAbstract() && !this.isInterface() && !this.isAnnotation()) {
            stream.print("abstract ");
        }
        if (this.isFinal()) {
            stream.print("final ");
        }
        if (this.isAnnotation()) {
            stream.print('@');
        }
        if (this.isInterface()) {
            stream.print("interface ");
        } else if (this.isEnum()) {
            stream.print("enum ");
        } else {
            stream.print("class ");
        }
        stream.print(name);
        if (!"<no super>".equals(this.superClass) && !"java/lang/Object".equals(this.superClass)) {
            stream.print(" extends ");
            stream.print(this.superClass.replace('/', '.'));
        }
        if (this.interfaces.length > 0) {
            if (this.isInterface()) {
                stream.print(" extends ");
            } else {
                stream.print(" implements ");
            }
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (i != 0) {
                    stream.print(", ");
                }
                stream.print(this.interfaces[i].replace('/', '.'));
            }
        }
        stream.println();
        stream.println('{');
    }

    private void printFields(AnnotatedPrintStream stream) {
        for (int i = 0; i < this.fields.length; ++i) {
            stream.println();
            stream.print(' ');
            stream.print(' ');
            stream.print(' ');
            stream.print(' ');
            stream.print(this.fields[i]);
            if (!this.fields[i].isEnum()) continue;
            if (i + 1 < this.fields.length && this.fields[i + 1].isEnum()) {
                stream.print(',');
                continue;
            }
            stream.print(';');
        }
    }

    public static ConstantPoolEntry[] readConstantPool(int nrOfEntries, DataInput di) throws IOException {
        int i;
        ConstantPoolEntry[] tmp = new ConstantPoolEntry[nrOfEntries];
        for (i = 1; i < nrOfEntries; ++i) {
            tmp[i] = new ConstantPoolEntry(di);
            if (!tmp[i].isDoubleSlot()) continue;
            ++i;
        }
        for (i = 1; i < nrOfEntries; ++i) {
            if (tmp[i] == null) continue;
            tmp[i].resolve(tmp);
        }
        return tmp;
    }

    public static MethodInfo[] readMethods(DataInput di, ConstantPoolEntry[] cp, String className) throws IOException {
        int nrOfMethods = di.readChar();
        MethodInfo[] tmp = new MethodInfo[nrOfMethods];
        for (int i = 0; i < nrOfMethods; ++i) {
            tmp[i] = Decompiler.readMethodInfo(di, cp, className);
        }
        return tmp;
    }

    public static FieldInfo[] readFields(DataInput di, ConstantPoolEntry[] cp) throws IOException {
        int nrOfFields = di.readChar();
        FieldInfo[] tmp = new FieldInfo[nrOfFields];
        for (int i = 0; i < nrOfFields; ++i) {
            tmp[i] = Decompiler.readFieldInfo(di, cp);
        }
        return tmp;
    }

    private static FieldInfo readFieldInfo(DataInput di, ConstantPoolEntry[] cp) throws IOException {
        int attributes = di.readUnsignedShort();
        String name = cp[di.readChar()].getString();
        String type = cp[di.readChar()].getString();
        int nrOfAttributes = di.readChar();
        for (int i = 0; i < nrOfAttributes; ++i) {
            Decompiler.skipAttribute(di);
        }
        return new FieldInfo(name, type, attributes);
    }

    private static void skipAttribute(DataInput di) throws IOException {
        di.skipBytes(2);
        int len = di.readInt();
        di.skipBytes(len);
    }

    private static MethodInfo readMethodInfo(DataInput di, ConstantPoolEntry[] cp, String className) throws IOException {
        int attributes = di.readUnsignedShort();
        String name = cp[di.readChar()].getString();
        String signature = cp[di.readChar()].getString();
        byte[] code = null;
        ExceptionTableEntry[] exceptions = new ExceptionTableEntry[]{};
        char maxStackSize = '\u0000';
        char maxLocals = '\u0000';
        int nrOfAttributes = di.readChar();
        ArrayList<LocalVariableTableEntry> variables = new ArrayList<LocalVariableTableEntry>();
        String[] thrownExceptions = new String[]{};
        for (int i = 0; i < nrOfAttributes; ++i) {
            String attributeName = cp[di.readChar()].getString();
            int len = di.readInt();
            if ("Code".equals(attributeName)) {
                maxStackSize = di.readChar();
                maxLocals = di.readChar();
                int codeLength = di.readInt();
                code = new byte[codeLength];
                di.readFully(code);
                int nrOfExceptionHandlers = di.readChar();
                exceptions = new ExceptionTableEntry[nrOfExceptionHandlers];
                for (int j = 0; j < nrOfExceptionHandlers; ++j) {
                    char start = di.readChar();
                    char end = di.readChar();
                    char target = di.readChar();
                    char catchType = di.readChar();
                    String type = catchType != '\u0000' ? cp[catchType].getString() : null;
                    exceptions[j] = new ExceptionTableEntry(start, end, target, type);
                }
                int nrOfCodeAttributes = di.readChar();
                boolean hasTypedVariableTable = false;
                for (int j = 0; j < nrOfCodeAttributes; ++j) {
                    String codeAttributeName = cp[di.readChar()].getString();
                    int codeAttributeLength = di.readInt();
                    boolean isVarTable = "LocalVariableTable".equals(codeAttributeName);
                    boolean isTypeVarTable = "LocalVariableTypeTable".equals(codeAttributeName);
                    if (isVarTable || isTypeVarTable) {
                        if (isVarTable && hasTypedVariableTable) {
                            di.skipBytes(codeAttributeLength);
                            continue;
                        }
                        if (isTypeVarTable && !hasTypedVariableTable) {
                            variables.clear();
                            hasTypedVariableTable = true;
                        }
                        int nrOfVariables = di.readChar();
                        for (int k = 0; k < nrOfVariables; ++k) {
                            variables.add(new LocalVariableTableEntry(di.readChar(), di.readChar(), cp[di.readChar()].getString(), cp[di.readChar()].getString(), di.readChar()));
                        }
                        continue;
                    }
                    di.skipBytes(codeAttributeLength);
                }
                continue;
            }
            if ("Exceptions".equals(attributeName)) {
                thrownExceptions = new String[di.readUnsignedShort()];
                for (int j = 0; j < thrownExceptions.length; ++j) {
                    thrownExceptions[j] = cp[di.readChar()].getString();
                }
                continue;
            }
            di.skipBytes(len);
        }
        return new MethodInfo(className, name, signature, attributes, maxStackSize, maxLocals, code, cp, exceptions, variables.toArray(new LocalVariableTableEntry[variables.size()]), thrownExceptions);
    }

    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public boolean isAnnotation() {
        return (this.accessFlags & 0x2000) != 0;
    }

    public boolean isEnum() {
        return (this.accessFlags & 0x4000) != 0;
    }
}

