/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler;

import com.sap.jvm.debugging.decompiler.AnnotatedPrintStream;
import com.sap.jvm.debugging.impl.decompiler.AnnotatedPrintStreamImpl;
import com.sap.jvm.debugging.impl.decompiler.ByteCode;
import com.sap.jvm.debugging.impl.decompiler.ByteCodeReader;
import com.sap.jvm.debugging.impl.decompiler.ConstantPoolEntry;
import com.sap.jvm.debugging.impl.decompiler.Decompiler;
import com.sap.jvm.debugging.impl.decompiler.ExceptionTableEntry;
import com.sap.jvm.debugging.impl.decompiler.FieldInfo;
import com.sap.jvm.debugging.impl.decompiler.MethodInfo;
import com.sap.jvm.jdi.ClassType;
import com.sap.jvm.jdi.Field;
import com.sap.jvm.jdi.InterfaceType;
import com.sap.jvm.jdi.Method;
import com.sap.jvm.jdi.ReferenceType;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class Disassembler {
    public static final String NO_SUPER_CLASS = "<no super>";
    public static final String JAVA_LANG_OBJECT_CLASS = "java/lang/Object";
    private final int minorVersion;
    private final int majorVersion;
    private final ConstantPoolEntry[] cp;
    private final MethodInfo[] methods;
    private final int accessFlags;
    private final String className;
    private final String superClass;
    private final String[] interfaces;
    private final FieldInfo[] fields;
    private static boolean EXTENDED_OUTPUT = false;

    public Disassembler(DataInput di) throws IOException {
        int magicNumber = di.readInt();
        if (magicNumber != -889275714) {
            throw new RuntimeException("Invalid magic number " + magicNumber);
        }
        this.minorVersion = di.readChar();
        this.majorVersion = di.readChar();
        this.cp = Decompiler.readConstantPool(di.readChar(), di);
        this.accessFlags = di.readChar();
        this.className = this.cp[di.readChar()].getString();
        char superIndex = di.readChar();
        this.superClass = superIndex != '\u0000' ? this.cp[superIndex].getString() : NO_SUPER_CLASS;
        int nrOfInterfaces = di.readChar();
        this.interfaces = new String[nrOfInterfaces];
        for (int i = 0; i < nrOfInterfaces; ++i) {
            this.interfaces[i] = this.cp[di.readChar()].getString();
        }
        this.fields = Decompiler.readFields(di, this.cp);
        this.methods = Decompiler.readMethods(di, this.cp, this.className);
    }

    public Disassembler(ReferenceType type) {
        ReferenceType clazz;
        this.minorVersion = type.minorVersion();
        this.majorVersion = type.majorVersion();
        try {
            this.cp = Decompiler.readConstantPool(type.constantPoolCount(), new DataInputStream(new ByteArrayInputStream(type.constantPool())));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.accessFlags = (type.isPublic() ? 1 : 0) | (type.isFinal() ? 16 : 0) | (type instanceof InterfaceType ? 512 : 0) | (type.isAbstract() ? 1024 : 0) | (type instanceof ClassType && ((ClassType)type).isEnum() ? 16384 : 0);
        this.className = type.name();
        if (type instanceof ClassType) {
            clazz = (ClassType)type;
            ClassType superClazz = clazz.superclass();
            this.superClass = superClazz == null ? NO_SUPER_CLASS : superClazz.name().replace('.', '/');
            List<InterfaceType> superInterfaces = clazz.interfaces();
            this.interfaces = new String[superInterfaces.size()];
            for (int i = 0; i < superInterfaces.size(); ++i) {
                this.interfaces[i] = superInterfaces.get(i).name();
            }
        } else {
            this.superClass = JAVA_LANG_OBJECT_CLASS;
            if (type instanceof InterfaceType) {
                clazz = (InterfaceType)type;
                List<InterfaceType> superInterfaces = clazz.superinterfaces();
                this.interfaces = new String[superInterfaces.size()];
                for (int i = 0; i < superInterfaces.size(); ++i) {
                    this.interfaces[i] = superInterfaces.get(i).name();
                }
            } else {
                this.interfaces = new String[0];
            }
        }
        List<Field> jdiFields = type.fields();
        this.fields = new FieldInfo[jdiFields.size()];
        for (int i = 0; i < jdiFields.size(); ++i) {
            this.fields[i] = new FieldInfo(jdiFields.get(i));
        }
        List<Method> jdiMethods = type.methods();
        this.methods = new MethodInfo[jdiMethods.size()];
        for (int i = 0; i < jdiMethods.size(); ++i) {
            this.methods[i] = new MethodInfo(jdiMethods.get(i), this.cp);
        }
    }

    public static void main(String[] args) throws IOException {
        for (String file : args) {
            if (file.equals("-e")) {
                EXTENDED_OUTPUT = true;
                continue;
            }
            if (new File(file).exists()) {
                Disassembler.disassembleAll(new File(file));
                continue;
            }
            Disassembler.disassembleClass(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void disassembleAll(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            void var3_6;
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            boolean bl = false;
            while (var3_6 < n) {
                File child = fileArray[var3_6];
                Disassembler.disassembleAll(child);
                ++var3_6;
            }
        } else if (file.getName().endsWith(".class")) {
            Disassembler.disassembleClass(new FileInputStream(file));
        } else if (file.getName().endsWith(".zip") || file.getName().endsWith(".jar")) {
            try (ZipFile zip = new ZipFile(file);){
                for (ZipEntry zipEntry : Collections.list(zip.entries())) {
                    if (!zipEntry.getName().endsWith(".class")) continue;
                    Disassembler.disassembleClass(zip.getInputStream(zipEntry));
                }
            }
        }
    }

    public static void disassembleClass(String file) throws IOException {
        Disassembler.disassembleClass(Decompiler.class.getResourceAsStream("/" + file.replace(".", "/") + ".class"));
    }

    public static void disassembleClass(InputStream input) throws IOException {
        try {
            new Disassembler(new DataInputStream(new BufferedInputStream(input))).print(System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            input.close();
        }
    }

    public void print(PrintStream stream) {
        AnnotatedPrintStreamImpl annotatedStream = new AnnotatedPrintStreamImpl();
        this.print(annotatedStream);
        for (String line : annotatedStream.getResult()) {
            stream.println(line);
        }
    }

    public void print(AnnotatedPrintStream stream) {
        int i;
        if (this.isPublic()) {
            stream.print("public ");
        }
        if (this.isAbstract() && !this.isInterface() && !this.isAnnotation()) {
            stream.print("abstract ");
        }
        if (this.isFinal()) {
            stream.print("final ");
        }
        if (this.isAnnotation()) {
            stream.print('@');
        }
        if (this.isInterface()) {
            stream.print("interface ");
        } else if (this.isEnum()) {
            stream.print("enum ");
        } else {
            stream.print("class ");
        }
        stream.print(this.className.replace('/', '.'));
        if (!NO_SUPER_CLASS.equals(this.superClass) && !JAVA_LANG_OBJECT_CLASS.equals(this.superClass)) {
            stream.print(" extends ");
            stream.print(this.superClass.replace('/', '.'));
        }
        if (this.interfaces.length > 0) {
            if (this.isInterface()) {
                stream.print(" extends ");
            } else {
                stream.print(" implements ");
            }
            for (i = 0; i < this.interfaces.length; ++i) {
                if (i != 0) {
                    stream.print(", ");
                }
                stream.print(this.interfaces[i].replace('/', '.'));
            }
        }
        if (EXTENDED_OUTPUT) {
            stream.println();
            stream.print("  minor version: ");
            stream.println(this.minorVersion);
            stream.print("  major version: ");
            stream.println(this.majorVersion);
            stream.println("  Constant pool:");
            int longestCpIndexText = Integer.toString(this.cp.length + 1).length();
            String firstFormat = "#%d";
            String secondFormat = "    %" + (longestCpIndexText + 1) + "s = %s";
            for (int i2 = 1; i2 < this.cp.length; ++i2) {
                stream.format(secondFormat, String.format(firstFormat, i2), this.cp[i2]);
                stream.println();
            }
        } else {
            stream.print(' ');
        }
        stream.println('{');
        for (i = 0; i < this.fields.length; ++i) {
            stream.print(' ');
            stream.print(' ');
            stream.print(this.fields[i]);
            if (this.fields[i].isEnum()) {
                if (i + 1 < this.fields.length && this.fields[i + 1].isEnum()) {
                    stream.print(',');
                } else {
                    stream.print(';');
                }
            }
            stream.println();
        }
        if (this.fields.length > 0) {
            stream.println();
        }
        for (i = 0; i < this.methods.length; ++i) {
            MethodInfo method = this.methods[i];
            stream.setContext(method.getFullyQualifiedName(), method.getAlternativeFullyQualifiedName());
            if (method.isNative()) {
                stream.setAnnotation(-1);
            }
            stream.print(' ');
            stream.print(' ');
            stream.print(method.toString());
            stream.print(';');
            stream.println();
            if (!method.isAbstract() && !method.isNative()) {
                stream.println("    Code:");
                for (int bci = 0; bci < method.getCode().length; bci += ByteCode.getSize(bci, method)) {
                    String parameter;
                    stream.setAnnotation(bci);
                    int byteCode = ByteCode.getByteCode(bci, method);
                    int parameterOffset = ByteCode.getByteCodeParameterOffset(byteCode);
                    ByteCodeReader reader = new ByteCodeReader(method.getCode(), bci + parameterOffset);
                    block0 : switch (byteCode) {
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 169: {
                            parameter = Integer.toString(reader.readUint8());
                            break;
                        }
                        case 18: {
                            ConstantPoolEntry entry = this.cp[reader.readUint8()];
                            switch (entry.getType()) {
                                case 3: {
                                    parameter = Integer.toString(entry.getNumericValue().intValue());
                                    break block0;
                                }
                                case 4: {
                                    parameter = Float.toString(entry.getNumericValue().floatValue());
                                    break block0;
                                }
                                case 1: 
                                case 8: {
                                    parameter = "\"" + entry.getString() + "\"";
                                    break block0;
                                }
                                case 7: {
                                    parameter = "class " + entry.getExternalClass();
                                    break block0;
                                }
                                case 15: 
                                case 16: {
                                    parameter = entry.getString();
                                    break block0;
                                }
                            }
                            parameter = "ILLEGAL PARAMETER TYPE: " + entry.getType();
                            break;
                        }
                        case 16: {
                            parameter = Integer.toString(reader.readInt8());
                            break;
                        }
                        case 188: {
                            int type = reader.readUint8();
                            switch (type) {
                                case 4: {
                                    parameter = "boolean[]";
                                    break block0;
                                }
                                case 5: {
                                    parameter = "char[]";
                                    break block0;
                                }
                                case 6: {
                                    parameter = "float[]";
                                    break block0;
                                }
                                case 7: {
                                    parameter = "double[]";
                                    break block0;
                                }
                                case 8: {
                                    parameter = "byte[]";
                                    break block0;
                                }
                                case 9: {
                                    parameter = "short[]";
                                    break block0;
                                }
                                case 10: {
                                    parameter = "int[]";
                                    break block0;
                                }
                                case 11: {
                                    parameter = "long[]";
                                    break block0;
                                }
                            }
                            parameter = "ILLEGAL PARAMETER: " + type;
                            break;
                        }
                        case 277: 
                        case 278: 
                        case 279: 
                        case 280: 
                        case 281: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 425: {
                            parameter = Integer.toString(reader.readUint16());
                            break;
                        }
                        case 197: {
                            String tmp = this.cp[reader.readUint16()].getExternalClass();
                            parameter = tmp + ", dimension=" + reader.readUint8();
                            break;
                        }
                        case 187: 
                        case 189: 
                        case 192: 
                        case 193: {
                            parameter = this.cp[reader.readUint16()].getExternalClass();
                            break;
                        }
                        case 186: {
                            int index = reader.readUint16();
                            parameter = this.cp[index].getMethodNameOfInvokeDynamic() + this.externalizeMethodSignature(this.cp[index].getMethodSigOfInvokeDynamic()) + " [#" + this.cp[index].getBoostrapMethodIndexOfInvokeDynamic() + "]";
                            break;
                        }
                        case 178: 
                        case 179: 
                        case 180: 
                        case 181: {
                            ConstantPoolEntry entry = this.cp[reader.readUint16()];
                            parameter = ConstantPoolEntry.getExternalClass("L" + entry.getReferenceClass() + ";") + "." + entry.getReferenceName() + "          // type: " + ConstantPoolEntry.getExternalClass(entry.getReferenceType());
                            break;
                        }
                        case 182: 
                        case 183: 
                        case 184: 
                        case 185: {
                            ConstantPoolEntry entry = this.cp[reader.readUint16()];
                            parameter = ConstantPoolEntry.getExternalClass("L" + entry.getReferenceClass() + ";") + "." + entry.getReferenceName() + this.externalizeMethodSignature(entry.getReferenceType());
                            break;
                        }
                        case 19: {
                            ConstantPoolEntry entry = this.cp[reader.readUint16()];
                            switch (entry.getType()) {
                                case 3: {
                                    parameter = Integer.toString(entry.getNumericValue().intValue());
                                    break block0;
                                }
                                case 4: {
                                    parameter = Float.toString(entry.getNumericValue().floatValue());
                                    break block0;
                                }
                                case 1: 
                                case 8: {
                                    parameter = "\"" + entry.getString() + "\"";
                                    break block0;
                                }
                                case 7: {
                                    parameter = "class " + entry.getExternalClass();
                                    break block0;
                                }
                                case 15: 
                                case 16: {
                                    parameter = entry.getString();
                                    break block0;
                                }
                            }
                            parameter = "ILLEGAL PARAMETER TYPE: " + entry.getType();
                            break;
                        }
                        case 20: {
                            ConstantPoolEntry entry = this.cp[reader.readUint16()];
                            Number n = entry.getNumericValue();
                            if (entry.getType() == 5) {
                                parameter = Long.toString(n.longValue());
                                break;
                            }
                            assert (entry.getType() == 6);
                            parameter = Double.toString(n.doubleValue());
                            break;
                        }
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 158: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 165: 
                        case 166: 
                        case 167: 
                        case 168: 
                        case 198: 
                        case 199: {
                            parameter = Integer.toString(bci + reader.readInt16());
                            break;
                        }
                        case 17: {
                            parameter = Integer.toString(reader.readInt16());
                            break;
                        }
                        case 132: {
                            parameter = Integer.toString(reader.readUint8()) + " += " + Integer.toString(reader.readInt8());
                            break;
                        }
                        case 388: {
                            parameter = Integer.toString(reader.readUint16()) + " += " + Integer.toString(reader.readInt16());
                            break;
                        }
                        case 200: 
                        case 201: {
                            parameter = Integer.toString(bci + reader.readInt32());
                            break;
                        }
                        case 171: {
                            int target;
                            int startOffset = bci + 4 & 0xFFFFFFFC;
                            reader = new ByteCodeReader(method.getCode(), startOffset);
                            int defaultOffset = reader.readInt32();
                            int pairs = reader.readInt32();
                            StringBuilder buffer = new StringBuilder();
                            buffer.append('[').append(pairs).append("] ");
                            for (int j = 0; j < pairs; ++j) {
                                int match = reader.readInt32();
                                target = reader.readInt32();
                                buffer.append(match).append(':').append(bci + target).append(' ');
                            }
                            buffer.append("default:").append(bci + defaultOffset);
                            parameter = buffer.toString();
                            break;
                        }
                        case 170: {
                            int target;
                            int startOffset = bci + 4 & 0xFFFFFFFC;
                            reader = new ByteCodeReader(method.getCode(), startOffset);
                            int defaultOffset = reader.readInt32();
                            int low = reader.readInt32();
                            int high = reader.readInt32();
                            StringBuilder buffer = new StringBuilder();
                            buffer.append('[').append(low).append("..").append(high).append("] ");
                            for (int j = 0; j < high - low + 1; ++j) {
                                target = reader.readInt32();
                                buffer.append(low + j).append(':').append(bci + target).append(' ');
                            }
                            buffer.append("default:").append(bci + defaultOffset);
                            parameter = buffer.toString();
                            break;
                        }
                        default: {
                            parameter = "";
                        }
                    }
                    stream.format("      %4d: %-15s %s", bci, ByteCode.getName(byteCode), parameter);
                    stream.println();
                }
                if (method.getExceptionTable().length > 0) {
                    stream.println("    Exception table:");
                    stream.println("      from   to target type");
                    for (ExceptionTableEntry entry : method.getExceptionTable()) {
                        String type = entry.getType();
                        type = type == null ? "any" : "Class " + type.replace('/', '.');
                        stream.format("      %4d %4d %6d %s", entry.getStart(), entry.getEnd(), entry.getTarget(), type);
                        stream.println();
                    }
                }
            }
            if (i + 1 == this.methods.length) continue;
            stream.println();
        }
        stream.println('}');
    }

    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public boolean isAnnotation() {
        return (this.accessFlags & 0x2000) != 0;
    }

    public boolean isEnum() {
        return (this.accessFlags & 0x4000) != 0;
    }

    private String externalizeMethodSignature(String signature) {
        StringBuilder result = new StringBuilder();
        result.append('(');
        int closingParentheses = signature.indexOf(41);
        assert (signature.charAt(0) == '(');
        String params = signature.substring(1, closingParentheses);
        while (params.length() > 0) {
            int endIndex = 0;
            while (params.charAt(endIndex) == '[') {
                ++endIndex;
            }
            switch (params.charAt(endIndex)) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    ++endIndex;
                    break;
                }
                case 'L': {
                    endIndex = params.indexOf(59) + 1;
                    break;
                }
                default: {
                    throw new IllegalStateException("Incorrect method signature: " + signature);
                }
            }
            result.append(ConstantPoolEntry.getExternalClass(params.substring(0, endIndex)));
            if ((params = params.substring(endIndex)).length() <= 0) continue;
            result.append(',');
        }
        result.append(')').append(':');
        result.append(ConstantPoolEntry.getExternalClass(signature.substring(closingParentheses + 1)));
        return result.toString();
    }
}

