/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler;

import com.sap.jvm.debugging.impl.decompiler.ast.Type;
import com.sap.jvm.jdi.Field;

public class FieldInfo {
    public final String name;
    public final String type;
    private final int accessFlags;

    public FieldInfo(String name, String type, int accessFlags) {
        this.name = name;
        this.type = type;
        this.accessFlags = accessFlags;
    }

    public FieldInfo(Field field) {
        this.name = field.name();
        this.type = field.signature();
        this.accessFlags = (field.isPublic() ? 1 : 0) | (field.isPrivate() ? 2 : 0) | (field.isProtected() ? 4 : 0) | (field.isStatic() ? 8 : 0) | (field.isFinal() ? 16 : 0) | (field.isVolatile() ? 64 : 0) | (field.isTransient() ? 128 : 0) | (field.isEnumConstant() ? 16384 : 0);
    }

    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.accessFlags & 2) != 0;
    }

    public boolean isProtected() {
        return (this.accessFlags & 4) != 0;
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isVolatile() {
        return (this.accessFlags & 0x40) != 0;
    }

    public boolean isTransient() {
        return (this.accessFlags & 0x80) != 0;
    }

    public boolean isEnum() {
        return (this.accessFlags & 0x4000) != 0;
    }

    public String toString() {
        if (this.isEnum()) {
            return this.name;
        }
        StringBuilder result = new StringBuilder();
        if (this.isPublic()) {
            result.append("public ");
        } else if (this.isPrivate()) {
            result.append("private ");
        } else if (this.isProtected()) {
            result.append("protected ");
        } else assert (this.isPackagePrivate());
        if (this.isStatic()) {
            result.append("static ");
        }
        if (this.isFinal()) {
            result.append("final ");
        }
        if (this.isTransient()) {
            result.append("transient ");
        }
        if (this.isVolatile()) {
            result.append("volatile ");
        }
        result.append(new Type(this.type));
        result.append(' ');
        result.append(this.name);
        result.append(';');
        if (this.isEnum()) {
            result.append("ENUM");
        }
        return result.toString();
    }
}

