/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler;

import com.sap.jvm.debugging.impl.decompiler.ByteCode;
import com.sap.jvm.debugging.impl.decompiler.ConstantPoolEntry;
import com.sap.jvm.debugging.impl.decompiler.ExceptionTableEntry;
import com.sap.jvm.debugging.impl.decompiler.LocalVariableTableEntry;
import com.sap.jvm.debugging.impl.decompiler.ast.Type;
import com.sap.jvm.jdi.Method;

public class MethodInfo {
    public final String className;
    public final String name;
    public final String signature;
    private final int attributes;
    private final int maxStackSize;
    private final int maxLocals;
    private final byte[] code;
    private final ConstantPoolEntry[] cp;
    private final ExceptionTableEntry[] exceptions;
    private final LocalVariableTableEntry[] variables;
    private final String[] thrownExceptions;

    public MethodInfo(String className, String name, String signature, int attributes, int maxStackSize, int maxLocals, byte[] code, ConstantPoolEntry[] cp, ExceptionTableEntry[] exceptions, LocalVariableTableEntry[] variables, String[] thrownExceptions) {
        this.className = className;
        this.name = name;
        this.signature = signature;
        this.attributes = attributes;
        this.maxStackSize = maxStackSize;
        this.maxLocals = maxLocals;
        this.code = code;
        this.cp = cp;
        this.exceptions = exceptions;
        this.variables = variables;
        this.thrownExceptions = thrownExceptions;
    }

    public MethodInfo(Method method, ConstantPoolEntry[] cp) {
        this.className = method.declaringType().name().replace('.', '/');
        this.name = method.name();
        this.signature = method.signature();
        this.attributes = (method.isPublic() ? 1 : 0) | (method.isPrivate() ? 2 : 0) | (method.isProtected() ? 4 : 0) | (method.isStatic() ? 8 : 0) | (method.isFinal() ? 16 : 0) | (method.isSynchronized() ? 32 : 0) | (method.isVarArgs() ? 128 : 0) | (method.isNative() ? 256 : 0) | (method.isAbstract() ? 1024 : 0);
        this.maxStackSize = 0;
        this.maxLocals = 0;
        this.code = method.bytecodes();
        this.cp = cp;
        int[] exceptionTable = method.getRawExceptionTable();
        this.exceptions = new ExceptionTableEntry[exceptionTable.length / 4];
        for (int i = 0; i < this.exceptions.length; ++i) {
            int tableOffset = i * 4;
            int catchType = exceptionTable[tableOffset + 3];
            String type = catchType != 0 ? cp[catchType].getString() : null;
            this.exceptions[i] = new ExceptionTableEntry(exceptionTable[tableOffset], exceptionTable[tableOffset + 1], exceptionTable[tableOffset + 2], type);
        }
        Object[] variableTable = method.getRawVariableTable();
        this.variables = new LocalVariableTableEntry[variableTable.length / 5];
        for (int i = 0; i < this.variables.length; ++i) {
            int tableOffset = i * 5;
            int startPc = (Integer)variableTable[tableOffset + 0];
            int length = (Integer)variableTable[tableOffset + 1];
            int slot = (Integer)variableTable[tableOffset + 2];
            String varName = variableTable[tableOffset + 3].toString();
            String type = variableTable[tableOffset + 4].toString();
            this.variables[i] = new LocalVariableTableEntry(startPc, length, varName, type, slot);
        }
        this.thrownExceptions = new String[0];
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public byte[] getCode() {
        return this.code;
    }

    public ConstantPoolEntry getCpEntry(int index) {
        return this.cp[index];
    }

    public ExceptionTableEntry[] getExceptionTable() {
        return this.exceptions;
    }

    public boolean isPublic() {
        return (this.attributes & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.attributes & 2) != 0;
    }

    public boolean isProtected() {
        return (this.attributes & 4) != 0;
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        return (this.attributes & 8) != 0;
    }

    public boolean isFinal() {
        return (this.attributes & 0x10) != 0;
    }

    public boolean isSynchronized() {
        return (this.attributes & 0x20) != 0;
    }

    public boolean hasVarArgs() {
        return (this.attributes & 0x80) != 0;
    }

    public boolean isNative() {
        return (this.attributes & 0x100) != 0;
    }

    public boolean isAbstract() {
        return (this.attributes & 0x400) != 0;
    }

    public boolean isStrictFP() {
        return (this.attributes & 0x800) != 0;
    }

    public String getClassName() {
        return this.className.replace('/', '.');
    }

    public String getVariableName(int bci, int slot) {
        LocalVariableTableEntry entry = this.getVariableEntry(bci, slot);
        if (entry != null) {
            return entry.name;
        }
        if (this.isStatic()) {
            return "v" + (slot + 1);
        }
        if (slot == 0) {
            return "this";
        }
        return "v" + slot;
    }

    public LocalVariableTableEntry getVariableEntry(int bci, int slot) {
        for (LocalVariableTableEntry entry : this.variables) {
            if (entry.slot != slot || bci < entry.startPc || bci >= entry.startPc + entry.length) continue;
            return entry;
        }
        int byteCode = ByteCode.getByteCode(bci, this);
        switch (byteCode) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: {
                int realBci = bci + ByteCode.getSize(bci, this);
                for (LocalVariableTableEntry entry : this.variables) {
                    if (entry.slot != slot || realBci < entry.startPc || realBci >= entry.startPc + entry.length) continue;
                    return entry;
                }
                break;
            }
        }
        return null;
    }

    public String getFullyQualifiedName() {
        if ("<clinit>".equals(this.name)) {
            return this.className.replace('/', '.') + ".static";
        }
        StringBuilder result = new StringBuilder();
        result.append(this.className.replace('/', '.')).append('.');
        int closingParenthesis = this.signature.lastIndexOf(41);
        assert (this.signature.charAt(0) == '(' && closingParenthesis > 0);
        String returnType = this.signature.substring(closingParenthesis + 1);
        String methodName = this.name;
        String returnTypeAppendix = "";
        if ("<init>".equals(this.name)) {
            int lastSlash = this.className.lastIndexOf(47);
            methodName = lastSlash > 0 ? this.className.substring(lastSlash + 1) : this.className;
        } else {
            returnTypeAppendix = ":" + new Type(returnType);
        }
        result.append(methodName).append('(');
        result.append(this.getFormattedSignature());
        result.append(')');
        result.append(returnTypeAppendix);
        return result.toString();
    }

    private String getFormattedSignature() {
        int closingParenthesis = this.signature.lastIndexOf(41);
        Type[] parameterTypes = Type.createTypes(this.signature.substring(1, closingParenthesis));
        if (parameterTypes.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            if (i == parameterTypes.length - 1 && this.hasVarArgs()) {
                String type = parameterTypes[i].toString();
                result.append(type.subSequence(0, type.length() - 2)).append("...");
                continue;
            }
            result.append(parameterTypes[i]);
        }
        return result.toString();
    }

    public String getAlternativeFullyQualifiedName() {
        if ("<clinit>".equals(this.name)) {
            return this.className.replace('/', '.') + "." + this.name + "():void";
        }
        if ("<init>".equals(this.name)) {
            return this.className.replace('/', '.') + "." + this.name + "(" + this.getFormattedSignature() + "):void";
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.isPublic()) {
            result.append("public ");
        } else if (this.isPrivate()) {
            result.append("private ");
        } else if (this.isProtected()) {
            result.append("protected ");
        } else assert (this.isPackagePrivate());
        if (this.isAbstract()) {
            result.append("abstract ");
        }
        if (this.isStatic()) {
            result.append("static ");
        }
        if (this.isFinal()) {
            result.append("final ");
        }
        if (this.isSynchronized()) {
            result.append("synchronized ");
        }
        if (this.isNative()) {
            result.append("native ");
        }
        if (this.isStrictFP()) {
            result.append("strictfp ");
        }
        if ("<clinit>".equals(this.name)) {
            if (result.charAt(result.length() - 1) == ' ') {
                result.setLength(result.length() - 1);
            }
        } else {
            int i;
            int closingParenthesis = this.signature.lastIndexOf(41);
            assert (this.signature.charAt(0) == '(' && closingParenthesis > 0);
            String returnType = this.signature.substring(closingParenthesis + 1);
            Type[] parameterTypes = Type.createTypes(this.signature.substring(1, closingParenthesis));
            String methodName = this.name;
            if ("<init>".equals(this.name)) {
                int lastSlash = this.className.lastIndexOf(47);
                methodName = lastSlash > 0 ? this.className.substring(lastSlash + 1) : this.className;
            } else {
                result.append(new Type(returnType)).append(" ");
            }
            result.append(methodName).append('(');
            for (i = 0; i < parameterTypes.length; ++i) {
                if (i != 0) {
                    result.append(", ");
                }
                if (i == parameterTypes.length - 1 && this.hasVarArgs()) {
                    String type = parameterTypes[i].toString();
                    result.append(type.subSequence(0, type.length() - 2)).append("...");
                } else {
                    result.append(parameterTypes[i]);
                }
                int index = i + (this.isStatic() ? 0 : 1);
                if (index >= this.variables.length) continue;
                result.append(' ').append(this.variables[index].name);
            }
            result.append(')');
            for (i = 0; i < this.thrownExceptions.length; ++i) {
                if (i == 0) {
                    result.append(" throws ");
                } else {
                    result.append(", ");
                }
                result.append(this.thrownExceptions[i].replace('/', '.'));
            }
        }
        if (this.code != null) {
            // empty if block
        }
        return result.toString();
    }
}

