/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler;

import com.sap.jvm.debugging.impl.decompiler.ConstantPoolEntry;
import com.sap.jvm.debugging.impl.decompiler.Decompiler;
import com.sap.jvm.debugging.impl.decompiler.FieldInfo;
import com.sap.jvm.debugging.impl.decompiler.MethodInfo;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class MissingReferenceFinder {
    private static final HashSet<String> classes = new HashSet();
    private static final HashSet<String> methods = new HashSet();
    private static final HashSet<String> fields = new HashSet();
    private static final HashMap<String, HashSet<String>> missingClasses = new HashMap();

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("MissingReferenceFinder <jar> [<jar> ...]");
            return;
        }
        for (String jar : args) {
            MissingReferenceFinder.add(jar);
        }
        for (String jar : args) {
            MissingReferenceFinder.check(jar);
        }
        for (String clazz : missingClasses.keySet()) {
            System.out.println(clazz + " missing in " + missingClasses.get(clazz));
        }
    }

    private static void add(String jar) throws Exception {
        JarFile file = new JarFile(jar);
        Enumeration<JarEntry> it = file.entries();
        while (it.hasMoreElements()) {
            JarEntry entry = it.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            InputStream is = file.getInputStream(entry);
            BufferedInputStream bis = new BufferedInputStream(is);
            DataInputStream dis = new DataInputStream(bis);
            Decompiler decomp = new Decompiler(dis);
            classes.add(decomp.getClassName());
            for (MethodInfo method : decomp.getMethods()) {
                methods.add(method.className + "." + method.name + method.signature);
            }
            for (FieldInfo field : decomp.getFields()) {
                fields.add(field.type + " " + field.name);
            }
        }
        file.close();
    }

    private static void check(String jar) throws Exception {
        JarFile file = new JarFile(jar);
        Enumeration<JarEntry> it = file.entries();
        while (it.hasMoreElements()) {
            JarEntry entry = it.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            InputStream is = file.getInputStream(entry);
            BufferedInputStream bis = new BufferedInputStream(is);
            DataInputStream dis = new DataInputStream(bis);
            Decompiler decomp = new Decompiler(dis);
            for (ConstantPoolEntry cpEntry : decomp.getCp()) {
                if (cpEntry == null || cpEntry.getType() != 7) continue;
                String toSearch = cpEntry.getString();
                if (toSearch.startsWith("[")) {
                    if (!toSearch.contains(";")) continue;
                    toSearch = toSearch.substring(toSearch.indexOf(76) + 1, toSearch.indexOf(59));
                }
                if (classes.contains(toSearch)) continue;
                HashSet<String> missing = missingClasses.get(cpEntry.getExternalClass());
                if (missing == null) {
                    missing = new HashSet();
                }
                missing.add(jar);
                missingClasses.put(cpEntry.getExternalClass(), missing);
            }
            classes.add(decomp.getClassName().replace('/', '.'));
        }
        file.close();
    }
}

