/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler;

import com.sap.jvm.debugging.impl.decompiler.StackType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class TrackingStack {
    private final int[][] sources;
    private final StackType[][] sourceTypes;
    private final int bigness;

    private TrackingStack(int[][] sources, StackType[][] types, int bigness) {
        this.sources = sources;
        this.sourceTypes = types;
        this.bigness = bigness;
    }

    public TrackingStack() {
        this.sources = new int[0][];
        this.sourceTypes = new StackType[0][];
        this.bigness = 0;
    }

    public TrackingStack pop(int n) {
        int[][] newSources = new int[this.sources.length - n][];
        System.arraycopy(this.sources, n, newSources, 0, newSources.length);
        StackType[][] newTypes = new StackType[this.sourceTypes.length - n][];
        System.arraycopy(this.sourceTypes, n, newTypes, 0, newTypes.length);
        return new TrackingStack(newSources, newTypes, this.bigness);
    }

    public TrackingStack pop() {
        return this.pop(1);
    }

    public TrackingStack push(int bci, StackType type) {
        assert (bci >= -1);
        assert (bci < 65536);
        int[][] newSources = new int[this.sources.length + 1][];
        System.arraycopy(this.sources, 0, newSources, 1, this.sources.length);
        newSources[0] = new int[]{bci};
        StackType[][] newTypes = new StackType[this.sourceTypes.length + 1][];
        System.arraycopy(this.sourceTypes, 0, newTypes, 1, this.sourceTypes.length);
        newTypes[0] = new StackType[]{type};
        return new TrackingStack(newSources, newTypes, this.bigness);
    }

    public TrackingStack push2(int bci, StackType type) {
        assert (bci >= -1);
        assert (bci < 65536);
        return this.push(bci, type).push(bci, type.getSecondSlotType());
    }

    public TrackingStack push(int[] bcis, StackType[] types) {
        for (int bci : bcis) {
            assert (bci >= -1);
            assert (bci < 65536);
        }
        int[][] newSources = new int[this.sources.length + 1][];
        System.arraycopy(this.sources, 0, newSources, 1, this.sources.length);
        newSources[0] = bcis;
        StackType[][] newTypes = new StackType[this.sourceTypes.length + 1][];
        System.arraycopy(this.sourceTypes, 0, newTypes, 1, this.sourceTypes.length);
        newTypes[0] = types;
        return new TrackingStack(newSources, newTypes, this.bigness);
    }

    public TrackingStack merge(TrackingStack other) {
        if (other == null) {
            return this;
        }
        assert (this.sources.length == other.sources.length);
        int[][] newSources = new int[this.sources.length][];
        HashMap<Integer, StackType> bcis = new HashMap<Integer, StackType>();
        boolean hasNewEntries = false;
        StackType[][] newTypes = new StackType[this.sourceTypes.length][];
        for (int i = 0; i < this.sources.length; ++i) {
            int j;
            bcis.clear();
            for (j = 0; j < this.sources[i].length; ++j) {
                bcis.put(this.sources[i][j], this.sourceTypes[i][j]);
            }
            for (j = 0; j < other.sources[i].length; ++j) {
                hasNewEntries |= bcis.put(other.sources[i][j], other.sourceTypes[i][j]) == null;
            }
            int[] newBcis = new int[bcis.size()];
            StackType[] newSourceTypes = new StackType[newBcis.length];
            int index = 0;
            Iterator iterator = bcis.keySet().iterator();
            while (iterator.hasNext()) {
                int bci;
                newBcis[index] = bci = ((Integer)iterator.next()).intValue();
                newSourceTypes[index] = (StackType)bcis.get(bci);
                ++index;
            }
            newSources[i] = newBcis;
            newTypes[i] = newSourceTypes;
        }
        return new TrackingStack(newSources, newTypes, this.bigness + (hasNewEntries ? 1 : 0));
    }

    public int size() {
        return this.sources.length;
    }

    public int[] get(int slot) {
        return this.sources[slot];
    }

    public StackType[] getTypes(int slot) {
        return this.sourceTypes[slot];
    }

    public boolean isBiggerThan(TrackingStack other) {
        return this.bigness > other.bigness;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        for (int[] dests : this.sources) {
            result.append(Arrays.toString(dests));
            result.append(", ");
        }
        if (result.length() > 1) {
            return result.substring(0, result.length() - 2) + "]";
        }
        return result + "]";
    }
}

