/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler;

import com.sap.jvm.debugging.impl.decompiler.ByteCode;
import com.sap.jvm.debugging.impl.decompiler.ByteCodeReader;
import com.sap.jvm.debugging.impl.decompiler.ConstantPoolEntry;
import com.sap.jvm.debugging.impl.decompiler.ExceptionTableEntry;
import com.sap.jvm.debugging.impl.decompiler.MethodInfo;
import com.sap.jvm.debugging.impl.decompiler.StackType;
import com.sap.jvm.debugging.impl.decompiler.TrackingStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class TrackingStackCreator {
    private final HashMap<Integer, TrackingStack> stacks;
    private final HashMap<Integer, ArrayList<Integer>> usedArgs;
    private final HashMap<Integer, Integer> stackSizes;
    private final HashMap<Integer, ArrayList<Integer>> froms;
    private final HashMap<Integer, ArrayList<Integer>> tos;
    private final MethodInfo method;
    private boolean needsRescan;
    private TrackingStack stack;
    private ArrayList<Integer> args;
    private final HashSet<Integer> jumpTargets;
    private int currentBci;
    private int popIndex;

    public TrackingStackCreator(MethodInfo method, boolean debug) {
        this.method = method;
        this.stacks = new HashMap();
        this.jumpTargets = new HashSet();
        this.usedArgs = new HashMap();
        this.stackSizes = new HashMap();
        this.stacks.put(0, new TrackingStack());
        this.froms = new HashMap();
        this.tos = new HashMap();
        int end = method.getCode().length;
        for (ExceptionTableEntry entry : method.getExceptionTable()) {
            this.stacks.put(entry.getTarget(), new TrackingStack().push(-1, new StackType("V")));
        }
        this.needsRescan = true;
        while (this.needsRescan) {
            this.needsRescan = false;
            ArrayList<Integer> toProcess = new ArrayList<Integer>();
            for (int pos = 0; pos < end; pos += ByteCode.getSize(pos, method)) {
                toProcess.add(pos);
            }
            boolean finished = false;
            while (!finished) {
                ArrayList<Integer> failed = new ArrayList<Integer>();
                finished = true;
                Iterator iterator = toProcess.iterator();
                while (iterator.hasNext()) {
                    int bci = (Integer)iterator.next();
                    if (!this.doInstruction(bci, debug)) {
                        failed.add(bci);
                        continue;
                    }
                    finished = false;
                }
                if (failed.isEmpty()) {
                    finished = true;
                }
                toProcess = failed;
            }
        }
        if (debug) {
            for (int pos = 0; pos < end; pos += ByteCode.getSize(pos, method)) {
                if (this.stacks.containsKey(pos)) continue;
                System.out.println("Could not process bci " + pos);
            }
        }
    }

    public int[] getProcessedByteCodes() {
        int[] result = new int[this.stacks.size()];
        int index = 0;
        Iterator<Integer> iterator = this.stacks.keySet().iterator();
        while (iterator.hasNext()) {
            int bci;
            result[index] = bci = iterator.next().intValue();
            ++index;
        }
        Arrays.sort(result);
        return result;
    }

    public TrackingStack getStack(int bci) {
        TrackingStack result = this.stacks.get(bci);
        if (result == null) {
            return new TrackingStack();
        }
        return result;
    }

    public ArrayList<Integer> getPrevBcis(int bci) {
        return this.froms.get(bci);
    }

    public int[] getBcis() {
        int[] result = new int[this.stacks.size()];
        int i = 0;
        Iterator<Integer> iterator = this.stacks.keySet().iterator();
        while (iterator.hasNext()) {
            int bci;
            result[i] = bci = iterator.next().intValue();
            ++i;
        }
        Arrays.sort(result);
        return result;
    }

    public ArrayList<Integer> getNextBcis(int bci) {
        return this.tos.get(bci);
    }

    public int getStackSizeAfterInstruction(int bci) {
        return this.stackSizes.get(bci);
    }

    public ArrayList<Integer> getUsedArgs(int bci) {
        ArrayList<Integer> result = this.usedArgs.get(bci);
        if (result == null) {
            return new ArrayList<Integer>();
        }
        return result;
    }

    public boolean isJumpTarget(int bci) {
        return this.jumpTargets.contains(bci);
    }

    public int getByteCode(int bci) {
        return ByteCode.getByteCode(bci, this.method);
    }

    public MethodInfo getMethodInfo() {
        return this.method;
    }

    private boolean doInstruction(int bci, boolean debug) {
        this.currentBci = bci;
        this.stack = this.stacks.get(this.currentBci);
        int len = ByteCode.getSize(this.currentBci, this.method);
        if (this.stack == null) {
            return false;
        }
        byte[] code = this.method.getCode();
        int byteCode = ByteCode.getByteCode(this.currentBci, this.method);
        int pos = this.currentBci + ByteCode.getByteCodeParameterOffset(byteCode);
        ByteCodeReader reader = new ByteCodeReader(code, pos);
        ArrayList<Integer> destinations = new ArrayList<Integer>();
        destinations.add(this.currentBci + len);
        this.args = this.usedArgs.get(this.currentBci);
        this.popIndex = 0;
        if (this.args == null) {
            this.args = new ArrayList();
        } else {
            this.args.clear();
        }
        block0 : switch (byteCode) {
            case 0: {
                break;
            }
            case 9: 
            case 10: 
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 278: {
                this.push2("J");
                break;
            }
            case 14: 
            case 15: 
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 280: {
                this.push2("D");
                break;
            }
            case 1: 
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 281: {
                this.push("Ljava/lang/Object;");
                break;
            }
            case 187: {
                this.push(this.method.getCpEntry(reader.readUint16()).asFieldDescriptor());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 277: {
                this.push("I");
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 279: {
                this.push("F");
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                int cpIndex = byteCode == 18 ? reader.readUint8() : reader.readUint16();
                ConstantPoolEntry entry = this.method.getCpEntry(cpIndex);
                int type = entry.getType();
                switch (type) {
                    case 6: {
                        this.push2("D");
                        break block0;
                    }
                    case 5: {
                        this.push2("J");
                        break block0;
                    }
                    case 4: {
                        this.push("F");
                        break block0;
                    }
                    case 3: {
                        this.push("I");
                        break block0;
                    }
                    case 8: {
                        this.push("Ljava/lang/String;");
                        break block0;
                    }
                    case 7: {
                        this.push("Ljava/lang/Class;");
                        break block0;
                    }
                }
                this.push("V");
                break;
            }
            case 47: {
                this.pop().pop().push2("J");
                break;
            }
            case 49: {
                this.pop().pop().push2("D");
                break;
            }
            case 46: {
                this.pop().pop().push("I");
                break;
            }
            case 48: {
                this.pop().pop().push("F");
                break;
            }
            case 50: {
                this.pop().pop().push("Ljava/lang/Object;");
                break;
            }
            case 51: {
                this.pop().pop().push("B");
                break;
            }
            case 52: {
                this.pop().pop().push("C");
                break;
            }
            case 53: {
                this.pop().pop().push("S");
                break;
            }
            case 55: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 88: 
            case 311: 
            case 313: {
                this.pop2();
                break;
            }
            case 80: 
            case 82: {
                this.pop2().pop().pop();
                break;
            }
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 87: 
            case 194: 
            case 195: 
            case 310: 
            case 312: 
            case 314: {
                this.pop();
                break;
            }
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.pop().pop().pop();
                break;
            }
            case 89: {
                int[] top1 = this.stack.get(0);
                StackType[] types1 = this.stack.getTypes(0);
                this.pop().push(top1, types1).push(top1, types1);
                break;
            }
            case 90: {
                int[] top1 = this.stack.get(0);
                StackType[] types1 = this.stack.getTypes(0);
                int[] top2 = this.stack.get(1);
                StackType[] types2 = this.stack.getTypes(1);
                this.pop().pop().push(top1, types1).push(top2, types2).push(top1, types1);
                break;
            }
            case 91: {
                int[] top1 = this.stack.get(0);
                StackType[] types1 = this.stack.getTypes(0);
                int[] top2 = this.stack.get(1);
                StackType[] types2 = this.stack.getTypes(1);
                int[] top3 = this.stack.get(2);
                StackType[] types3 = this.stack.getTypes(2);
                this.pop().pop().pop().push(top1, types1).push(top3, types3).push(top2, types2).push(top1, types1);
                break;
            }
            case 92: {
                int[] top1 = this.stack.get(0);
                StackType[] types1 = this.stack.getTypes(0);
                int[] top2 = this.stack.get(1);
                StackType[] types2 = this.stack.getTypes(1);
                this.pop2().push(top2, types2).push(top1, types1).push(top2, types2).push(top1, types1);
                break;
            }
            case 93: {
                int[] top1 = this.stack.get(0);
                StackType[] types1 = this.stack.getTypes(0);
                int[] top2 = this.stack.get(1);
                StackType[] types2 = this.stack.getTypes(1);
                int[] top3 = this.stack.get(2);
                StackType[] types3 = this.stack.getTypes(2);
                this.pop2().pop().push(top2, types2).push(top1, types1).push(top3, types3).push(top2, types2).push(top1, types1);
                break;
            }
            case 94: {
                int[] top1 = this.stack.get(0);
                StackType[] types1 = this.stack.getTypes(0);
                int[] top2 = this.stack.get(1);
                StackType[] types2 = this.stack.getTypes(1);
                int[] top3 = this.stack.get(2);
                StackType[] types3 = this.stack.getTypes(2);
                int[] top4 = this.stack.get(3);
                StackType[] types4 = this.stack.getTypes(3);
                this.pop2().pop().pop().push(top2, types2).push(top1, types1).push(top4, types4).push(top3, types3).push(top2, types2).push(top1, types1);
                break;
            }
            case 95: {
                int[] top1 = this.stack.get(0);
                StackType[] types1 = this.stack.getTypes(0);
                int[] top2 = this.stack.get(1);
                StackType[] types2 = this.stack.getTypes(1);
                this.pop().pop().push(top1, types1).push(top2, types2);
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: {
                this.pop2().pop2().push2("J");
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                this.pop2().pop2().push2("D");
                break;
            }
            case 96: 
            case 100: 
            case 108: 
            case 112: 
            case 126: 
            case 128: 
            case 130: {
                this.pop().pop().push("I");
                break;
            }
            case 98: 
            case 102: 
            case 104: 
            case 106: 
            case 110: 
            case 114: {
                this.pop().pop().push("F");
                break;
            }
            case 117: {
                this.pop2().push2("J");
                break;
            }
            case 119: {
                this.pop2().push2("D");
                break;
            }
            case 116: {
                this.pop().push("I");
                break;
            }
            case 118: {
                this.pop().push("F");
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                this.pop().pop2().push2("J");
                break;
            }
            case 120: 
            case 122: 
            case 124: {
                this.pop().pop().push("I");
                break;
            }
            case 133: 
            case 140: {
                this.pop().push2("J");
                break;
            }
            case 135: 
            case 141: {
                this.pop().push2("D");
                break;
            }
            case 134: {
                this.pop().push("F");
                break;
            }
            case 139: {
                this.pop().push("I");
                break;
            }
            case 145: {
                this.pop().push("B");
                break;
            }
            case 146: {
                this.pop().push("C");
                break;
            }
            case 147: {
                this.pop().push("S");
                break;
            }
            case 138: {
                this.pop2().push2("D");
                break;
            }
            case 143: {
                this.pop2().push2("J");
                break;
            }
            case 136: 
            case 142: {
                this.pop2().push("I");
                break;
            }
            case 137: 
            case 144: {
                this.pop2().push("F");
                break;
            }
            case 148: 
            case 151: 
            case 152: {
                this.pop2().pop2().push("I");
                break;
            }
            case 149: 
            case 150: {
                this.pop().pop().push("I");
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.pop().pop();
                destinations.add(this.currentBci + reader.readInt16());
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                this.pop();
                destinations.add(this.currentBci + reader.readInt16());
                break;
            }
            case 168: {
                this.stacks.put(this.currentBci + len, this.stack.merge(this.stacks.get(this.currentBci + len)));
                this.push("V");
                destinations = new ArrayList();
                destinations.add(this.currentBci + reader.readInt16());
                break;
            }
            case 201: {
                this.stacks.put(this.currentBci + len, this.stack.merge(this.stacks.get(this.currentBci + len)));
                this.push("V");
                destinations = new ArrayList();
                destinations.add(this.currentBci + reader.readInt32());
                break;
            }
            case 169: 
            case 425: {
                destinations = new ArrayList();
                break;
            }
            case 170: {
                this.pop();
                int startPos = pos + 3 & 0xFFFFFFFC;
                reader.skip(startPos - pos);
                destinations = new ArrayList();
                destinations.add(this.currentBci + reader.readInt32());
                int low = reader.readInt32();
                int high = reader.readInt32();
                for (int i = low; i <= high; ++i) {
                    destinations.add(this.currentBci + reader.readInt32());
                }
                break;
            }
            case 171: {
                this.pop();
                int startPos = pos + 3 & 0xFFFFFFFC;
                reader.skip(startPos - pos);
                destinations = new ArrayList();
                destinations.add(this.currentBci + reader.readInt32());
                int nrOfCases = reader.readInt32();
                for (int i = 0; i < nrOfCases; ++i) {
                    reader.skip(4);
                    destinations.add(this.currentBci + reader.readInt32());
                }
                break;
            }
            case 173: 
            case 175: {
                this.pop2();
                destinations = new ArrayList();
                break;
            }
            case 177: {
                destinations = new ArrayList();
                break;
            }
            case 172: 
            case 174: 
            case 176: 
            case 191: {
                this.pop();
                destinations = new ArrayList();
                break;
            }
            case 178: 
            case 180: {
                int cpIndex = reader.readUint16();
                String type = this.method.getCpEntry(cpIndex).getReferenceType();
                if (byteCode == 180) {
                    this.pop();
                }
                if ("J".equals(type) || "D".equals(type)) {
                    this.push2(type);
                    break;
                }
                this.push(type);
                break;
            }
            case 179: 
            case 181: {
                int cpIndex = reader.readUint16();
                String type = this.method.getCpEntry(cpIndex).getReferenceType();
                if ("J".equals(type) || "D".equals(type)) {
                    this.pop2();
                } else {
                    this.pop();
                }
                if (byteCode != 181) break;
                this.pop();
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: {
                String returnType;
                int cpIndex = reader.readUint16();
                String signature = this.method.getCpEntry(cpIndex).getReferenceType();
                String arguments = signature.substring(1, signature.indexOf(41));
                boolean inArray = false;
                boolean inObject = false;
                ArrayList<Boolean> pops = new ArrayList<Boolean>();
                for (char c : arguments.toCharArray()) {
                    if (c == '[') {
                        inArray = true;
                        continue;
                    }
                    if (c == 'L') {
                        inObject = true;
                        continue;
                    }
                    if (c == 'J' || c == 'D') {
                        if (!inArray && !inObject) {
                            pops.add(true);
                        }
                        if (!inArray || inObject) continue;
                        pops.add(false);
                        inArray = false;
                        continue;
                    }
                    if (c == 'Z' || c == 'B' || c == 'S' || c == 'C' || c == 'I' || c == 'F') {
                        if (!inArray && !inObject) {
                            pops.add(false);
                        }
                        if (!inArray || inObject) continue;
                        pops.add(false);
                        inArray = false;
                        continue;
                    }
                    if (c != ';') continue;
                    pops.add(false);
                    inArray = false;
                    inObject = false;
                }
                for (int i = pops.size() - 1; i >= 0; --i) {
                    if (((Boolean)pops.get(i)).booleanValue()) {
                        this.pop2();
                        continue;
                    }
                    this.pop();
                }
                if (byteCode != 184 && byteCode != 186) {
                    this.pop();
                }
                if ("J".equals(returnType = signature.substring(signature.indexOf(41) + 1, signature.length())) || "D".equals(returnType)) {
                    this.push2(returnType);
                    break;
                }
                if ("V".equals(returnType)) break;
                this.push(returnType);
                break;
            }
            case 188: {
                this.pop().push(ByteCode.getTypeForNewArray(reader.readInt8()));
                break;
            }
            case 189: {
                ConstantPoolEntry entry = this.method.getCpEntry(reader.readUint16());
                if (entry.getString().startsWith("[")) {
                    this.pop().push("[" + entry.getString());
                    break;
                }
                this.pop().push("[L" + entry.getString() + ";");
                break;
            }
            case 193: {
                this.pop().push("Z");
                break;
            }
            case 190: {
                this.pop().push("I");
                break;
            }
            case 192: {
                this.pop().push(this.method.getCpEntry(reader.readUint16()).asFieldDescriptor());
                break;
            }
            case 132: 
            case 388: {
                break;
            }
            case 197: {
                reader.skip(2);
                for (int i = reader.readUint8() - 1; i >= 0; --i) {
                    this.pop();
                }
                this.push("[Ljava.lang.Object;");
                break;
            }
            case 167: {
                destinations = new ArrayList();
                destinations.add(this.currentBci + reader.readInt16());
                break;
            }
            case 200: {
                destinations = new ArrayList();
                destinations.add(this.currentBci + reader.readInt32());
                break;
            }
            default: {
                throw new RuntimeException("Unknown byte code " + byteCode);
            }
        }
        this.tos.put(bci, destinations);
        Iterator iterator = destinations.iterator();
        while (iterator.hasNext()) {
            ArrayList<Object> currFroms;
            int destBci = (Integer)iterator.next();
            if (destBci == this.currentBci) continue;
            if (!this.froms.containsKey(destBci)) {
                currFroms = new ArrayList(1);
                this.froms.put(destBci, currFroms);
            } else {
                currFroms = this.froms.get(destBci);
            }
            if (!currFroms.contains(bci)) {
                currFroms.add(bci);
            }
            TrackingStack originalStack = this.stacks.get(destBci);
            TrackingStack mergedStack = this.stack;
            if (originalStack != null && (mergedStack = originalStack.merge(this.stack)).isBiggerThan(originalStack)) {
                this.needsRescan = true;
            }
            if (destBci != bci + len) {
                this.jumpTargets.add(destBci);
            }
            if (debug) {
                System.out.println(this.currentBci + "->" + destBci + ": Stack size " + mergedStack.size() + " " + mergedStack);
            }
            this.stacks.put(destBci, mergedStack);
        }
        if (this.args.size() > 1) {
            Collections.reverse(this.args);
        }
        this.stackSizes.put(bci, this.stack.size());
        this.usedArgs.put(this.currentBci, new ArrayList<Integer>(this.args));
        return true;
    }

    private TrackingStackCreator push2(String type) {
        this.stack = this.stack.push2(this.currentBci, new StackType(type));
        return this;
    }

    private TrackingStackCreator push(String type) {
        this.stack = this.stack.push(this.currentBci, new StackType(type));
        return this;
    }

    private TrackingStackCreator push(int[] bcis, StackType[] types) {
        this.stack = this.stack.push(bcis, types);
        return this;
    }

    private TrackingStackCreator pop2() {
        this.stack = this.stack.pop(2);
        this.args.add(this.popIndex);
        this.popIndex += 2;
        return this;
    }

    private TrackingStackCreator pop() {
        this.stack = this.stack.pop();
        this.args.add(this.popIndex);
        ++this.popIndex;
        return this;
    }
}

