/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler.ast;

import com.sap.jvm.debugging.impl.decompiler.AnnotatedPrintStreamImpl;
import com.sap.jvm.debugging.impl.decompiler.ByteCode;
import com.sap.jvm.debugging.impl.decompiler.ByteCodeReader;
import com.sap.jvm.debugging.impl.decompiler.ConstantPoolEntry;
import com.sap.jvm.debugging.impl.decompiler.ControlFlowAnalyzer;
import com.sap.jvm.debugging.impl.decompiler.ExceptionTableEntry;
import com.sap.jvm.debugging.impl.decompiler.LocalVariableTableEntry;
import com.sap.jvm.debugging.impl.decompiler.MethodInfo;
import com.sap.jvm.debugging.impl.decompiler.TrackingStackCreator;
import com.sap.jvm.debugging.impl.decompiler.ast.ArrayAssignOp;
import com.sap.jvm.debugging.impl.decompiler.ast.ArrayInitializationOp;
import com.sap.jvm.debugging.impl.decompiler.ast.ArrayOperationAndAssignOp;
import com.sap.jvm.debugging.impl.decompiler.ast.ArrayValueOp;
import com.sap.jvm.debugging.impl.decompiler.ast.BinaryComparisonOp;
import com.sap.jvm.debugging.impl.decompiler.ast.BinaryOp;
import com.sap.jvm.debugging.impl.decompiler.ast.BooleanExpressionOp;
import com.sap.jvm.debugging.impl.decompiler.ast.BreakOp;
import com.sap.jvm.debugging.impl.decompiler.ast.ByteCodeSequence;
import com.sap.jvm.debugging.impl.decompiler.ast.CastOp;
import com.sap.jvm.debugging.impl.decompiler.ast.CompareToComparisonOp;
import com.sap.jvm.debugging.impl.decompiler.ast.CompareToOp;
import com.sap.jvm.debugging.impl.decompiler.ast.ComparisonOp;
import com.sap.jvm.debugging.impl.decompiler.ast.ConstantOp;
import com.sap.jvm.debugging.impl.decompiler.ast.ContinueOp;
import com.sap.jvm.debugging.impl.decompiler.ast.DoWhileOp;
import com.sap.jvm.debugging.impl.decompiler.ast.IfOp;
import com.sap.jvm.debugging.impl.decompiler.ast.InstanceFieldAssignOp;
import com.sap.jvm.debugging.impl.decompiler.ast.InstanceFieldOperationAndAssignOp;
import com.sap.jvm.debugging.impl.decompiler.ast.InstanceFieldValueOp;
import com.sap.jvm.debugging.impl.decompiler.ast.JsrOp;
import com.sap.jvm.debugging.impl.decompiler.ast.LengthOp;
import com.sap.jvm.debugging.impl.decompiler.ast.LocalVarAssignOp;
import com.sap.jvm.debugging.impl.decompiler.ast.LocalVarOperationAndAssignOp;
import com.sap.jvm.debugging.impl.decompiler.ast.LocalVarValueOp;
import com.sap.jvm.debugging.impl.decompiler.ast.MethodOp;
import com.sap.jvm.debugging.impl.decompiler.ast.NewArrayOp;
import com.sap.jvm.debugging.impl.decompiler.ast.NewCallOp;
import com.sap.jvm.debugging.impl.decompiler.ast.NewOp;
import com.sap.jvm.debugging.impl.decompiler.ast.Node;
import com.sap.jvm.debugging.impl.decompiler.ast.NodeOp;
import com.sap.jvm.debugging.impl.decompiler.ast.NodePrinter;
import com.sap.jvm.debugging.impl.decompiler.ast.NopOp;
import com.sap.jvm.debugging.impl.decompiler.ast.OneParameterTestOp;
import com.sap.jvm.debugging.impl.decompiler.ast.PostdecNodeOp;
import com.sap.jvm.debugging.impl.decompiler.ast.PostincNodeOp;
import com.sap.jvm.debugging.impl.decompiler.ast.PredecNodeOp;
import com.sap.jvm.debugging.impl.decompiler.ast.PreincNodeOp;
import com.sap.jvm.debugging.impl.decompiler.ast.ReturnOp;
import com.sap.jvm.debugging.impl.decompiler.ast.Scope;
import com.sap.jvm.debugging.impl.decompiler.ast.ScopeOp;
import com.sap.jvm.debugging.impl.decompiler.ast.StaticCallOp;
import com.sap.jvm.debugging.impl.decompiler.ast.StaticFieldAssignOp;
import com.sap.jvm.debugging.impl.decompiler.ast.StaticFieldOperationAndAssignOp;
import com.sap.jvm.debugging.impl.decompiler.ast.StaticFieldValueOp;
import com.sap.jvm.debugging.impl.decompiler.ast.SwitchOp;
import com.sap.jvm.debugging.impl.decompiler.ast.SynchronizedOp;
import com.sap.jvm.debugging.impl.decompiler.ast.TernaryOperatorOp;
import com.sap.jvm.debugging.impl.decompiler.ast.TryCatchFinallyOp;
import com.sap.jvm.debugging.impl.decompiler.ast.Type;
import com.sap.jvm.debugging.impl.decompiler.ast.UnaryComparisonOp;
import com.sap.jvm.debugging.impl.decompiler.ast.UnaryOp;
import com.sap.jvm.debugging.impl.decompiler.ast.VirtualCallOp;
import com.sap.jvm.debugging.impl.decompiler.ast.WhileOp;
import com.sap.jvm.debugging.impl.decompiler.ast.WhileTrueOp;
import com.sap.jvm.util.misc.SignatureHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ASTBuilder {
    private final MethodInfo method;
    private final TrackingStackCreator tsc;
    private final ControlFlowAnalyzer cfa;
    private final Node[] expressions;
    private final boolean debug;
    private final int[] byteCodes;
    private final int[] lens;
    private final int[] jumpTargetBcis;
    private final int[] jsrTargetBcis;
    private final HashMap<Bcis, ArrayList<Integer>> sideEffectBcis;
    private final HashMap<Integer, int[]> sideEffectSources;
    private final HashMap<Bcis, Node> sideEffectNodes;
    private final HashSet<Integer> postIncBcis;
    private final ByteCodeSequence classSequence1;
    private final ByteCodeSequence classSequence2;
    private final ByteCodeSequence monitorExitSequence1;
    private final ByteCodeSequence monitorExitSequence2;
    private final boolean hasBackJumps;
    private final Set<Integer> whileTrueLoops = new HashSet<Integer>();
    private final Set<Integer> whileTrueLoopContinues = new HashSet<Integer>();
    private final Set<Integer> javacWhileForLoops = new HashSet<Integer>();
    private final Set<Integer> javacLoopContinues = new HashSet<Integer>();
    private final Set<Integer> eclipseWhileForLoops = new HashSet<Integer>();
    private final Set<Integer> eclipseLoopContinues = new HashSet<Integer>();
    private final Set<Integer> doWhileLoops = new HashSet<Integer>();
    private final Set<Integer> loopBreaks = new HashSet<Integer>();

    public ASTBuilder(MethodInfo method, boolean debug) {
        this.method = method;
        this.debug = debug;
        this.byteCodes = new int[method.getCode().length];
        this.lens = new int[method.getCode().length];
        this.jumpTargetBcis = new int[method.getCode().length];
        this.jsrTargetBcis = new int[method.getCode().length];
        Arrays.fill(this.byteCodes, -1);
        Arrays.fill(this.jumpTargetBcis, -1);
        Arrays.fill(this.jsrTargetBcis, -1);
        this.expressions = new Node[method.getCode().length];
        if (debug) {
            System.out.println(method.name + SignatureHelper.toExternalSignature((String)method.signature) + ":");
        }
        boolean tmpBackJump = false;
        for (int bci = 0; bci < method.getCode().length; bci += this.lens[bci]) {
            int target;
            int defaultOffset;
            int startOffset;
            this.byteCodes[bci] = ByteCode.getByteCode(bci, method);
            this.lens[bci] = ByteCode.getSize(bci, method);
            if (ByteCode.isJump(this.byteCodes[bci])) {
                if (this.byteCodes[bci] == 168 || this.byteCodes[bci] == 201) {
                    this.jsrTargetBcis[bci] = bci + ByteCode.getJumpOffset(this.byteCodes[bci], new ByteCodeReader(method.getCode(), bci));
                } else {
                    this.jumpTargetBcis[bci] = bci + ByteCode.getJumpOffset(this.byteCodes[bci], new ByteCodeReader(method.getCode(), bci));
                    if (this.jumpTargetBcis[bci] < bci) {
                        tmpBackJump = true;
                    }
                }
            }
            if (!debug) continue;
            String parameter = "";
            if (this.byteCodes[bci] == 170) {
                startOffset = (bci + 4) / 4 * 4;
                ByteCodeReader reader = new ByteCodeReader(method.getCode(), startOffset);
                defaultOffset = reader.readInt32();
                int low = reader.readInt32();
                int high = reader.readInt32();
                StringBuilder buffer = new StringBuilder();
                buffer.append('[').append(low).append("..").append(high).append("] ");
                for (int i = 0; i < high - low + 1; ++i) {
                    target = reader.readInt32();
                    buffer.append(low + i).append(':').append(bci + target).append(' ');
                }
                buffer.append("default:").append(bci + defaultOffset);
                parameter = buffer.toString();
            } else if (this.byteCodes[bci] == 171) {
                startOffset = (bci + 4) / 4 * 4;
                ByteCodeReader reader = new ByteCodeReader(method.getCode(), startOffset);
                defaultOffset = reader.readInt32();
                int pairs = reader.readInt32();
                StringBuilder buffer = new StringBuilder();
                buffer.append('[').append(pairs).append("] ");
                for (int i = 0; i < pairs; ++i) {
                    int match = reader.readInt32();
                    target = reader.readInt32();
                    buffer.append(match).append(':').append(bci + target).append(' ');
                }
                buffer.append("default:").append(bci + defaultOffset);
                parameter = buffer.toString();
            } else {
                int startParam = bci + ByteCode.getByteCodeParameterOffset(this.byteCodes[bci]);
                int param = 0;
                for (int i = startParam; i < bci + this.lens[bci]; ++i) {
                    if (this.byteCodes[bci] == 132 && i >= startParam + 1) {
                        parameter = parameter + "#" + Integer.toString(param);
                        param = 0;
                    } else if (this.byteCodes[bci] == 388 && i == startParam + 2) {
                        parameter = parameter + "#" + Integer.toString(param);
                        param = 0;
                    } else {
                        if (this.byteCodes[bci] == 186 && i >= startParam + 2) break;
                        if (this.byteCodes[bci] == 185 && i >= startParam + 2) {
                            if (i > startParam + 2) break;
                            parameter = parameter + "#" + Integer.toString(param) + ": \"" + method.getCpEntry(param).toString() + "\"";
                            param = 0;
                        } else if (this.byteCodes[bci] == 197 && i >= startParam + 2) {
                            parameter = parameter + "#" + Integer.toString(param) + ": \"" + method.getCpEntry(param).toString() + "\"";
                            param = 0;
                        }
                    }
                    param = param << 8 | method.getCode()[i] & 0xFF;
                }
                if (startParam < bci + this.lens[bci]) {
                    if (ByteCode.hasOffsetParameter(this.byteCodes[bci])) {
                        int target2 = bci + (short)param;
                        parameter = parameter + Integer.toString(target2);
                    } else {
                        parameter = parameter + "#" + Integer.toString(param);
                        if (ByteCode.hasConstantPoolParameter(this.byteCodes[bci]) && this.byteCodes[bci] != 185 && this.byteCodes[bci] != 197) {
                            parameter = parameter + ": \"" + method.getCpEntry(param).toString() + "\"";
                        }
                    }
                }
            }
            System.out.format("%4d  %-20s  %s", bci, ByteCode.getName(this.byteCodes[bci]), parameter);
            System.out.println();
        }
        this.hasBackJumps = tmpBackJump;
        this.tsc = new TrackingStackCreator(method, debug);
        this.sideEffectBcis = new HashMap();
        this.sideEffectNodes = new HashMap();
        this.sideEffectSources = new HashMap();
        this.postIncBcis = new HashSet();
        this.createSideEffectBcis();
        this.classSequence1 = new ByteCodeSequence("getstatic", "ifnonnull", "ldc(_w)?", "invokestatic", "dup", "putstatic", "goto(_w)?", "getstatic");
        this.classSequence2 = new ByteCodeSequence("getstatic", "dup", "ifnonnull", "pop", "ldc(_w)?", "invokestatic", "dup", "putstatic", "goto(_w)?", "new", "dup_x1", "swap", "invokevirtual", "invokespecial", "athrow");
        this.monitorExitSequence1 = new ByteCodeSequence("astore.*", "aload.*", "monitorexit", "aload.*", "athrow");
        this.monitorExitSequence2 = new ByteCodeSequence("aload.*", "monitorexit", "athrow");
        for (ExceptionTableEntry entry : method.getExceptionTable()) {
            if (debug) {
                System.out.print("Exception table entry: start=" + entry.getStart() + ", end=" + entry.getEnd() + ", target=" + entry.getTarget() + ", type=" + (entry.getType() != null ? entry.getType() : "any"));
            }
            if (entry.getType() == null) {
                int start = entry.getTarget();
                if (this.monitorExitSequence1.matchEnd(this.byteCodes, this.lens, start) != start || this.monitorExitSequence2.matchEnd(this.byteCodes, this.lens, start) != start) {
                    entry.setSynchronizedFinally();
                    int end = start;
                    while (this.byteCodes[end] != 191) {
                        end += this.lens[end];
                    }
                    end += this.lens[end];
                    this.getCover(start, end);
                    if (debug) {
                        System.out.print(" monitor exit");
                    }
                } else if (debug) {
                    System.out.print(" finally");
                }
            }
            if (!debug) continue;
            System.out.println();
        }
        this.cfa = new ControlFlowAnalyzer(method, debug);
        if (this.hasBackJumps) {
            this.createLoops();
        }
    }

    private void createSideEffectBcis() {
        for (int i = 0; i < this.method.getCode().length; i += this.lens[i]) {
            int iincSlot = -1;
            boolean isStore = false;
            switch (this.byteCodes[i]) {
                case 183: {
                    ByteCodeReader reader;
                    int cpSlot;
                    String name;
                    if (this.tsc.getStackSizeAfterInstruction(i) <= 0 || !(name = this.method.getCpEntry(cpSlot = (reader = new ByteCodeReader(this.method.getCode(), i + 1)).readUint16()).getReferenceName()).equals("<init>")) break;
                    int nextTos = this.tsc.getStack(i).size() - this.tsc.getStackSizeAfterInstruction(i);
                    int[] stack = this.tsc.getStack(i).get(nextTos - 1);
                    if (this.byteCodes[stack[0]] != 187) break;
                    this.addSideEffect(i, i, nextTos);
                    break;
                }
                case 132: {
                    ByteCodeReader reader = new ByteCodeReader(this.method.getCode(), i + 1);
                    iincSlot = reader.readUint8();
                    break;
                }
                case 388: {
                    ByteCodeReader reader = new ByteCodeReader(this.method.getCode(), i + 2);
                    iincSlot = reader.readUint16();
                    break;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 179: 
                case 181: 
                case 310: 
                case 311: 
                case 312: 
                case 313: 
                case 314: {
                    isStore = true;
                }
            }
            if (iincSlot >= 0) {
                int prevBci;
                LocalVarValueOp op;
                LocalVarValueOp op2;
                int nextBci = this.getNextBci(i);
                if (!this.tsc.isJumpTarget(nextBci) && (op2 = this.getLocalVariableValueOp(nextBci)) != null && op2.getSlot() == iincSlot) {
                    this.addSideEffect(i, this.getNextBci(nextBci), 0);
                    continue;
                }
                if (i > 0 && (op = this.getLocalVariableValueOp(prevBci = this.getPrevBci(i))) != null && op.getSlot() == iincSlot) {
                    this.addSideEffect(i, i, 0);
                    this.postIncBcis.add(i);
                    continue;
                }
            }
            if (!isStore || this.tsc.getStackSizeAfterInstruction(i) <= 0) continue;
            int nextTos = this.tsc.getStack(i).size() - this.tsc.getStackSizeAfterInstruction(i);
            this.addSideEffect(i, i, nextTos);
        }
    }

    private void addSideEffect(int bci, int sideEffectBci, int slot) {
        int[] sourceBcis = this.tsc.getStack(sideEffectBci).get(slot);
        assert (sourceBcis.length >= 1);
        ArrayList<Integer> sideEffectList = this.sideEffectBcis.get(new Bcis(sourceBcis));
        if (sideEffectList == null) {
            sideEffectList = new ArrayList();
        }
        if (this.debug) {
            System.out.println("Added side effect source " + bci + " for " + Arrays.toString(sourceBcis));
        }
        sideEffectList.add(bci);
        this.sideEffectBcis.put(new Bcis(sourceBcis), sideEffectList);
        this.sideEffectSources.put(bci, sourceBcis);
    }

    private int getNextBci(int bci) {
        int nextBci = bci + 1;
        while (this.byteCodes[nextBci] == -1) {
            ++nextBci;
        }
        return nextBci;
    }

    private int getPrevBci(int bci) {
        int nextBci = bci - 1;
        while (this.byteCodes[nextBci] == -1) {
            --nextBci;
        }
        return nextBci;
    }

    private LocalVarValueOp getLocalVariableValueOp(int bci) {
        int byteCode = this.byteCodes[bci];
        LocalVarValueOp exp = null;
        ByteCodeReader reader = new ByteCodeReader(this.method.getCode(), bci + ByteCode.getByteCodeParameterOffset(bci));
        switch (byteCode) {
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                exp = new LocalVarValueOp(this.method.getVariableEntry(bci, byteCode - 26), new Type("I"), byteCode - 26);
                break;
            }
            case 21: 
            case 277: {
                int slot = byteCode == 21 ? reader.readUint8() : reader.readUint16();
                exp = new LocalVarValueOp(this.method.getVariableEntry(bci, slot), new Type("I"), slot);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                exp = new LocalVarValueOp(null, new Type("J"), byteCode - 30);
                break;
            }
            case 22: 
            case 278: {
                int slot = byteCode == 22 ? reader.readUint8() : reader.readUint16();
                exp = new LocalVarValueOp(null, new Type("J"), slot);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                exp = new LocalVarValueOp(null, new Type("F"), byteCode - 34);
                break;
            }
            case 23: 
            case 279: {
                int slot = byteCode == 23 ? reader.readUint8() : reader.readUint16();
                exp = new LocalVarValueOp(null, new Type("F"), slot);
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                exp = new LocalVarValueOp(null, new Type("D"), byteCode - 38);
                break;
            }
            case 24: 
            case 280: {
                int slot = byteCode == 24 ? reader.readUint8() : reader.readUint16();
                exp = new LocalVarValueOp(null, new Type("D"), slot);
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                exp = new LocalVarValueOp(this.method.getVariableEntry(bci, byteCode - 42), new Type("Ljava/lang/Object;"), byteCode - 42);
                break;
            }
            case 25: 
            case 281: {
                int slot = byteCode == 25 ? reader.readUint8() : reader.readUint16();
                exp = new LocalVarValueOp(this.method.getVariableEntry(bci, slot), new Type("Ljava/lang/Object;"), slot);
                break;
            }
        }
        return exp;
    }

    public void createNodes(int from, int to) {
        boolean addedNewExpression = true;
        while (addedNewExpression) {
            addedNewExpression = false;
            for (int i = from; i < to; ++i) {
                if (this.expressions[i] != null || this.byteCodes[i] == -1 || !this.checkForExpression(i)) continue;
                addedNewExpression = true;
            }
            if (addedNewExpression) continue;
            int bci = from;
            while (bci < to) {
                Node node = this.expressions[bci];
                if (node != null && node.getRoot() == node && node.getOp() instanceof ComparisonOp) {
                    ArrayList<Node> chain = new ArrayList<Node>();
                    HashSet<Integer> compNodes = new HashSet<Integer>();
                    HashSet<Integer> terminals = new HashSet<Integer>();
                    Node compNode = node;
                    ComparisonOp compOp = (ComparisonOp)node.getOp();
                    boolean failed = false;
                    int nextBci = node.getRoot().getLastBci();
                    nextBci += ByteCode.getSize(nextBci, this.method);
                    while (!failed) {
                        Node nextNode;
                        if (compNode.getRoot().getFirstBci() >= compOp.getTargets()[0] && !this.eclipseWhileForLoops.contains(compNode.getBci()) && !this.doWhileLoops.contains(compNode.getBci())) {
                            failed = true;
                        }
                        if (compNode.getRoot().getFirstBci() >= compOp.getTargets()[1] && !this.eclipseWhileForLoops.contains(compNode.getBci()) && !this.doWhileLoops.contains(compNode.getBci())) {
                            failed = true;
                        }
                        if (failed) continue;
                        chain.add(compNode);
                        compNodes.add(compNode.getRoot().getFirstBci());
                        nextBci = compNode.getRoot().getLastBci();
                        nextBci += ByteCode.getSize(nextBci, this.method);
                        while (nextBci < to && this.expressions[nextBci] == null) {
                            nextBci += ByteCode.getSize(nextBci, this.method);
                        }
                        Node node2 = nextNode = nextBci >= to ? null : this.expressions[nextBci];
                        if (nextNode != null && nextNode.getRoot().getOp() instanceof ComparisonOp) {
                            compNode = nextNode.getRoot();
                            compOp = (ComparisonOp)compNode.getOp();
                            continue;
                        }
                        failed = true;
                    }
                    boolean tmpAddedNewExpression = false;
                    if (chain.size() > 0) {
                        for (Node n : chain) {
                            for (int target : ((ComparisonOp)n.getOp()).getTargets()) {
                                if (compNodes.contains(target)) continue;
                                terminals.add(target);
                            }
                        }
                        if (terminals.size() != 2) {
                            bci += ByteCode.getSize(bci, this.method);
                            continue;
                        }
                        Integer[] terms = terminals.toArray(new Integer[terminals.size()]);
                        int bci1 = terms[0];
                        int bci2 = terms.length > 1 ? terms[1] : 0;
                        int trueTerm = -1;
                        int falseTerm = -1;
                        boolean isBooleanExpression = false;
                        if (ByteCode.getByteCode(bci1, this.method) == 3 && ByteCode.getByteCode(bci2, this.method) == 4) {
                            trueTerm = bci2;
                            falseTerm = bci1;
                        } else if (ByteCode.getByteCode(bci1, this.method) == 4 && ByteCode.getByteCode(bci2, this.method) == 3) {
                            trueTerm = bci1;
                            falseTerm = bci2;
                        }
                        if (trueTerm != -1 && falseTerm != -1 && Math.abs(bci1 - bci2) == 4) {
                            if (bci1 < bci2) {
                                if (ByteCode.getByteCode(bci1 + 1, this.method) == 167 && new ByteCodeReader(this.method.getCode(), bci1 + 2).readInt16() == 4) {
                                    isBooleanExpression = true;
                                }
                            } else if (ByteCode.getByteCode(bci2 + 1, this.method) == 167 && new ByteCodeReader(this.method.getCode(), bci2 + 2).readInt16() == 4) {
                                isBooleanExpression = true;
                            }
                        }
                        if (!isBooleanExpression) {
                            trueTerm = bci1 < bci2 ? bci2 : bci1;
                            int n = falseTerm = bci1 < bci2 ? bci1 : bci2;
                        }
                        if (this.debug) {
                            System.out.println("true terminal: " + trueTerm);
                            System.out.println("false terminal: " + falseTerm);
                        }
                        HashMap<Integer, Node> map = new HashMap<Integer, Node>();
                        for (Node n : chain) {
                            map.put(n.getRoot().getFirstBci(), n);
                        }
                        Node booleanExpression = this.createBooleanExpression((Node)chain.get(0), terminals, trueTerm, new HashSet<Integer>(), map);
                        if (this.debug) {
                            // empty if block
                        }
                        int startBci = booleanExpression.getFirstBci();
                        Node expr = this.expressions[startBci];
                        Node trueExp = this.expressions[trueTerm];
                        Node falseExp = this.expressions[falseTerm];
                        if (trueExp != null && falseExp != null) {
                            Node trueRoot = trueExp.getRoot();
                            Node falseRoot = falseExp.getRoot();
                            if (isBooleanExpression && !(expr.getOp() instanceof BooleanExpressionOp)) {
                                this.addNode(startBci, new BooleanExpressionOp(), booleanExpression, this.expressions[trueTerm], this.expressions[falseTerm]);
                                tmpAddedNewExpression = true;
                            } else if (trueRoot.isExpression() && falseRoot.isExpression()) {
                                this.addNode(startBci, new TernaryOperatorOp(trueRoot.getType().merge(falseRoot.getType())), booleanExpression, trueRoot, falseRoot);
                                tmpAddedNewExpression = true;
                            }
                        }
                        if (!tmpAddedNewExpression) {
                            Scope ifScope = new Scope(falseTerm, trueTerm);
                            int elseEnd = this.getLargestGoto(falseTerm, trueTerm);
                            if (elseEnd == trueTerm) {
                                NodeOp op = new IfOp();
                                int preEndBci = this.getPrevBci(elseEnd);
                                if (this.doWhileLoops.contains(bci)) {
                                    op = new DoWhileOp();
                                    int continueTarget = booleanExpression.getFirstBci();
                                    for (int bcIndex = ifScope.startBci; bcIndex < ifScope.endBci; bcIndex += ByteCode.getSize(bcIndex, this.method)) {
                                        if (this.byteCodes[bcIndex] != 167 && this.byteCodes[bcIndex] != 200 || this.jumpTargetBcis[bcIndex] != continueTarget) continue;
                                        this.addNode(bcIndex, new ContinueOp(continueTarget), new Node[0]);
                                    }
                                } else if (this.jumpTargetBcis[preEndBci] == startBci || this.eclipseWhileForLoops.contains(bci)) {
                                    op = new WhileOp();
                                }
                                this.addNode(startBci, op, this.negate(booleanExpression), new Node(ifScope.startBci, new ScopeOp(ifScope), new Node[0]));
                                tmpAddedNewExpression = true;
                            } else {
                                Scope elseScope = new Scope(trueTerm, elseEnd);
                                this.addNode(startBci, new IfOp(), this.negate(booleanExpression), new Node(ifScope.startBci, new ScopeOp(ifScope), new Node[0]), new Node(elseScope.startBci, new ScopeOp(elseScope), new Node[0]));
                                tmpAddedNewExpression = true;
                            }
                        }
                    }
                    addedNewExpression = addedNewExpression || tmpAddedNewExpression;
                    bci = nextBci;
                    continue;
                }
                bci += ByteCode.getSize(bci, this.method);
            }
        }
        this.fixupSynchronizedBlocks();
        this.createUnconditionalLoops();
        this.createTryCatch(from, to);
        this.assignScopes(from, to);
    }

    public Node createAST() {
        this.createNodes(0, this.method.getCode().length);
        Scope methodScope = new Scope(0, this.method.getCode().length);
        Node methodScopeNode = new Node(methodScope.startBci, new ScopeOp(methodScope), new Node[0]);
        Node methodNode = new Node(0, new MethodOp(), methodScopeNode);
        for (int bci = methodScope.startBci; bci < methodScope.endBci; ++bci) {
            Node n = this.expressions[bci];
            if (n == null || n.getRoot() != n) continue;
            methodScopeNode.addChild(n);
            n.setParent(methodScopeNode);
        }
        this.expressions[0] = methodNode;
        while (methodNode.getOp().simplify(methodNode, this.method)) {
        }
        return methodNode;
    }

    private void assignScopes(int start, int end) {
        HashSet<Object> scopeSet = new HashSet<Object>();
        HashSet<Object> toBeSearched = new HashSet<Object>();
        for (int bci = start; bci < end; ++bci) {
            Node node = this.expressions[bci];
            if (node == null || node.getRoot() != node) continue;
            if (node.getNrOfChildren() > 0) {
                toBeSearched.add(node);
            }
            if (!(node.getOp() instanceof ScopeOp)) continue;
            scopeSet.add(node);
        }
        HashSet<Object> tmpSet = toBeSearched;
        toBeSearched = new HashSet();
        while (!tmpSet.isEmpty()) {
            for (Node node : tmpSet) {
                for (int i = 0; i < node.getNrOfChildren(); ++i) {
                    Node n = node.getChild(i);
                    if (n.getNrOfChildren() > 0) {
                        toBeSearched.add(n);
                    }
                    if (!(n.getOp() instanceof ScopeOp)) continue;
                    scopeSet.add(n);
                }
            }
            tmpSet.clear();
            HashSet<Object> swap = tmpSet;
            tmpSet = toBeSearched;
            toBeSearched = swap;
        }
        ArrayList scopeNodes = new ArrayList(scopeSet);
        Collections.sort(scopeNodes, new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                Scope scope1 = ((ScopeOp)o1.getOp()).getScope();
                int length1 = scope1.endBci - scope1.startBci;
                Scope scope2 = ((ScopeOp)o2.getOp()).getScope();
                int length2 = scope2.endBci - scope2.startBci;
                int diff = length1 - length2;
                return diff == 0 ? scope1.startBci - scope2.startBci : diff;
            }
        });
        for (Node node : scopeNodes) {
            Node root = node.getRoot();
            Scope scope = ((ScopeOp)node.getOp()).getScope();
            for (int bci = scope.startBci; bci < scope.endBci; ++bci) {
                Node n = this.expressions[bci];
                if (n == null || n.getRoot() != n || n == root) continue;
                node.addChild(n);
                n.setParent(node);
            }
        }
    }

    private void fixupSynchronizedBlocks() {
        for (int bci = 0; bci < this.expressions.length; ++bci) {
            Node node = this.expressions[bci];
            if (node == null || !(node.getOp() instanceof SynchronizedOp)) continue;
            ScopeOp synchronizedScopeOp = (ScopeOp)node.getChild(1).getOp();
            Scope scope = synchronizedScopeOp.getScope();
            int slot = ((SynchronizedOp)node.getOp()).getSlot();
            for (int syncBci = scope.startBci; syncBci < scope.endBci; ++syncBci) {
                LocalVarValueOp value;
                Node n = this.expressions[syncBci];
                if (n == null || n.getParent() != null || !(n.getOp() instanceof LocalVarValueOp) || (value = (LocalVarValueOp)n.getOp()).getSlot() != slot) continue;
                this.addNode(n.getBci(), new NopOp(), n);
            }
        }
    }

    private void createTryCatch(int start, int end) {
        ExceptionTableEntry[] exceptionTable = this.method.getExceptionTable();
        if (exceptionTable.length == 0) {
            return;
        }
        if (this.debug) {
            System.out.println("Exception table:");
            for (ExceptionTableEntry entry : exceptionTable) {
                Object[] objectArray = new Object[5];
                objectArray[0] = entry.getStart();
                objectArray[1] = entry.getEnd();
                objectArray[2] = entry.getTarget();
                objectArray[3] = entry.getType() == null ? (entry.isSynchronizedFinally() ? "monitor exit" : "finally") : "catch ";
                objectArray[4] = entry.getType() == null ? "" : entry.getType();
                System.out.format("    start=%4d, end=%4d, target=%4d, %s%s", objectArray);
                System.out.println();
            }
        }
        HashMap blocks = new HashMap();
        HashSet<Integer> targets = new HashSet<Integer>();
        long lastKey = -1L;
        int lastStart = -1;
        for (ExceptionTableEntry entry : exceptionTable) {
            ArrayList<Object> list;
            Object name;
            if (entry.isSynchronizedFinally()) {
                if (!this.debug) continue;
                System.out.format("Ignoring monitor exit exception table entry (start=%4d, end=%4d, target=%4d", entry.getStart(), entry.getEnd(), entry.getTarget());
                System.out.println();
                continue;
            }
            Node targetNode = this.expressions[entry.getTarget()];
            if (targetNode != null && (targetNode = targetNode.getFirstNonNop()) != null && targetNode.getOp() instanceof ConstantOp && (name = ((ConstantOp)targetNode.getOp()).getValue()) instanceof String && name.toString().endsWith(".class")) {
                if (!this.debug) continue;
                System.out.format("Ignoring '.class' exception table entry (start=%4d, end=%4d, target=%4d, %s%s", entry.getStart(), entry.getEnd(), entry.getTarget(), entry.getType() == null ? "finally" : "catch ", entry.getType() == null ? "" : entry.getType());
                System.out.println();
                continue;
            }
            if (!targets.add(entry.getTarget())) {
                if (!this.debug) continue;
                System.out.format("Ignoring exception table entry due to duplicate target (start=%4d, end=%4d, target=%4d, %s%s", entry.getStart(), entry.getEnd(), entry.getTarget(), entry.getType() == null ? "finally" : "catch ", entry.getType() == null ? "" : entry.getType());
                System.out.println();
                continue;
            }
            long key = (long)entry.getStart() << 32 | (long)entry.getEnd();
            if (lastKey != -1L && lastStart >= 0 && key != lastKey && entry.getStart() == lastStart && entry.getType() == null) {
                boolean onlyCatch = true;
                int maxTargetEnd = Integer.MIN_VALUE;
                for (ExceptionTableEntry e : (List)blocks.get(lastKey)) {
                    maxTargetEnd = Math.max(maxTargetEnd, e.getTargetEnd());
                    if (e.getType() != null) continue;
                    onlyCatch = false;
                    break;
                }
                if (onlyCatch && maxTargetEnd >= entry.getEnd()) {
                    key = lastKey;
                }
            }
            if ((list = (ArrayList<Object>)blocks.get(key)) == null) {
                list = new ArrayList<Object>();
                blocks.put(key, list);
            }
            this.completeExceptionEntry(entry);
            list.add(entry);
            lastKey = key;
            lastStart = entry.getStart();
        }
        if (this.debug) {
            int i = 1;
            for (List list : blocks.values()) {
                System.out.println(i++ + ". Try-Catch-Finally block:");
                for (ExceptionTableEntry entry : list) {
                    System.out.format("    start=%4d, end=%4d, target=%4d, block end=%4d, %s%s %s", entry.getStart(), entry.getEnd(), entry.getTarget(), entry.getTargetEnd(), entry.getType() == null ? "finally" : "catch ", entry.getType() == null ? "" : entry.getType(), entry.getType() == null ? "" : entry.getName());
                    System.out.println();
                }
            }
        }
        this.createJsrNodes(start, end);
        ArrayList keys = new ArrayList(blocks.keySet());
        Collections.sort(keys, new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                long l1 = o1;
                int start1 = (int)(l1 >> 32);
                int end1 = (int)l1;
                int length1 = end1 - start1;
                long l2 = o2;
                int start2 = (int)(l2 >> 32);
                int end2 = (int)l2;
                int length2 = end2 - start2;
                return length1 - length2;
            }
        });
        for (Long k : keys) {
            int keyStart = (int)(k >> 32);
            int keyEnd = (int)k.longValue();
            if (keyStart < start || keyEnd > end) continue;
            int realEnd = Integer.MAX_VALUE;
            for (ExceptionTableEntry entry : (List)blocks.get(k)) {
                realEnd = Math.min(realEnd, entry.getTarget());
            }
            realEnd = Math.max(realEnd, keyEnd);
            Node tryNode = new Node(keyStart, new ScopeOp(new Scope(keyStart, realEnd)), new Node[0]);
            Node finallyNode = null;
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add(tryNode);
            ArrayList<String> exceptionNames = new ArrayList<String>();
            int finallyStart = -1;
            int finallyEnd = -1;
            ArrayList<Integer> blockEndBcis = new ArrayList<Integer>();
            blockEndBcis.add(keyEnd);
            for (ExceptionTableEntry entry : (List)blocks.get(k)) {
                if (entry.getStart() < start || entry.getEnd() > end) {
                    throw new IllegalStateException("Incorrect exception table entry dimension ([" + entry.getStart() + "," + entry.getEnd() + "] but should be [" + start + "," + end + "])");
                }
                Node n = new Node(entry.getTarget(), new ScopeOp(new Scope(entry.getTarget(), entry.getTargetEnd())), new Node[0]);
                if (entry.getType() == null) {
                    if (finallyNode != null) {
                        throw new IllegalStateException("Duplicate finally block");
                    }
                    int throwBci = entry.getTargetEnd() - 1;
                    Node lastChild = this.expressions[throwBci];
                    if (lastChild == null || !(lastChild.getOp() instanceof UnaryOp) || !"throw".equals(((UnaryOp)lastChild.getOp()).getOperator().trim())) {
                        throw new IllegalStateException("Unexpected last operator of finally block");
                    }
                    if (this.debug) {
                        System.out.println("Removing throw statement from finally block (bci=" + lastChild.getBci() + ").");
                    }
                    this.addNode(throwBci, new NopOp(), lastChild);
                    finallyNode = n;
                    int size = ByteCode.getSize(entry.getTarget(), this.method);
                    finallyStart = entry.getTarget() + size;
                    finallyEnd = entry.getTargetEnd() - (size + 1);
                    continue;
                }
                nodes.add(n);
                exceptionNames.add(entry.getType() + " " + entry.getName());
                blockEndBcis.add(entry.getTargetEnd());
            }
            if (finallyNode != null) {
                assert (finallyStart >= 0 && finallyEnd >= 0);
                int length = finallyEnd - finallyStart;
                Iterator iterator = blockEndBcis.iterator();
                while (iterator.hasNext()) {
                    int offset;
                    int bci = (Integer)iterator.next();
                    if (bci >= this.method.getCode().length) continue;
                    if (ByteCode.getByteCode(bci, this.method) == 167) {
                        offset = ByteCode.getByteCodeParameterOffset(167);
                        bci += (short)((this.method.getCode()[bci + offset] & 0xFF) << 8) | this.method.getCode()[bci + offset + 1] & 0xFF;
                    } else if (ByteCode.getByteCode(bci, this.method) == 200) {
                        offset = ByteCode.getByteCodeParameterOffset(200);
                        bci += (this.method.getCode()[bci + offset] & 0xFF) << 24 | (this.method.getCode()[bci + offset + 1] & 0xFF) << 16 | (this.method.getCode()[bci + offset + 2] & 0xFF) << 8 | (this.method.getCode()[bci + offset + 3] & 0xFF) << 0;
                    }
                    int startBci = bci;
                    boolean equal = true;
                    for (int finallyBci = finallyStart; finallyBci < finallyEnd; ++finallyBci) {
                        if (bci >= this.method.getCode().length || this.method.getCode()[bci] != this.method.getCode()[finallyBci]) {
                            equal = false;
                            break;
                        }
                        ++bci;
                    }
                    if (!equal) continue;
                    if (this.debug) {
                        System.out.println("Removing duplicate finally nodes at bcis [" + startBci + ".." + (startBci + length) + "]");
                    }
                    this.getCover(startBci, startBci + length);
                }
                nodes.add(finallyNode);
            }
            Node firstChild = null;
            if (this.expressions[keyStart] != null && this.expressions[keyStart].getParent() == null) {
                tryNode.addChild(this.expressions[keyStart]);
                firstChild = this.expressions[keyStart];
            }
            this.addNode(keyStart, new TryCatchFinallyOp(finallyNode != null, exceptionNames.toArray(new String[exceptionNames.size()])), nodes.toArray(new Node[nodes.size()]));
            if (firstChild == null) continue;
            firstChild.setParent(this.expressions[keyStart]);
        }
    }

    private void createJsrNodes(int start, int end) {
        HashMap<Integer, ArrayList<Integer>> subroutineStarts = new HashMap<Integer, ArrayList<Integer>>();
        for (int bci = start; bci < end; bci += ByteCode.getSize(bci, this.method)) {
            int target = bci;
            int byteCode = ByteCode.getByteCode(bci, this.method);
            int offset = ByteCode.getByteCodeParameterOffset(byteCode);
            if (byteCode == 168) {
                target += (short)((this.method.getCode()[bci + offset] & 0xFF) << 8) | this.method.getCode()[bci + offset + 1] & 0xFF;
            } else if (byteCode == 201) {
                target += (this.method.getCode()[bci + offset + 0] & 0xFF) << 24 | (this.method.getCode()[bci + offset + 1] & 0xFF) << 16 | (this.method.getCode()[bci + offset + 2] & 0xFF) << 8 | (this.method.getCode()[bci + offset + 3] & 0xFF) << 0;
            }
            if (target == bci) continue;
            ArrayList<Integer> jsrInstructions = (ArrayList<Integer>)subroutineStarts.get(target);
            if (jsrInstructions == null) {
                jsrInstructions = new ArrayList<Integer>();
                subroutineStarts.put(target, jsrInstructions);
            }
            jsrInstructions.add(bci);
        }
        for (Map.Entry subroutineEntry : subroutineStarts.entrySet()) {
            HashSet<Integer> instructions = new HashSet<Integer>();
            HashSet current = new HashSet();
            current.add(subroutineEntry.getKey());
            HashSet<Integer> next = new HashSet<Integer>();
            int maxBci = Integer.MIN_VALUE;
            int minBci = Integer.MAX_VALUE;
            while (!current.isEmpty()) {
                Iterator iterator = current.iterator();
                while (iterator.hasNext()) {
                    int[] followingBcis;
                    int bci = (Integer)iterator.next();
                    instructions.add(bci);
                    maxBci = Math.max(maxBci, bci);
                    minBci = Math.min(minBci, bci);
                    int byteCode = ByteCode.getByteCode(bci, this.method);
                    if (byteCode == 168 || byteCode == 201) {
                        throw new IllegalStateException("Nested jsr subroutines");
                    }
                    if (byteCode == 169 || byteCode == 425) continue;
                    for (int nextBci : followingBcis = this.cfa.getFollowingBcis(bci)) {
                        if (instructions.contains(nextBci)) continue;
                        next.add(nextBci);
                    }
                }
                current.clear();
                HashSet<Integer> tmp = next;
                next = current;
                current = tmp;
            }
            ArrayList<ExceptionTableEntry> finallyBlocks = new ArrayList<ExceptionTableEntry>();
            ArrayList<Integer> finallyJsrInstructions = new ArrayList<Integer>();
            for (ExceptionTableEntry ete : this.method.getExceptionTable()) {
                if (ete.isSynchronizedFinally() || ete.getType() != null) continue;
                Iterator iterator = ((List)subroutineEntry.getValue()).iterator();
                while (iterator.hasNext()) {
                    int jsrBci = (Integer)iterator.next();
                    if (ete.getTarget() > jsrBci || ete.getTargetEnd() <= jsrBci) continue;
                    finallyBlocks.add(ete);
                    finallyJsrInstructions.add(jsrBci);
                }
            }
            if (finallyBlocks.isEmpty()) {
                throw new IllegalStateException("Finally block for subroutine not found");
            }
            int index = 0;
            int size = ((ExceptionTableEntry)finallyBlocks.get(0)).getTargetEnd() - ((ExceptionTableEntry)finallyBlocks.get(0)).getTarget();
            for (int i = 1; i < finallyBlocks.size(); ++i) {
                int newSize = ((ExceptionTableEntry)finallyBlocks.get(i)).getTargetEnd() - ((ExceptionTableEntry)finallyBlocks.get(i)).getTarget();
                if (newSize >= size) continue;
                index = i;
            }
            assert (this.expressions[(Integer)finallyJsrInstructions.get(index)] == null);
            this.addNode((Integer)finallyJsrInstructions.get(index), new JsrOp(), new Node(minBci, new ScopeOp(new Scope(minBci, maxBci)), new Node[0]));
        }
    }

    private void completeExceptionEntry(ExceptionTableEntry entry) {
        int bci;
        int nextBci;
        LocalVariableTableEntry exception;
        if (entry.getType() == null) {
            int bci2;
            int byteCode = ByteCode.getByteCode(entry.getTarget(), this.method);
            int localIndex = -1;
            int loadCode = -1;
            switch (byteCode) {
                case 58: {
                    localIndex = this.method.getCode()[entry.getTarget() + ByteCode.getByteCodeParameterOffset(byteCode)] & 0xFF;
                    loadCode = 25;
                    break;
                }
                case 75: {
                    localIndex = 0;
                    loadCode = 42;
                    break;
                }
                case 76: {
                    localIndex = 1;
                    loadCode = 43;
                    break;
                }
                case 77: {
                    localIndex = 2;
                    loadCode = 44;
                    break;
                }
                case 78: {
                    localIndex = 3;
                    loadCode = 45;
                    break;
                }
                case 314: {
                    int offset = ByteCode.getByteCodeParameterOffset(byteCode);
                    localIndex = (this.method.getCode()[entry.getTarget() + offset] & 0xFF) << 8 | this.method.getCode()[entry.getTarget() + offset + 1] & 0xFF;
                    loadCode = 281;
                    break;
                }
                default: {
                    throw new IllegalStateException("Finally block not storing exception");
                }
            }
            int previousBci = entry.getTarget();
            for (bci2 = previousBci + ByteCode.getSize(previousBci, this.method); bci2 < this.method.getCode().length; bci2 += ByteCode.getSize(bci2, this.method)) {
                if (ByteCode.getByteCode(bci2, this.method) == 191 && previousBci > entry.getTarget() && ByteCode.getByteCode(previousBci, this.method) == loadCode) {
                    int loadSize = ByteCode.getSize(previousBci, this.method);
                    int offset = ByteCode.getByteCodeParameterOffset(loadCode);
                    boolean found = false;
                    if (loadSize == 1) {
                        found = true;
                    } else if (loadSize == 2) {
                        found = (this.method.getCode()[previousBci + offset] & 0xFF) == localIndex;
                    } else if (loadSize == 4) {
                        boolean bl = found = ((this.method.getCode()[previousBci + offset] & 0xFF) << 8 | this.method.getCode()[previousBci + offset + 1] & 0xFF) == localIndex;
                    }
                    if (found) {
                        entry.setTargetEnd(bci2 + ByteCode.getSize(bci2, this.method));
                        return;
                    }
                }
                previousBci = bci2;
            }
            entry.setTargetEnd(bci2);
            return;
        }
        int byteCode = ByteCode.getByteCode(entry.getTarget(), this.method);
        int localIndex = -1;
        switch (byteCode) {
            case 58: {
                localIndex = this.method.getCode()[entry.getTarget() + ByteCode.getByteCodeParameterOffset(byteCode)] & 0xFF;
                break;
            }
            case 75: {
                localIndex = 0;
                break;
            }
            case 76: {
                localIndex = 1;
                break;
            }
            case 77: {
                localIndex = 2;
                break;
            }
            case 78: {
                localIndex = 3;
                break;
            }
            case 314: {
                int offset = ByteCode.getByteCodeParameterOffset(byteCode);
                localIndex = (this.method.getCode()[entry.getTarget() + offset] & 0xFF) << 8 | this.method.getCode()[entry.getTarget() + offset + 1] & 0xFF;
                break;
            }
            case 87: {
                break;
            }
            default: {
                throw new IllegalStateException("Catch block neither storing nor popping exception");
            }
        }
        if (localIndex >= 0 && (exception = this.method.getVariableEntry(nextBci = entry.getTarget() + ByteCode.getSize(entry.getTarget(), this.method), localIndex)) != null) {
            if (exception.startPc != nextBci || !("L" + entry.getType() + ";").equals(exception.type)) {
                throw new IllegalStateException("Catch block variable not found");
            }
            entry.setTargetEnd(exception.startPc + exception.length);
            entry.setName(exception.name);
            return;
        }
        int jumpTarget = entry.getEnd();
        switch (ByteCode.getByteCode(entry.getEnd(), this.method)) {
            case 167: {
                int offset = ByteCode.getByteCodeParameterOffset(167);
                jumpTarget += (short)((this.method.getCode()[entry.getEnd() + offset] & 0xFF) << 8) | this.method.getCode()[entry.getEnd() + offset + 1] & 0xFF;
                break;
            }
            case 200: {
                int offset = ByteCode.getByteCodeParameterOffset(200);
                jumpTarget += (this.method.getCode()[entry.getEnd() + offset] & 0xFF) << 24 | (this.method.getCode()[entry.getEnd() + offset + 1] & 0xFF) << 16 | (this.method.getCode()[entry.getEnd() + offset + 2] & 0xFF) << 8 | (this.method.getCode()[entry.getEnd() + offset + 3] & 0xFF) << 0;
                break;
            }
            default: {
                jumpTarget = -1;
            }
        }
        if (jumpTarget >= 0 && jumpTarget >= entry.getTarget()) {
            ArrayList<ExceptionTableEntry> otherEntries = new ArrayList<ExceptionTableEntry>();
            for (ExceptionTableEntry e : this.method.getExceptionTable()) {
                if (e == entry || e.getStart() != entry.getStart() || e.getEnd() >= jumpTarget || e.isSynchronizedFinally()) continue;
                otherEntries.add(e);
            }
            Collections.sort(otherEntries, new Comparator<ExceptionTableEntry>(){

                @Override
                public int compare(ExceptionTableEntry o1, ExceptionTableEntry o2) {
                    return o1.getTarget() - o2.getTarget();
                }
            });
            for (ExceptionTableEntry e : otherEntries) {
                if (e.getTarget() <= entry.getTarget()) continue;
                entry.setTargetEnd(e.getTarget());
                entry.setName("exceptionVariableNameUnknown");
                return;
            }
            entry.setTargetEnd(jumpTarget);
            entry.setName("exceptionVariableNameUnknown");
            return;
        }
        ArrayList<ExceptionTableEntry> otherEntries = new ArrayList<ExceptionTableEntry>();
        for (ExceptionTableEntry e : this.method.getExceptionTable()) {
            if (e == entry || e.getStart() != entry.getStart() || e.isSynchronizedFinally()) continue;
            otherEntries.add(e);
        }
        Collections.sort(otherEntries, new Comparator<ExceptionTableEntry>(){

            @Override
            public int compare(ExceptionTableEntry o1, ExceptionTableEntry o2) {
                return o1.getTarget() - o2.getTarget();
            }
        });
        for (ExceptionTableEntry e : otherEntries) {
            if (e.getTarget() <= entry.getTarget()) continue;
            entry.setTargetEnd(e.getTarget());
            entry.setName("exceptionVariableNameUnknown");
            return;
        }
        jumpTarget = Integer.MAX_VALUE;
        if (otherEntries.size() > 0) {
            for (ExceptionTableEntry e : otherEntries) {
                int bci3 = e.getTargetEnd() - 1;
                while (this.byteCodes[bci3] == -1) {
                    --bci3;
                }
                int target = bci3;
                int offset = ByteCode.getByteCodeParameterOffset(this.byteCodes[bci3]);
                if (this.byteCodes[bci3] == 167) {
                    target += (short)((this.method.getCode()[bci3 + offset] & 0xFF) << 8) | this.method.getCode()[bci3 + offset + 1] & 0xFF;
                } else if (this.byteCodes[bci3] == 200) {
                    target += (this.method.getCode()[bci3 + offset] & 0xFF) << 24 | (this.method.getCode()[bci3 + offset + 1] & 0xFF) << 16 | (this.method.getCode()[bci3 + offset + 2] & 0xFF) << 8 | (this.method.getCode()[bci3 + offset + 3] & 0xFF) << 0;
                }
                if (target == bci3 || target <= entry.getTarget()) continue;
                jumpTarget = Math.min(jumpTarget, target);
            }
        }
        for (bci = entry.getTarget(); bci < this.method.getCode().length && bci < jumpTarget; bci += ByteCode.getSize(bci, this.method)) {
            boolean abort;
            switch (ByteCode.getByteCode(bci, this.method)) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    abort = true;
                    break;
                }
                default: {
                    abort = false;
                }
            }
            if (abort) break;
        }
        entry.setTargetEnd(bci + (bci < this.method.getCode().length ? ByteCode.getSize(bci, this.method) : 0));
        entry.setName("exceptionVariableNameUnknown");
    }

    private int getLargestGoto(int start, int end) {
        int largestGoto = end;
        for (int bci = start; bci < end; bci += ByteCode.getSize(bci, this.method)) {
            ByteCodeReader reader;
            if (this.whileTrueLoopContinues.contains(bci) || this.javacLoopContinues.contains(bci) || this.eclipseLoopContinues.contains(bci) || this.loopBreaks.contains(bci)) continue;
            int byteCode = ByteCode.getByteCode(bci, this.method);
            if (byteCode == 167) {
                reader = new ByteCodeReader(this.method.getCode(), bci + 1);
                largestGoto = Math.max(largestGoto, reader.readInt16() + bci);
                continue;
            }
            if (byteCode != 200) continue;
            reader = new ByteCodeReader(this.method.getCode(), bci + 1);
            largestGoto = Math.max(largestGoto, reader.readInt32() + bci);
        }
        return largestGoto;
    }

    private Node createBooleanExpression(Node node, Set<Integer> terminals, int trueTerminal, Set<Integer> alreadyPresent, Map<Integer, Node> map) {
        int[] targets = ((ComparisonOp)node.getOp()).getTargets();
        int trueBci = targets[1];
        int falseBci = targets[0];
        if (terminals.contains(trueBci) && terminals.contains(falseBci)) {
            if (trueBci == trueTerminal) {
                return node;
            }
            return this.negate(node);
        }
        if (terminals.contains(trueBci) || terminals.contains(falseBci)) {
            if (trueBci == trueTerminal) {
                if (!alreadyPresent.contains(falseBci)) {
                    alreadyPresent.add(falseBci);
                    Node otherNode = this.createBooleanExpression(map.get(falseBci), terminals, trueTerminal, alreadyPresent, map);
                    return this.createOr(node, otherNode);
                }
                return node;
            }
            if (falseBci == trueTerminal) {
                if (!alreadyPresent.contains(trueBci)) {
                    alreadyPresent.add(trueBci);
                    Node otherNode = this.createBooleanExpression(map.get(trueBci), terminals, trueTerminal, alreadyPresent, map);
                    return this.createOr(this.negate(node), otherNode);
                }
                return this.negate(node);
            }
            if (terminals.contains(trueBci)) {
                if (!alreadyPresent.contains(falseBci)) {
                    alreadyPresent.add(falseBci);
                    Node otherNode = this.createBooleanExpression(map.get(falseBci), terminals, trueTerminal, alreadyPresent, map);
                    return this.createAnd(this.negate(node), otherNode);
                }
                return this.negate(node);
            }
            if (!alreadyPresent.contains(trueBci)) {
                alreadyPresent.add(trueBci);
                Node otherNode = this.createBooleanExpression(map.get(trueBci), terminals, trueTerminal, alreadyPresent, map);
                return this.createAnd(node, otherNode);
            }
            return node;
        }
        if (trueBci < falseBci) {
            alreadyPresent.add(trueBci);
            if (!alreadyPresent.contains(falseBci)) {
                alreadyPresent.add(falseBci);
                Node node1 = this.createBooleanExpression(map.get(trueBci), terminals, trueTerminal, alreadyPresent, map);
                Node node2 = this.createBooleanExpression(map.get(falseBci), terminals, trueTerminal, alreadyPresent, map);
                return this.createOr(this.createAnd(node, node1), node2);
            }
            Node node1 = this.createBooleanExpression(map.get(trueBci), terminals, trueTerminal, alreadyPresent, map);
            return this.createAnd(node, node1);
        }
        alreadyPresent.add(falseBci);
        if (!alreadyPresent.contains(trueBci)) {
            alreadyPresent.add(trueBci);
            Node node1 = this.createBooleanExpression(map.get(falseBci), terminals, trueTerminal, alreadyPresent, map);
            Node node2 = this.createBooleanExpression(map.get(trueBci), terminals, trueTerminal, alreadyPresent, map);
            return this.createOr(this.createAnd(this.negate(node), node1), node2);
        }
        Node node1 = this.createBooleanExpression(map.get(falseBci), terminals, trueTerminal, alreadyPresent, map);
        return this.createAnd(this.negate(node), node1);
    }

    private Node createAnd(Node node1, Node node2) {
        return new Node(node1.getBci(), new BinaryOp("&&", new Type("V")), node1, node2);
    }

    private Node createOr(Node node1, Node node2) {
        return new Node(node1.getBci(), new BinaryOp("||", new Type("V")), node1, node2);
    }

    private Node negate(Node node) {
        if (node.getOp() instanceof ComparisonOp) {
            ((ComparisonOp)node.getOp()).negate();
            return node;
        }
        return new Node(node.getBci(), new UnaryOp("!", new Type("V")), node);
    }

    private Node getFullyDefined(int bci, int slot) {
        int[] stack = this.tsc.getStack(bci).get(slot);
        if (stack.length >= 1) {
            if (stack[0] == -1) {
                return null;
            }
            ArrayList<Integer> sources = this.sideEffectBcis.get(new Bcis(stack));
            if (sources != null && bci > sources.get(0)) {
                return null;
            }
            if (this.sideEffectNodes.containsKey(new Bcis(stack))) {
                if (this.debug) {
                    System.out.println("Took side effect node for " + Arrays.toString(stack));
                }
                return this.sideEffectNodes.get(new Bcis(stack));
            }
            Node first = this.expressions[stack[0]];
            if (first != null) {
                Node root = first.getRoot();
                for (int otherBci : stack) {
                    Node other = this.expressions[otherBci];
                    if (other != null && other.getRoot() == root) continue;
                    return null;
                }
            } else {
                return null;
            }
            Node[] nodes = new Node[stack.length];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = this.expressions[stack[i]];
            }
            return Node.getFirstCommonAncestor(nodes);
        }
        return null;
    }

    private boolean checkForExpression(int bci) {
        int byteCode = this.byteCodes[bci];
        int pos = bci + ByteCode.getByteCodeParameterOffset(byteCode);
        ByteCodeReader reader = new ByteCodeReader(this.method.getCode(), pos);
        if (this.createForByteCodeSequences(bci)) {
            return true;
        }
        if (this.createConstantExpression(bci, byteCode, reader)) {
            return true;
        }
        if (this.createContinueBreak(bci)) {
            return true;
        }
        ArrayList<Integer> usedArgs = this.tsc.getUsedArgs(bci);
        Node[] parameters = new Node[usedArgs.size()];
        boolean isFullDefined = true;
        for (int i = 0; i < usedArgs.size(); ++i) {
            Node node = this.getFullyDefined(bci, usedArgs.get(i));
            if (node == null) {
                isFullDefined = false;
                break;
            }
            parameters[i] = node;
        }
        if (isFullDefined) {
            if (usedArgs.size() == 1) {
                Node param = parameters[0];
                if (this.createUnaryExpression(bci, byteCode, param, reader)) {
                    return true;
                }
                if (this.createLocalVariableAssignments(bci, byteCode, param, reader)) {
                    return true;
                }
                if (this.createStaticFieldAssignments(bci, byteCode, param, reader)) {
                    return true;
                }
                if (this.createSwitchExpression(bci, byteCode, param, reader)) {
                    return true;
                }
                if (this.createSynchronizedBlock(bci, byteCode, param, reader)) {
                    return true;
                }
            } else if (usedArgs.size() == 2) {
                Node param1 = parameters[0];
                Node param2 = parameters[1];
                if (this.createBinaryExpression(bci, byteCode, param1, param2, reader)) {
                    return true;
                }
                if (this.createInstanceFieldAssignments(bci, byteCode, param1, param2, reader)) {
                    return true;
                }
            } else if (usedArgs.size() == 0) {
                if (this.createNewStatement(bci, byteCode, reader)) {
                    return true;
                }
                if (this.createReturnStatement(bci, byteCode, reader)) {
                    return true;
                }
                if (this.createIinc(bci, byteCode, reader)) {
                    return true;
                }
            }
            if (this.createFieldExpression(bci, byteCode, parameters, reader)) {
                return true;
            }
            if (this.createArrayExpression(bci, byteCode, parameters, reader)) {
                return true;
            }
            if (this.createCallExpression(bci, byteCode, parameters, reader)) {
                return true;
            }
            if (this.createCompareToExpressions(bci, byteCode, parameters, reader)) {
                return true;
            }
            if (this.createComparisonNode(bci, byteCode, parameters, reader)) {
                return true;
            }
        } else if (this.debug) {
            System.out.println("Parameters at bci " + bci + " not fully defined");
            return false;
        }
        if (this.debug) {
            System.out.println("Not defined at bci " + bci);
        }
        return false;
    }

    private boolean createConstantExpression(int bci, int byteCode, ByteCodeReader reader) {
        NodeOp exp = null;
        switch (byteCode) {
            case 1: {
                exp = new ConstantOp(new Type("java/lang/Object"), null);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                exp = new ConstantOp(new Type("I"), byteCode - 3);
                break;
            }
            case 16: {
                exp = new ConstantOp(new Type("I"), reader.readInt8());
                break;
            }
            case 17: {
                exp = new ConstantOp(new Type("I"), reader.readInt16());
                break;
            }
            case 9: 
            case 10: {
                exp = new ConstantOp(new Type("J"), byteCode - 9);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                exp = new ConstantOp(new Type("F"), Float.valueOf(byteCode - 11));
                break;
            }
            case 14: 
            case 15: {
                exp = new ConstantOp(new Type("D"), byteCode - 14);
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                int cpIndex = byteCode == 18 ? reader.readUint8() : reader.readUint16();
                ConstantPoolEntry entry = this.method.getCpEntry(cpIndex);
                int type = entry.getType();
                switch (type) {
                    case 3: {
                        exp = new ConstantOp(new Type("I"), entry.getNumericValue());
                        break;
                    }
                    case 4: {
                        exp = new ConstantOp(new Type("F"), entry.getNumericValue());
                        break;
                    }
                    case 5: {
                        exp = new ConstantOp(new Type("J"), entry.getNumericValue());
                        break;
                    }
                    case 6: {
                        exp = new ConstantOp(new Type("D"), entry.getNumericValue());
                        break;
                    }
                    case 8: {
                        exp = new ConstantOp(new Type("Ljava/lang/String;"), entry.getString());
                        break;
                    }
                    case 7: {
                        exp = new ConstantOp(new Type("Ljava/lang/Class;"), entry.getExternalClass() + ".class");
                    }
                }
                break;
            }
        }
        if (exp == null) {
            exp = this.getLocalVariableValueOp(bci);
        }
        return this.addNode(bci, exp, new Node[0]);
    }

    private boolean createUnaryExpression(int bci, int byteCode, Node param, ByteCodeReader reader) {
        NodeOp op = null;
        switch (byteCode) {
            case 116: {
                op = new UnaryOp("-", new Type("I"));
                break;
            }
            case 117: {
                op = new UnaryOp("-", new Type("J"));
                break;
            }
            case 118: {
                op = new UnaryOp("-", new Type("F"));
                break;
            }
            case 119: {
                op = new UnaryOp("-", new Type("D"));
                break;
            }
            case 136: 
            case 139: 
            case 142: {
                op = new CastOp(new Type("I"));
                break;
            }
            case 133: 
            case 140: 
            case 143: {
                op = new CastOp(new Type("J"));
                break;
            }
            case 134: 
            case 137: 
            case 144: {
                op = new CastOp(new Type("F"));
                break;
            }
            case 135: 
            case 138: 
            case 141: {
                op = new CastOp(new Type("D"));
                break;
            }
            case 145: {
                op = new CastOp(new Type("B"));
                break;
            }
            case 146: {
                op = new CastOp(new Type("C"));
                break;
            }
            case 147: {
                op = new CastOp(new Type("S"));
                break;
            }
            case 192: {
                int cpSlot = reader.readUint16();
                op = new CastOp(new Type(this.method.getCpEntry(cpSlot).asFieldDescriptor()));
                break;
            }
            case 191: {
                op = new UnaryOp("throw ", new Type("V"));
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                op = new UnaryOp("return ", new Type("V"));
            }
        }
        if (op != null) {
            return this.addNode(bci, op, param);
        }
        return false;
    }

    private boolean createBinaryExpression(int bci, int byteCode, Node param1, Node param2, ByteCodeReader reader) {
        BinaryOp op = null;
        switch (byteCode) {
            case 96: {
                op = new BinaryOp("+", new Type("I"));
                break;
            }
            case 97: {
                op = new BinaryOp("+", new Type("J"));
                break;
            }
            case 98: {
                op = new BinaryOp("+", new Type("F"));
                break;
            }
            case 99: {
                op = new BinaryOp("+", new Type("D"));
                break;
            }
            case 100: {
                op = new BinaryOp("-", new Type("I"));
                break;
            }
            case 101: {
                op = new BinaryOp("-", new Type("J"));
                break;
            }
            case 102: {
                op = new BinaryOp("-", new Type("F"));
                break;
            }
            case 103: {
                op = new BinaryOp("-", new Type("D"));
                break;
            }
            case 104: {
                op = new BinaryOp("*", new Type("I"));
                break;
            }
            case 105: {
                op = new BinaryOp("*", new Type("J"));
                break;
            }
            case 106: {
                op = new BinaryOp("*", new Type("F"));
                break;
            }
            case 107: {
                op = new BinaryOp("*", new Type("D"));
                break;
            }
            case 108: {
                op = new BinaryOp("/", new Type("I"));
                break;
            }
            case 109: {
                op = new BinaryOp("/", new Type("J"));
                break;
            }
            case 110: {
                op = new BinaryOp("/", new Type("F"));
                break;
            }
            case 111: {
                op = new BinaryOp("*", new Type("D"));
                break;
            }
            case 112: {
                op = new BinaryOp("%", new Type("I"));
                break;
            }
            case 113: {
                op = new BinaryOp("%", new Type("J"));
                break;
            }
            case 114: {
                op = new BinaryOp("%", new Type("F"));
                break;
            }
            case 115: {
                op = new BinaryOp("%", new Type("D"));
                break;
            }
            case 126: {
                op = new BinaryOp("&", new Type("I"));
                break;
            }
            case 127: {
                op = new BinaryOp("&", new Type("J"));
                break;
            }
            case 128: {
                op = new BinaryOp("|", new Type("I"));
                break;
            }
            case 129: {
                op = new BinaryOp("|", new Type("J"));
                break;
            }
            case 130: {
                op = new BinaryOp("^", new Type("I"));
                break;
            }
            case 131: {
                op = new BinaryOp("^", new Type("J"));
                break;
            }
            case 120: {
                op = new BinaryOp("<<", new Type("I"));
                break;
            }
            case 121: {
                op = new BinaryOp("<<", new Type("J"));
                break;
            }
            case 122: {
                op = new BinaryOp(">>", new Type("I"));
                break;
            }
            case 123: {
                op = new BinaryOp(">>", new Type("J"));
                break;
            }
            case 124: {
                op = new BinaryOp(">>>", new Type("I"));
                break;
            }
            case 125: {
                op = new BinaryOp(">>>", new Type("J"));
            }
        }
        if (op != null) {
            return this.addNode(bci, op, param1, param2);
        }
        return false;
    }

    private boolean createArrayExpression(int bci, int byteCode, Node[] parameters, ByteCodeReader reader) {
        Type type = null;
        switch (byteCode) {
            case 190: {
                return this.addNode(bci, new LengthOp(), parameters[0]);
            }
            case 46: {
                type = new Type("I");
                break;
            }
            case 47: {
                type = new Type("J");
                break;
            }
            case 48: {
                type = new Type("F");
                break;
            }
            case 49: {
                type = new Type("D");
                break;
            }
            case 53: {
                type = new Type("S");
                break;
            }
            case 52: {
                type = new Type("C");
                break;
            }
            case 51: {
                type = new Type("B");
                break;
            }
            case 50: {
                type = new Type("Ljava/lang/Object;");
            }
        }
        if (type != null) {
            Node array = parameters[0];
            Node index = parameters[1];
            if (array != null && index != null) {
                return this.addNode(bci, new ArrayValueOp(type), array, index);
            }
        }
        switch (byteCode) {
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                if (parameters[2].getType().isPrimitive()) {
                    NodeOp leftOp;
                    Node opNode;
                    Node value = parameters[2];
                    Node node = opNode = value.getOp() instanceof CastOp ? value.getChild(0) : value;
                    if (opNode.getOp() instanceof BinaryOp && (leftOp = opNode.getChild(0).getOp()) instanceof ArrayValueOp) {
                        String operator = ((BinaryOp)opNode.getOp()).getOperator();
                        Node rightObj = opNode.getChild(1);
                        Node leftObj = opNode.getChild(0).getChild(0);
                        Node leftIndex = opNode.getChild(0).getChild(1);
                        if (parameters[0] == leftObj && parameters[1] == leftIndex) {
                            int sign = this.getIncOrDec(operator, rightObj);
                            if (sign != 0) {
                                int prevCode = this.byteCodes[this.getPrevBci(bci)];
                                if (prevCode != 91 && prevCode != 94) {
                                    return this.addNode(bci, sign == -1 ? new PostdecNodeOp() : new PostincNodeOp(), new Node(bci, new ArrayValueOp(value.getType()), parameters[0], parameters[1], value));
                                }
                                return this.addNode(bci, sign == -1 ? new PredecNodeOp() : new PreincNodeOp(), new Node(bci, new ArrayValueOp(value.getType()), parameters[0], parameters[1], value));
                            }
                            return this.addNode(bci, new ArrayOperationAndAssignOp(value.getType(), operator), parameters[0], parameters[1], rightObj, value);
                        }
                    }
                }
                if (this.sideEffectSources.containsKey(bci) && (parameters[0].getOp() instanceof ArrayInitializationOp || parameters[0].getOp() instanceof NewArrayOp)) {
                    return this.addNode(bci, new ArrayInitializationOp(parameters[0].getType()), parameters[0], parameters[1], parameters[2]);
                }
                return this.addNode(bci, new ArrayAssignOp(), parameters[0], parameters[1], parameters[2]);
            }
            case 188: 
            case 189: {
                ConstantPoolEntry entry;
                type = null;
                type = byteCode == 188 ? new Type(ByteCode.getTypeForNewArray(reader.readUint8())) : ((entry = this.method.getCpEntry(reader.readUint16())).getString().startsWith("[") ? new Type("[" + entry.getString()) : new Type("[L" + entry.getString() + ";"));
                return this.addNode(bci, new NewArrayOp(type), parameters[0]);
            }
        }
        return false;
    }

    private boolean createFieldExpression(int bci, int byteCode, Node[] parameters, ByteCodeReader reader) {
        if (byteCode == 180) {
            int cpSlot = reader.readUint16();
            String name = this.method.getCpEntry(cpSlot).getReferenceName();
            Type type = new Type(this.method.getCpEntry(cpSlot).getReferenceType());
            return this.addNode(bci, new InstanceFieldValueOp(type, name), parameters[0]);
        }
        if (byteCode == 178) {
            int cpSlot = reader.readUint16();
            String name = this.method.getCpEntry(cpSlot).getReferenceName();
            Type clazz = new Type("L" + this.method.getCpEntry(cpSlot).getReferenceClass() + ";");
            Type type = new Type(this.method.getCpEntry(cpSlot).getReferenceType());
            return this.addNode(bci, new StaticFieldValueOp(clazz, name, type), new Node[0]);
        }
        return false;
    }

    private boolean createCallExpression(int bci, int byteCode, Node[] parameters, ByteCodeReader reader) {
        switch (byteCode) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                break;
            }
            default: {
                return false;
            }
        }
        int cpSlot = reader.readUint16();
        String name = this.method.getCpEntry(cpSlot).getReferenceName();
        Type type = new Type("L" + this.method.getCpEntry(cpSlot).getReferenceClass() + ";");
        String signature = this.method.getCpEntry(cpSlot).getReferenceType();
        NodeOp exp = null;
        if (byteCode == 183) {
            if ("<init>".equals(name) && bci > 0) {
                if (parameters[0].getOp() instanceof NewOp) {
                    return this.addNode(bci, new NewCallOp(signature), parameters);
                }
                exp = type.toString().equals(this.method.getClassName()) ? new VirtualCallOp("this", signature) : new VirtualCallOp("super", signature);
            }
        } else if (byteCode == 184) {
            exp = new StaticCallOp(type, name, signature);
        }
        if (exp == null) {
            exp = new VirtualCallOp(name, signature);
        }
        return this.addNode(bci, exp, parameters);
    }

    private boolean createIinc(int bci, int byteCode, ByteCodeReader reader) {
        int slot = -1;
        int iincConst = Integer.MAX_VALUE;
        switch (byteCode) {
            case 132: {
                slot = reader.readUint8();
                iincConst = reader.readInt8();
                break;
            }
            case 388: {
                slot = reader.readUint16();
                iincConst = reader.readInt16();
            }
        }
        if (slot >= 0) {
            boolean isSideeffect = this.sideEffectSources.containsKey(bci);
            Node prevNode = bci > 0 ? this.expressions[this.getPrevBci(bci)] : null;
            Node nextNode = this.expressions[this.getNextBci(bci)];
            if (iincConst == 1) {
                if (this.postIncBcis.contains(bci)) {
                    if (prevNode != null) {
                        return this.addNode(bci, new PostincNodeOp(), new Node(bci, new LocalVarValueOp(null, new Type("I"), slot), prevNode));
                    }
                    return false;
                }
                if (isSideeffect) {
                    if (nextNode != null) {
                        return this.addNode(bci, new PreincNodeOp(), new Node(bci, new LocalVarValueOp(null, new Type("I"), slot), new Node[0]), nextNode);
                    }
                    return false;
                }
                return this.addNode(bci, new PreincNodeOp(), new Node(bci, new LocalVarValueOp(null, new Type("I"), slot), new Node[0]));
            }
            if (iincConst == -1) {
                if (this.postIncBcis.contains(bci)) {
                    if (prevNode != null) {
                        return this.addNode(bci, new PostdecNodeOp(), new Node(bci, new LocalVarValueOp(null, new Type("I"), slot), prevNode));
                    }
                    return false;
                }
                if (isSideeffect) {
                    if (nextNode != null) {
                        return this.addNode(bci, new PredecNodeOp(), new Node(bci, new LocalVarValueOp(null, new Type("I"), slot), new Node[0]), nextNode);
                    }
                    return false;
                }
                return this.addNode(bci, new PredecNodeOp(), new Node(bci, new LocalVarValueOp(null, new Type("I"), slot), new Node[0]), nextNode);
            }
            assert (!this.postIncBcis.contains(bci));
            return this.addNode(bci, new LocalVarOperationAndAssignOp("+", slot), new Node(bci, new ConstantOp(new Type("I"), iincConst), new Node[0]));
        }
        return false;
    }

    private boolean createLocalVariableAssignments(int bci, int byteCode, Node param, ByteCodeReader reader) {
        int slot = -1;
        switch (byteCode) {
            case 59: 
            case 63: 
            case 67: 
            case 71: 
            case 75: {
                slot = 0;
                break;
            }
            case 60: 
            case 64: 
            case 68: 
            case 72: 
            case 76: {
                slot = 1;
                break;
            }
            case 61: 
            case 65: 
            case 69: 
            case 73: 
            case 77: {
                slot = 2;
                break;
            }
            case 62: 
            case 66: 
            case 70: 
            case 74: 
            case 78: {
                slot = 3;
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                slot = reader.readUint8();
                break;
            }
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: {
                slot = reader.readUint16();
            }
        }
        if (slot >= 0) {
            if (param.getType().isPrimitive()) {
                Node opNode;
                Node node = opNode = param.getOp() instanceof CastOp ? param.getChild(0) : param;
                if (opNode.getOp() instanceof BinaryOp && opNode.getChild(0).getOp() instanceof LocalVarValueOp) {
                    String operator = ((BinaryOp)opNode.getOp()).getOperator();
                    int localSlot = ((LocalVarValueOp)opNode.getChild(0).getOp()).getSlot();
                    if (localSlot == slot) {
                        Node value = opNode.getChild(1);
                        int sign = this.getIncOrDec(operator, value);
                        if (sign != 0) {
                            return this.addNode(bci, sign == -1 ? new PredecNodeOp() : new PreincNodeOp(), new Node(bci, new LocalVarValueOp(null, value.getType(), slot), new Node[0]), param);
                        }
                        return this.addNode(bci, new LocalVarOperationAndAssignOp(operator, slot), value, param);
                    }
                }
            }
            return this.addNode(bci, new LocalVarAssignOp(slot), param);
        }
        return false;
    }

    private boolean createInstanceFieldAssignments(int bci, int byteCode, Node obj, Node value, ByteCodeReader reader) {
        if (byteCode == 181) {
            int cpSlot = reader.readUint16();
            String name = this.method.getCpEntry(cpSlot).getReferenceName();
            Type type = new Type(this.method.getCpEntry(cpSlot).getReferenceType());
            if (value.getType().isPrimitive()) {
                NodeOp leftOp;
                Node opNode;
                Node node = opNode = value.getOp() instanceof CastOp ? value.getChild(0) : value;
                if (opNode.getOp() instanceof BinaryOp && (leftOp = opNode.getChild(0).getOp()) instanceof InstanceFieldValueOp) {
                    String operator = ((BinaryOp)opNode.getOp()).getOperator();
                    String leftName = ((InstanceFieldValueOp)leftOp).getName();
                    Type leftType = ((InstanceFieldValueOp)leftOp).getType();
                    Node leftObj = opNode.getChild(0).getChild(0);
                    if (leftName.equals(name) && leftType.equals(type) && obj == leftObj) {
                        int sign = this.getIncOrDec(operator, opNode.getChild(1));
                        if (sign != 0) {
                            int prevCode = this.byteCodes[this.getPrevBci(bci)];
                            if (prevCode != 90 && prevCode != 93) {
                                return this.addNode(bci, sign == -1 ? new PostdecNodeOp() : new PostincNodeOp(), new Node(bci, new InstanceFieldValueOp(value.getType(), name), obj, value));
                            }
                            return this.addNode(bci, sign == -1 ? new PredecNodeOp() : new PreincNodeOp(), new Node(bci, new InstanceFieldValueOp(value.getType(), name), obj, value));
                        }
                        return this.addNode(bci, new InstanceFieldOperationAndAssignOp(operator, name, type), obj, opNode.getChild(1), value);
                    }
                }
            }
            return this.addNode(bci, new InstanceFieldAssignOp(name), obj, value);
        }
        return false;
    }

    private boolean createStaticFieldAssignments(int bci, int byteCode, Node value, ByteCodeReader reader) {
        if (byteCode == 179) {
            int cpSlot = reader.readUint16();
            String name = this.method.getCpEntry(cpSlot).getReferenceName();
            Type signature = new Type(this.method.getCpEntry(cpSlot).getReferenceType());
            Type type = new Type("L" + this.method.getCpEntry(cpSlot).getReferenceClass() + ";");
            if (value.getType().isPrimitive()) {
                NodeOp leftOp;
                Node opNode;
                Node node = opNode = value.getOp() instanceof CastOp ? value.getChild(0) : value;
                if (opNode.getOp() instanceof BinaryOp && (leftOp = opNode.getChild(0).getOp()) instanceof StaticFieldValueOp) {
                    String operator = ((BinaryOp)opNode.getOp()).getOperator();
                    String leftName = ((StaticFieldValueOp)leftOp).getName();
                    Type leftSignature = ((StaticFieldValueOp)leftOp).getType();
                    if (leftName.equals(name) && signature.equals(leftSignature)) {
                        int sign = this.getIncOrDec(operator, opNode.getChild(1));
                        if (sign != 0) {
                            int prevCode = this.byteCodes[this.getPrevBci(bci)];
                            if (prevCode != 89 && prevCode != 92) {
                                return this.addNode(bci, sign == -1 ? new PostdecNodeOp() : new PostincNodeOp(), new Node(bci, new StaticFieldValueOp(type, name, signature), opNode.getChild(1), value));
                            }
                            return this.addNode(bci, sign == -1 ? new PredecNodeOp() : new PreincNodeOp(), new Node(bci, new StaticFieldValueOp(type, name, signature), opNode.getChild(1), value));
                        }
                        return this.addNode(bci, new StaticFieldOperationAndAssignOp(operator, type, name, signature), opNode.getChild(1), value);
                    }
                }
            }
            return this.addNode(bci, new StaticFieldAssignOp(type, name, signature), value);
        }
        return false;
    }

    private boolean createNewStatement(int bci, int byteCode, ByteCodeReader reader) {
        if (byteCode != 187) {
            return false;
        }
        int cpSlot = reader.readUint16();
        Type type = new Type(this.method.getCpEntry(cpSlot).asFieldDescriptor());
        return this.addNode(bci, new NewOp(type), new Node[0]);
    }

    private boolean createReturnStatement(int bci, int byteCode, ByteCodeReader reader) {
        if (byteCode != 177) {
            return false;
        }
        return this.addNode(bci, new ReturnOp(), new Node[0]);
    }

    private boolean createCompareToExpressions(int bci, int byteCode, Node[] params, ByteCodeReader reader) {
        switch (byteCode) {
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return this.addNode(bci, new CompareToOp(), params[0], params[1]);
            }
        }
        return false;
    }

    private boolean createComparisonNode(int bci, int byteCode, Node[] params, ByteCodeReader reader) {
        String binaryName = null;
        String negatedBinary = null;
        String unaryName = null;
        String negatedUnary = null;
        String compareToName = null;
        String negatedCompareTo = null;
        int target1 = -1;
        int target2 = -1;
        switch (byteCode) {
            case 153: {
                unaryName = "== 0";
                negatedUnary = "!= 0";
                compareToName = "==";
                negatedCompareTo = "!=";
                break;
            }
            case 154: {
                unaryName = "!= 0";
                negatedUnary = "== 0";
                compareToName = "!=";
                negatedCompareTo = "==";
                break;
            }
            case 155: {
                unaryName = "< 0";
                negatedUnary = ">= 0";
                compareToName = "<";
                negatedCompareTo = ">=";
                break;
            }
            case 158: {
                unaryName = "<= 0";
                negatedUnary = "> 0";
                compareToName = "<=";
                negatedCompareTo = ">";
                break;
            }
            case 157: {
                unaryName = "> 0";
                negatedUnary = "<= 0";
                compareToName = ">";
                negatedCompareTo = "<=";
                break;
            }
            case 156: {
                unaryName = ">= 0";
                negatedUnary = "< 0";
                compareToName = ">=";
                negatedCompareTo = "<";
                break;
            }
            case 198: {
                unaryName = "== null";
                negatedUnary = "!= null";
                break;
            }
            case 199: {
                unaryName = "!= null";
                negatedUnary = "== null";
                break;
            }
            case 159: {
                binaryName = "==";
                negatedBinary = "!=";
                break;
            }
            case 160: {
                binaryName = "!=";
                negatedBinary = "==";
                break;
            }
            case 161: {
                binaryName = "<";
                negatedBinary = ">=";
                break;
            }
            case 164: {
                binaryName = "<=";
                negatedBinary = ">";
                break;
            }
            case 163: {
                binaryName = ">";
                negatedBinary = "<=";
                break;
            }
            case 162: {
                binaryName = ">=";
                negatedBinary = "<";
                break;
            }
            case 165: {
                binaryName = "==";
                negatedBinary = "!=";
                break;
            }
            case 166: {
                binaryName = "!=";
                negatedBinary = "==";
            }
        }
        if (binaryName != null || unaryName != null) {
            target1 = this.realTarget(bci + ByteCode.getSize(bci, this.method));
            target2 = this.realTarget(reader.readInt16() + bci);
        }
        if (binaryName != null) {
            return this.addNode(bci, new BinaryComparisonOp(binaryName, negatedBinary, target1, target2), params[0], params[1]);
        }
        if (unaryName != null) {
            if (params[0].getOp() instanceof CompareToOp) {
                return this.addNode(bci, new CompareToComparisonOp(compareToName, negatedCompareTo, target1, target2), params[0]);
            }
            return this.addNode(bci, new UnaryComparisonOp(unaryName, negatedUnary, target1, target2), params[0]);
        }
        return false;
    }

    private int realTarget(int bci) {
        int byteCode = ByteCode.getByteCode(bci, this.method);
        if (this.whileTrueLoopContinues.contains(bci) || this.javacLoopContinues.contains(bci) || this.eclipseLoopContinues.contains(bci) || this.loopBreaks.contains(bci)) {
            return bci;
        }
        if (byteCode == 167) {
            ByteCodeReader reader = new ByteCodeReader(this.method.getCode(), bci + 1);
            return this.realTarget(bci + reader.readInt16());
        }
        if (byteCode == 200) {
            ByteCodeReader reader = new ByteCodeReader(this.method.getCode(), bci + 1);
            return this.realTarget(bci + reader.readInt32());
        }
        return bci;
    }

    private boolean createBooleanExpression(int bci, int byteCode, Node[] parameters, ByteCodeReader reader) {
        if (byteCode != 154) {
            return false;
        }
        int b1 = bci + reader.readInt16();
        int b2 = bci + ByteCode.getSize(bci, this.method);
        Node b1Node = this.expressions[b1];
        Node b2Node = this.expressions[b2];
        Node condNode = parameters[0];
        if (b1Node == null || b2Node == null || condNode == null) {
            return false;
        }
        return this.addNode(bci, new OneParameterTestOp("!= 0"), condNode, b1Node, b2Node);
    }

    private boolean addNode(int bci, NodeOp op, Node ... rawParams) {
        Node node;
        Node[] params = rawParams;
        while (params.length > 0 && params[params.length - 1] == null) {
            Node[] newParams = new Node[params.length - 1];
            System.arraycopy(params, 0, newParams, 0, newParams.length);
            params = newParams;
        }
        Node node2 = node = op != null ? new Node(bci, op, params) : null;
        if (this.debug && op != null) {
            System.out.print("Added " + bci + " (" + op.getClass().getSimpleName() + ") ->" + Arrays.toString(node.getChildBcis()) + " " + this.tsc.getUsedArgs(bci) + ": ");
            AnnotatedPrintStreamImpl annotatedStream = new AnnotatedPrintStreamImpl();
            node.printOn(new NodePrinter(annotatedStream, this.method), false);
            for (String line : annotatedStream.getResult()) {
                System.out.println(line);
            }
        }
        if (node != null) {
            if (this.sideEffectSources.containsKey(bci)) {
                int[] sources = this.sideEffectSources.get(bci);
                this.sideEffectNodes.put(new Bcis(sources), node);
                ArrayList<Integer> bcis = this.sideEffectBcis.get(new Bcis(sources));
                if (bcis != null) {
                    bcis.remove((Object)bci);
                    if (this.debug) {
                        System.out.println("Added for side effect at " + Arrays.toString(sources));
                    }
                    if (bcis.size() == 0) {
                        this.sideEffectBcis.remove(new Bcis(sources));
                    }
                }
            }
            this.expressions[bci] = node;
            return true;
        }
        return false;
    }

    private int getIncOrDec(String operation, Node value) {
        if (!(value.getOp() instanceof ConstantOp)) {
            return 0;
        }
        Object constant = ((ConstantOp)value.getOp()).getValue();
        boolean isMinusOne = false;
        boolean isPlusOne = false;
        if (constant instanceof Integer) {
            isMinusOne = (Integer)constant == -1;
            isPlusOne = (Integer)constant == 1;
        } else if (constant instanceof Long) {
            isMinusOne = (Long)constant == -1L;
            isPlusOne = (Long)constant == 1L;
        } else if (constant instanceof Float) {
            isMinusOne = ((Float)constant).floatValue() == -1.0f;
            isPlusOne = ((Float)constant).floatValue() == 1.0f;
        } else if (constant instanceof Double) {
            isMinusOne = (Double)constant == -1.0;
            boolean bl = isPlusOne = (Double)constant == 1.0;
        }
        if (operation.equals("+")) {
            return isMinusOne ? -1 : (isPlusOne ? 1 : 0);
        }
        if (operation.equals("-")) {
            return isMinusOne ? 1 : (isPlusOne ? -1 : 0);
        }
        return 0;
    }

    private Node[] getCover(int startBci, int endBci) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = startBci; i < endBci; ++i) {
            if (this.byteCodes[i] == -1) continue;
            this.addNode(i, new NopOp(), new Node[0]);
            result.add(this.expressions[i]);
        }
        return result.toArray(new Node[result.size()]);
    }

    private boolean createForByteCodeSequences(int bci) {
        int ldcBci = -1;
        int end = this.classSequence1.matchEnd(this.byteCodes, this.lens, bci);
        if (end != bci) {
            ldcBci = this.getNextBci(this.getNextBci(bci));
        } else {
            end = this.classSequence2.matchEnd(this.byteCodes, this.lens, bci);
            if (end != bci) {
                ldcBci = this.getNextBci(this.getNextBci(this.getNextBci(this.getNextBci(bci))));
            }
        }
        if (ldcBci != -1) {
            int ldcCode = this.byteCodes[ldcBci];
            ByteCodeReader reader = new ByteCodeReader(this.method.getCode(), ldcBci + ByteCode.getByteCodeParameterOffset(ldcCode));
            int cpIndex = ldcCode == 18 ? reader.readUint8() : reader.readUint16();
            ConstantPoolEntry entry = this.method.getCpEntry(cpIndex);
            return this.addNode(bci, new ConstantOp(new Type("Ljava/lang/Class;"), entry.getExternalClass() + ".class"), this.getCover(bci, end));
        }
        return false;
    }

    private boolean createSwitchExpression(int bci, int byteCode, Node parameter, ByteCodeReader reader) {
        int target;
        int[] previousBcis;
        int[] followingBcis;
        int blockEnd;
        int i;
        int i2;
        List<Integer> cases;
        int target2;
        if (byteCode != 171 && byteCode != 170) {
            return false;
        }
        int pos = bci + 4 & 0xFFFFFFFC;
        ByteCodeReader bcr = new ByteCodeReader(this.method.getCode(), pos);
        int defaultTarget = bci + bcr.readInt32();
        HashMap<Integer, List<Integer>> target2Cases = new HashMap<Integer, List<Integer>>();
        if (byteCode == 171) {
            int pairs = bcr.readInt32();
            for (int i3 = 0; i3 < pairs; ++i3) {
                int match = bcr.readInt32();
                target2 = bci + bcr.readInt32();
                if (target2 == defaultTarget) continue;
                cases = (ArrayList<Integer>)target2Cases.get(target2);
                if (cases == null) {
                    cases = new ArrayList<Integer>();
                    target2Cases.put(target2, cases);
                }
                cases.add(match);
            }
        } else if (byteCode == 170) {
            int low = bcr.readInt32();
            int high = bcr.readInt32();
            for (i2 = 0; i2 < high - low + 1; ++i2) {
                target2 = bci + bcr.readInt32();
                if (target2 == defaultTarget) continue;
                cases = (List)target2Cases.get(target2);
                if (cases == null) {
                    cases = new ArrayList();
                    target2Cases.put(target2, cases);
                }
                cases.add(low + i2);
            }
        }
        ArrayList sortedTargets = new ArrayList(target2Cases.keySet());
        Collections.sort(sortedTargets);
        LinkedHashMap<Integer, int[]> resultCases = new LinkedHashMap<Integer, int[]>();
        for (i2 = 0; i2 < sortedTargets.size(); ++i2) {
            Integer target3 = (Integer)sortedTargets.get(i2);
            cases = (List)target2Cases.get(target3);
            int[] primitives = new int[cases.size()];
            for (int j = 0; j < cases.size(); ++j) {
                primitives[j] = (Integer)cases.get(j);
            }
            resultCases.put(target3, primitives);
            if (!this.debug) continue;
            System.out.print("case ");
            Iterator j = cases.iterator();
            while (j.hasNext()) {
                int c = (Integer)j.next();
                System.out.print(c);
                System.out.print(' ');
            }
            System.out.println();
        }
        ArrayList<Node> children = new ArrayList<Node>();
        children.add(parameter);
        SwitchOp op = new SwitchOp(resultCases, defaultTarget);
        int[] jumpTargets = op.getTargets();
        int switchEnd = op.getDefaulBci();
        for (i = 0; i < jumpTargets.length; ++i) {
            blockEnd = i + 1 < jumpTargets.length ? jumpTargets[i + 1] : op.getDefaulBci();
            followingBcis = this.cfa.getFollowingBcis(jumpTargets[i], blockEnd);
            for (int caseBci : previousBcis = this.cfa.getPreviousBcis(followingBcis)) {
                if (caseBci < jumpTargets[i] || caseBci >= blockEnd || this.byteCodes[caseBci] == 168 || this.byteCodes[caseBci] == 201 || !ByteCode.isJump(this.byteCodes[caseBci])) continue;
                target = caseBci + ByteCode.getJumpOffset(this.byteCodes[caseBci], new ByteCodeReader(this.method.getCode(), caseBci));
                switchEnd = Math.max(switchEnd, target);
            }
            children.add(new Node(jumpTargets[i], new ScopeOp(new Scope(jumpTargets[i], blockEnd)), new Node[0]));
        }
        for (i = 0; i < jumpTargets.length; ++i) {
            blockEnd = i + 1 < jumpTargets.length ? jumpTargets[i + 1] : op.getDefaulBci();
            followingBcis = this.cfa.getFollowingBcis(jumpTargets[i], blockEnd);
            for (int caseBci : previousBcis = this.cfa.getPreviousBcis(followingBcis)) {
                if (caseBci < jumpTargets[i] || caseBci >= blockEnd || this.byteCodes[caseBci] == 168 || this.byteCodes[caseBci] == 201 || !ByteCode.isJump(this.byteCodes[caseBci]) || (target = caseBci + ByteCode.getJumpOffset(this.byteCodes[caseBci], new ByteCodeReader(this.method.getCode(), caseBci))) != switchEnd) continue;
                assert (this.expressions[bci] == null);
                this.addNode(caseBci, new BreakOp(target), new Node[0]);
            }
        }
        if (op.getDefaulBci() < switchEnd) {
            int[] previousBcis2;
            int[] followingBcis2 = this.cfa.getFollowingBcis(op.getDefaulBci(), switchEnd);
            for (int caseBci : previousBcis2 = this.cfa.getPreviousBcis(followingBcis2)) {
                int target4;
                if (caseBci < op.getDefaulBci() || caseBci >= switchEnd || this.byteCodes[caseBci] == 168 || this.byteCodes[caseBci] == 201 || !ByteCode.isJump(this.byteCodes[caseBci]) || (target4 = caseBci + ByteCode.getJumpOffset(this.byteCodes[caseBci], new ByteCodeReader(this.method.getCode(), caseBci))) != switchEnd) continue;
                assert (this.expressions[bci] == null);
                this.addNode(caseBci, new BreakOp(target4), new Node[0]);
            }
            children.add(new Node(op.getDefaulBci(), new ScopeOp(new Scope(op.getDefaulBci(), switchEnd)), new Node[0]));
        }
        return this.addNode(bci, op, children.toArray(new Node[children.size()]));
    }

    private boolean createSynchronizedBlock(int bci, int byteCode, Node parameter, ByteCodeReader reader) {
        if (byteCode != 194) {
            return false;
        }
        int synchronizedEnd = -1;
        for (ExceptionTableEntry entry : this.method.getExceptionTable()) {
            if (!entry.isSynchronizedFinally() || entry.getStart() != bci + this.lens[bci]) continue;
            synchronizedEnd = entry.getTarget();
            break;
        }
        if (synchronizedEnd < 0) {
            throw new IllegalStateException("Exception table entry for synchronized block starting at byte code index " + bci + " not found");
        }
        assert (synchronizedEnd > bci);
        LocalVarAssignOp op = (LocalVarAssignOp)parameter.getOp();
        this.addNode(parameter.getBci(), new NopOp(), parameter);
        return this.addNode(bci, new SynchronizedOp(op.getSlot()), parameter.getChild(0), new Node(bci, new ScopeOp(new Scope(bci + this.lens[bci], synchronizedEnd)), new Node[0]));
    }

    private void createLoops() {
        int n;
        ArrayList<Integer> list;
        assert (this.hasBackJumps);
        HashSet<Integer> backJumps = new HashSet<Integer>();
        for (int bci2 = 0; bci2 < this.jumpTargetBcis.length; ++bci2) {
            if (this.jumpTargetBcis[bci2] == -1 || this.jumpTargetBcis[bci2] >= bci2) continue;
            backJumps.add(bci2);
            if (!this.debug) continue;
            int nextBci = bci2 + ByteCode.getSize(bci2, this.method);
            System.out.println("Back jump detected at byte code index " + bci2 + ", target " + this.jumpTargetBcis[bci2] + ", previous " + Arrays.toString(this.cfa.getPreviousBcis(this.jumpTargetBcis[bci2], nextBci)) + ", following " + Arrays.toString(this.cfa.getFollowingBcis(this.jumpTargetBcis[bci2], nextBci)));
        }
        Iterator bci2 = backJumps.iterator();
        while (bci2.hasNext()) {
            int bci = (Integer)bci2.next();
            if (this.byteCodes[bci] != 167 && this.byteCodes[bci] != 200) continue;
            int n2 = this.jumpTargetBcis[bci];
            boolean repeat = true;
            block2: while (repeat) {
                repeat = false;
                Iterator iterator = backJumps.iterator();
                while (iterator.hasNext()) {
                    int otherLoopStart;
                    int otherLoopBci = (Integer)iterator.next();
                    if (otherLoopBci == bci || n2 >= otherLoopBci || otherLoopBci >= bci || (otherLoopStart = this.jumpTargetBcis[otherLoopBci]) >= n2) continue;
                    n2 = otherLoopStart;
                    repeat = true;
                    continue block2;
                }
            }
            int[] following = this.cfa.getFollowingBcis(n2, bci + ByteCode.getSize(bci, this.method));
            int[] previous = this.cfa.getPreviousBcis(following);
            boolean isWhileTrue = true;
            for (int prev : previous) {
                if (prev < n2 || prev > bci || this.byteCodes[prev] == 167 || this.byteCodes[prev] == 200) continue;
                isWhileTrue = false;
                break;
            }
            if (!isWhileTrue) continue;
            this.whileTrueLoops.add(bci);
            if (this.debug) {
                System.out.println("Potential 'while(true)' loop detected: [" + n2 + ".." + bci + "]");
            }
            for (int i = n2; i < bci; ++i) {
                if (this.byteCodes[i] != 167 && this.byteCodes[i] != 200 || this.jumpTargetBcis[i] != bci) continue;
                this.whileTrueLoopContinues.add(i);
                if (!this.debug) continue;
                System.out.println("Potential 'continue' in 'while(true)' loop detected: [" + i + "]");
            }
        }
        backJumps.removeAll(this.whileTrueLoops);
        bci2 = backJumps.iterator();
        while (bci2.hasNext()) {
            int bci3 = (Integer)bci2.next();
            if (this.byteCodes[bci3] != 167 && this.byteCodes[bci3] != 200) continue;
            this.javacWhileForLoops.add(bci3);
        }
        backJumps.removeAll(this.javacWhileForLoops);
        HashMap<Integer, Object> start2End = new HashMap<Integer, Object>();
        Iterator<Object> bci3 = this.javacWhileForLoops.iterator();
        while (bci3.hasNext()) {
            int n3 = bci3.next();
            int loopStart = this.jumpTargetBcis[n3];
            list = (ArrayList<Integer>)start2End.get(loopStart);
            if (list == null) {
                list = new ArrayList<Integer>();
                start2End.put(loopStart, list);
            }
            list.add(n3);
        }
        for (Map.Entry entry : start2End.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            int maxValue = 0;
            list = ((List)entry.getValue()).iterator();
            while (list.hasNext()) {
                int bci5 = (Integer)list.next();
                maxValue = Math.max(maxValue, bci5);
            }
            this.javacLoopContinues.addAll((Collection)entry.getValue());
            this.javacLoopContinues.remove(maxValue);
        }
        this.javacWhileForLoops.removeAll(this.javacLoopContinues);
        if (this.debug) {
            bci3 = this.javacWhileForLoops.iterator();
            while (bci3.hasNext()) {
                int n4 = (Integer)bci3.next();
                System.out.println("Potential 'for(...)' or 'while(...)' loop compiled by javac detected: [" + this.jumpTargetBcis[n4] + ".." + n4 + "]");
            }
            bci3 = this.javacLoopContinues.iterator();
            while (bci3.hasNext()) {
                int n5 = (Integer)bci3.next();
                System.out.println("Potential 'continue' in 'while(...)' loop compiled by javac detected: [" + n5 + "]");
            }
        }
        HashMap<Integer, Integer> eclipseLoopStart = new HashMap<Integer, Integer>();
        do {
            n = this.eclipseWhileForLoops.size();
            Iterator maxValue = backJumps.iterator();
            while (maxValue.hasNext()) {
                int bci8 = (Integer)maxValue.next();
                if (this.eclipseWhileForLoops.contains(bci8)) continue;
                int loopStart = this.jumpTargetBcis[bci8];
                boolean repeat = true;
                block14: while (repeat) {
                    repeat = false;
                    for (int otherLoopBci : this.eclipseWhileForLoops) {
                        int otherLoopStart;
                        if (loopStart >= otherLoopBci || otherLoopBci >= bci8 || (otherLoopStart = ((Integer)eclipseLoopStart.get(otherLoopBci)).intValue()) >= loopStart) continue;
                        loopStart = otherLoopStart;
                        repeat = true;
                        continue block14;
                    }
                }
                int[] previous = this.cfa.getPreviousBcis(loopStart, bci8 + ByteCode.getSize(bci8, this.method));
                int[] following = this.cfa.getFollowingBcis(previous);
                boolean isEclipseLoop = true;
                for (int follow : following) {
                    if (follow != loopStart) continue;
                    isEclipseLoop = false;
                    break;
                }
                if (following.length <= 0 || !isEclipseLoop) continue;
                this.eclipseWhileForLoops.add(bci8);
                eclipseLoopStart.put(bci8, loopStart);
                if (this.debug) {
                    System.out.println("Potential 'for(...)' or 'while(...)' loop compiled by eclipse detected: [" + loopStart + ".." + bci8 + "]");
                }
                int continueTarget = -1;
                for (int i : following) {
                    if (i < loopStart || i > bci8) continue;
                    assert (continueTarget == -1);
                    continueTarget = i;
                }
                assert (continueTarget != -1);
                for (int i = loopStart; i <= bci8; ++i) {
                    if (this.byteCodes[i] != 167 && this.byteCodes[i] != 200 || this.jumpTargetBcis[i] != continueTarget) continue;
                    this.eclipseLoopContinues.add(i);
                    if (!this.debug) continue;
                    System.out.println("Potential 'continue' in 'while(...)' loop compiled by eclipse detected: [" + i + "]");
                }
            }
        } while (this.eclipseWhileForLoops.size() != n);
        backJumps.removeAll(this.eclipseWhileForLoops);
        Iterator iterator = backJumps.iterator();
        while (iterator.hasNext()) {
            int bci9 = (Integer)iterator.next();
            if (this.byteCodes[bci9] == 167 || this.byteCodes[bci9] == 200 || this.byteCodes[bci9] == 168 || this.byteCodes[bci9] == 201) continue;
            int loopStart = this.jumpTargetBcis[bci9];
            int[] previous = this.cfa.getPreviousBcis(loopStart, bci9 + ByteCode.getSize(bci9, this.method));
            int[] following = this.cfa.getFollowingBcis(previous);
            boolean isDoWhile = true;
            for (int follow : following) {
                if (follow < loopStart || follow > bci9 || follow == loopStart) continue;
                isDoWhile = false;
                break;
            }
            if (!isDoWhile) continue;
            this.doWhileLoops.add(bci9);
            if (!this.debug) continue;
            System.out.println("Potential 'do...while(...)' loop detected: [" + loopStart + ".." + bci9 + "]");
        }
        backJumps.removeAll(this.doWhileLoops);
        if (this.debug) {
            Iterator iterator2 = backJumps.iterator();
            while (iterator2.hasNext()) {
                int bci10 = (Integer)iterator2.next();
                System.out.println("Unknown back jump at " + bci10 + ", target " + this.jumpTargetBcis[bci10]);
            }
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.addAll(this.whileTrueLoops);
        hashSet.addAll(this.javacWhileForLoops);
        hashSet.addAll(this.eclipseWhileForLoops);
        hashSet.addAll(this.doWhileLoops);
        Iterator iterator3 = hashSet.iterator();
        while (iterator3.hasNext()) {
            int[] previous;
            int bci11 = (Integer)iterator3.next();
            int loopStart = this.jumpTargetBcis[bci11];
            int[] following = this.cfa.getFollowingBcis(loopStart, bci11 + ByteCode.getSize(bci11, this.method));
            for (int prev : previous = this.cfa.getPreviousBcis(following)) {
                if (prev < loopStart || prev > bci11 || this.byteCodes[prev] != 167 && this.byteCodes[prev] != 200) continue;
                this.loopBreaks.add(prev);
                if (!this.debug) continue;
                System.out.println("Potential 'break' in loop [" + loopStart + ".." + bci11 + "] detected: [" + prev + "]");
            }
        }
    }

    private boolean createContinueBreak(int bci) {
        if (this.whileTrueLoopContinues.contains(bci)) {
            return this.addNode(bci, new ContinueOp(this.jumpTargetBcis[bci]), new Node[0]);
        }
        if (this.javacLoopContinues.contains(bci)) {
            return this.addNode(bci, new ContinueOp(this.jumpTargetBcis[bci]), new Node[0]);
        }
        if (this.eclipseLoopContinues.contains(bci)) {
            return this.addNode(bci, new ContinueOp(this.jumpTargetBcis[bci]), new Node[0]);
        }
        if (this.loopBreaks.contains(bci)) {
            return this.addNode(bci, new BreakOp(this.jumpTargetBcis[bci]), new Node[0]);
        }
        return false;
    }

    private void createUnconditionalLoops() {
        for (int bci : this.whileTrueLoops) {
            int start = this.jumpTargetBcis[bci];
            Node node = this.expressions[bci];
            if (node != null && node.getParent() == null) {
                this.addNode(bci, new WhileTrueOp(), new Node(bci, new ScopeOp(new Scope(start, bci)), node));
                continue;
            }
            this.addNode(bci, new WhileTrueOp(), new Node(bci, new ScopeOp(new Scope(start, bci)), new Node[0]));
        }
    }

    private static final class Bcis {
        public final int[] bcis;

        public Bcis(int[] bcis) {
            this.bcis = bcis;
        }

        public int hashCode() {
            return Arrays.hashCode(this.bcis);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Bcis) {
                return Arrays.equals(this.bcis, ((Bcis)obj).bcis);
            }
            return false;
        }
    }
}

