/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler.ast;

import com.sap.jvm.debugging.impl.decompiler.MethodInfo;
import com.sap.jvm.debugging.impl.decompiler.ast.ConstantOp;
import com.sap.jvm.debugging.impl.decompiler.ast.Node;
import com.sap.jvm.debugging.impl.decompiler.ast.NodeOp;
import com.sap.jvm.debugging.impl.decompiler.ast.NodePrinter;
import com.sap.jvm.debugging.impl.decompiler.ast.Type;
import java.util.ArrayList;

public class ArrayInitializationOp
extends NodeOp {
    public ArrayInitializationOp(Type type) {
        super(type);
        assert (type.getArrayElementType() != null);
    }

    @Override
    public void printOn(Node node, NodePrinter stream, boolean mayNeedParen) {
        Node curr = node;
        ArrayList<Node> nodes = new ArrayList<Node>();
        while (curr.getOp() instanceof ArrayInitializationOp) {
            int index = (Integer)((ConstantOp)curr.getChild(1).getOp()).getValue();
            while (nodes.size() <= index) {
                nodes.add(null);
            }
            nodes.set(index, curr.getChild(2));
            curr = curr.getChild(0);
        }
        curr.printOn(stream, false);
        stream.print(" {");
        for (int i = 0; i < nodes.size(); ++i) {
            if (i != 0) {
                stream.print(", ");
            }
            if (nodes.get(i) == null) {
                stream.print(node.getChild(0).getOp().getType().getArrayElementType().getDefaultValueString());
                continue;
            }
            ((Node)nodes.get(i)).printOn(stream, false);
        }
        stream.print("}");
    }

    @Override
    public boolean simplify(Node node, MethodInfo method) {
        if (this.getType().getArrayDimension() == 1) {
            String internalType = this.getType().getTypes()[0];
            Node curr = node;
            while (curr.getOp() instanceof ArrayInitializationOp) {
                if (internalType.equals("[Z")) {
                    curr.getChild(2).getOp().makeBoolean();
                }
                curr = curr.getChild(0);
            }
        }
        return false;
    }
}

