/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler.ast;

import com.sap.jvm.debugging.impl.decompiler.ast.ComparisonOp;
import com.sap.jvm.debugging.impl.decompiler.ast.Node;
import com.sap.jvm.debugging.impl.decompiler.ast.NodePrinter;

public class BinaryComparisonOp
extends ComparisonOp {
    private final String operator;
    private final String negatedOperator;

    public BinaryComparisonOp(String operator, String negatedOperator, int target1, int target2) {
        super(target1, target2);
        this.operator = operator;
        this.negatedOperator = negatedOperator;
    }

    @Override
    public void printOn(Node node, NodePrinter stream, boolean mayNeedParen) {
        if (mayNeedParen) {
            stream.print("(");
        }
        node.getChild(0).printOn(stream, true);
        stream.print(" " + (this.isNegated ? this.negatedOperator : this.operator) + " ");
        node.getChild(1).printOn(stream, true);
        if (mayNeedParen) {
            stream.print(")");
        }
    }
}

