/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler.ast;

import com.sap.jvm.debugging.impl.decompiler.ByteCode;

public class ByteCodeSequence {
    private final boolean[][] matcher;

    public ByteCodeSequence(String ... sequence) {
        this.matcher = new boolean[sequence.length][];
        for (int i = 0; i < this.matcher.length; ++i) {
            int j;
            int[] codes = ByteCode.getMatchingByteCodes(sequence[i]);
            int maxCode = 0;
            for (j = 0; j < codes.length; ++j) {
                maxCode = Math.max(maxCode, codes[j]);
            }
            this.matcher[i] = new boolean[maxCode + 1];
            for (j = 0; j < codes.length; ++j) {
                this.matcher[i][codes[j]] = true;
            }
        }
    }

    public int matchEnd(int[] byteCodes, int[] lens, int start) {
        int bci = start;
        for (int i = 0; i < this.matcher.length; ++i) {
            if (bci >= byteCodes.length) {
                return start;
            }
            int byteCode = byteCodes[bci];
            boolean[] curr = this.matcher[i];
            if (byteCode >= curr.length || !curr[byteCode]) {
                return start;
            }
            bci += lens[bci];
        }
        return bci;
    }
}

