/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler.ast;

import com.sap.jvm.debugging.impl.decompiler.ast.Node;
import com.sap.jvm.debugging.impl.decompiler.ast.NodeOp;
import com.sap.jvm.debugging.impl.decompiler.ast.NodePrinter;
import com.sap.jvm.debugging.impl.decompiler.ast.Type;

public class ConstantOp
extends NodeOp {
    private Object value;

    public ConstantOp(Type type, Object value) {
        super(type);
        this.value = value;
    }

    @Override
    public void printOn(Node node, NodePrinter stream, boolean mayNeedParen) {
        if (this.getType().equals(new Type("Ljava/lang/String;"))) {
            stream.print("\"" + this.value + "\"");
        } else if (this.value instanceof Float) {
            stream.print(this.value + "f");
        } else if (this.value instanceof Double) {
            stream.print(this.value.toString());
        } else if (this.value instanceof Long) {
            stream.print(this.value + "L");
        } else {
            stream.print("" + this.value);
        }
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void makeBoolean() {
        if (this.value instanceof Number) {
            this.value = ((Number)this.value).byteValue() != 0;
        }
    }
}

