/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler.ast;

import com.sap.jvm.debugging.impl.decompiler.LocalVariableTableEntry;
import com.sap.jvm.debugging.impl.decompiler.MethodInfo;
import com.sap.jvm.debugging.impl.decompiler.ast.Node;
import com.sap.jvm.debugging.impl.decompiler.ast.NodeOp;
import com.sap.jvm.debugging.impl.decompiler.ast.NodePrinter;

public class LocalVarAssignOp
extends NodeOp {
    protected final int slot;

    public LocalVarAssignOp(int slot) {
        this.slot = slot;
    }

    public int getSlot() {
        return this.slot;
    }

    @Override
    public void printOn(Node node, NodePrinter stream, boolean mayNeedParen) {
        if (mayNeedParen) {
            stream.print("(");
        }
        stream.print(stream.getMethod().getVariableName(node.getBci(), this.slot));
        stream.print(" = ");
        node.getChild(0).printOn(stream, false);
        if (mayNeedParen) {
            stream.print(")");
        }
    }

    @Override
    public boolean simplify(Node node, MethodInfo method) {
        LocalVariableTableEntry entry = method.getVariableEntry(node.getBci(), this.slot);
        if (entry != null && entry.type.equals("Z")) {
            node.getChild(0).getOp().makeBoolean();
        }
        return super.simplify(node, method);
    }
}

