/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler.ast;

import com.sap.jvm.debugging.impl.decompiler.MethodInfo;
import com.sap.jvm.debugging.impl.decompiler.ast.Node;
import com.sap.jvm.debugging.impl.decompiler.ast.NodeOp;
import com.sap.jvm.debugging.impl.decompiler.ast.NodePrinter;
import com.sap.jvm.debugging.impl.decompiler.ast.Type;
import com.sap.jvm.util.misc.SignatureHelper;

public class NewCallOp
extends NodeOp {
    private final String signature;

    public NewCallOp(String signature) {
        super(new Type(signature.substring(signature.indexOf(41) + 1)));
        this.signature = signature;
    }

    @Override
    public void printOn(Node node, NodePrinter stream, boolean mayNeedParen) {
        node.getChild(0).printOn(stream, false);
        stream.print("(");
        for (int i = 1; i < node.getNrOfChildren(); ++i) {
            if (i != 1) {
                stream.print(", ");
            }
            node.getChild(i).printOn(stream, false);
        }
        stream.print(")");
    }

    @Override
    public boolean simplify(Node node, MethodInfo method) {
        String[] parts = SignatureHelper.toExternalSignature((String)this.signature).trim().split("[(), ]+");
        for (int i = 1; i < node.getNrOfChildren(); ++i) {
            if (!parts[i].trim().equals("boolean")) continue;
            node.getChild(i).getOp().makeBoolean();
        }
        return super.simplify(node, method);
    }
}

