/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler.ast;

import com.sap.jvm.debugging.impl.decompiler.ast.NodeOp;
import com.sap.jvm.debugging.impl.decompiler.ast.NodePrinter;
import com.sap.jvm.debugging.impl.decompiler.ast.NopOp;
import com.sap.jvm.debugging.impl.decompiler.ast.ScopeOp;
import com.sap.jvm.debugging.impl.decompiler.ast.Type;

public class Node {
    private int bci;
    private Node parent;
    private Node[] children;
    private NodeOp op;

    public Node(int bci, NodeOp op, Node ... children) {
        this.bci = bci;
        this.op = op;
        this.parent = null;
        this.children = children;
        for (int i = 0; i < children.length; ++i) {
            if (children[i].parent != null) {
                children[i] = Node.copyNode(children[i]);
            }
            children[i].parent = this;
        }
    }

    public void addChild(Node node) {
        Node[] newChildren = new Node[this.children.length + 1];
        System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
        newChildren[this.children.length] = node;
        this.children = newChildren;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public void replaceChildDead(int index) {
        Node childParent = this.children[index].parent;
        if (childParent != null) {
            for (int i = childParent.children.length - 1; i >= 0; --i) {
                if (childParent.children[i] != this.children[index]) continue;
                childParent.children[i] = this;
                this.parent = childParent;
            }
        }
    }

    public Node getFirstNonNop() {
        if (this.op instanceof NopOp) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getFirstNonNop();
        }
        return this;
    }

    public Node getParent() {
        return this.parent;
    }

    public int getNrOfChildren() {
        return this.children.length;
    }

    public Node getChild(int index) {
        return this.children[index];
    }

    public NodeOp getOp() {
        return this.op;
    }

    public Type getType() {
        return this.op.getType();
    }

    public int getBci() {
        return this.bci;
    }

    public int[] getChildBcis() {
        int[] result = new int[this.children.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.children[i].getBci();
        }
        return result;
    }

    public Node getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public int getFirstBci() {
        int minBci = this.bci;
        for (Node child : this.children) {
            minBci = Math.min(minBci, child.getFirstBci());
        }
        return minBci;
    }

    public int getLastBci() {
        int maxBci = this.bci;
        for (Node child : this.children) {
            maxBci = Math.max(maxBci, child.getLastBci());
        }
        return maxBci;
    }

    public void printOn(NodePrinter stream, boolean mayNeedParen) {
        stream.setAnnotation(this.bci);
        this.op.printOn(this, stream, mayNeedParen);
    }

    public boolean isExpression() {
        return !this.getType().isVoid();
    }

    public boolean hasScopes() {
        for (Node child : this.children) {
            if (!(child.op instanceof ScopeOp)) continue;
            return true;
        }
        return false;
    }

    public void replaceChild(int index, Node newChild) {
        Node oldChild = this.children[index];
        this.children[index] = newChild;
        for (int i = 0; i < oldChild.children.length; ++i) {
            oldChild.children[i].parent = newChild;
        }
        newChild.parent = this;
    }

    public void replaceChild(Node child, Node newChild) {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != child) continue;
            this.replaceChild(i, newChild);
        }
    }

    public void replaceChildWithoutChildren(int index, Node newChild) {
        this.children[index] = newChild;
        newChild.parent = this;
    }

    public void replaceChildWithoutChildren(Node child, Node newChild) {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != child) continue;
            this.replaceChildWithoutChildren(i, newChild);
        }
    }

    public static Node getFirstCommonAncestor(Node ... nodes) {
        if (nodes.length == 0) {
            return null;
        }
        Node n = nodes[0];
        for (int i = 1; i < nodes.length; ++i) {
            if ((n = n.getFirstCommonAcestor(nodes[i])) != null) continue;
            return n;
        }
        return n;
    }

    public Node getFirstCommonAcestor(Node other) {
        int i;
        int d1 = this.getDepth();
        int d2 = other.getDepth();
        int d = Math.min(d1, d2);
        Node parent1 = this;
        Node parent2 = other;
        for (i = d; i < d1; ++i) {
            parent1 = parent1.parent;
        }
        for (i = d; i < d2; ++i) {
            parent2 = parent2.parent;
        }
        while (parent1 != parent2) {
            parent1 = parent1.parent;
            parent2 = parent2.parent;
        }
        return parent1;
    }

    private int getDepth() {
        int depth = 0;
        Node n = this.parent;
        while (n != null) {
            ++depth;
            n = n.parent;
        }
        return depth;
    }

    private static Node copyNode(Node node) {
        Node copy = new Node(node.bci, node.op, node.children);
        for (int i = 0; i < copy.children.length; ++i) {
            copy.children[i] = Node.copyNode(copy.children[i]);
            copy.children[i].parent = copy;
        }
        return copy;
    }
}

