/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler.ast;

import com.sap.jvm.debugging.decompiler.AnnotatedPrintStream;
import com.sap.jvm.debugging.impl.decompiler.ByteCode;
import com.sap.jvm.debugging.impl.decompiler.MethodInfo;
import com.sap.jvm.debugging.impl.decompiler.ast.LocalVarAssignOp;
import com.sap.jvm.debugging.impl.decompiler.ast.LocalVarValueOp;
import com.sap.jvm.debugging.impl.decompiler.ast.Node;
import com.sap.jvm.debugging.impl.decompiler.ast.NodeOp;
import com.sap.jvm.debugging.impl.decompiler.ast.Type;
import java.util.Map;

public class NodePrinter {
    private final AnnotatedPrintStream stream;
    private final MethodInfo method;
    private int indent;
    private boolean isAtLineStart;

    public NodePrinter(AnnotatedPrintStream stream, MethodInfo method) {
        this.stream = stream;
        this.method = method;
        this.isAtLineStart = true;
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    private void indentIfNeeded() {
        if (this.isAtLineStart) {
            this.isAtLineStart = false;
            for (int i = 0; i < this.indent; ++i) {
                this.stream.print(' ');
            }
        }
    }

    public void print(String msg) {
        this.indentIfNeeded();
        this.stream.print(msg);
    }

    public void print(Object msg) {
        this.print(msg == null ? "null" : msg.toString());
    }

    public void println(String msg) {
        this.indentIfNeeded();
        this.stream.println(msg);
        this.isAtLineStart = true;
    }

    public void println(Object msg) {
        this.println(msg == null ? "null" : msg.toString());
    }

    public void ensureLineStart() {
        if (!this.isAtLineStart) {
            this.println("");
        }
    }

    public void printClassName(String className) {
        this.print(className.replace('/', '.'));
    }

    public void printClassNameOrOmit(Type className) {
        if (className.toString().equals(this.method.getClassName())) {
            return;
        }
        this.printClassName(className.toString());
        this.print(".");
    }

    public void printAndOmitThis(Node node, boolean mayNeedParen) {
        if (!this.method.isStatic()) {
            int slot = -1;
            NodeOp op = node.getOp();
            if (op instanceof LocalVarValueOp) {
                slot = ((LocalVarValueOp)op).getSlot();
            } else if (op instanceof LocalVarAssignOp) {
                slot = ((LocalVarAssignOp)op).getSlot();
            }
            if (slot == 0) {
                this.setAnnotation(node.getBci());
                return;
            }
        }
        node.printOn(this, mayNeedParen);
        this.print(".");
    }

    public void changeIndent(int delta) {
        this.indent += delta;
    }

    public void startBlock() {
        this.changeIndent(4);
    }

    public void endBlock() {
        this.changeIndent(-4);
    }

    public void setAnnotation(int annotation) {
        this.stream.setAnnotation(annotation);
    }

    public void finishMethod() {
        String context = this.stream.getContext();
        Map<String, Integer> annotations = this.stream.getAnnotations();
        int lastBci = -1;
        for (int bci = 0; bci < this.method.getCode().length; bci += ByteCode.getSize(bci, this.method)) {
            String key = context + ":" + bci;
            if (!annotations.containsKey(key)) {
                this.stream.duplicateAnnotation(lastBci, bci);
            }
            lastBci = bci;
        }
    }
}

