/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler.ast;

import com.sap.jvm.debugging.impl.decompiler.MethodInfo;
import com.sap.jvm.debugging.impl.decompiler.ast.Node;
import com.sap.jvm.debugging.impl.decompiler.ast.NodeOp;
import com.sap.jvm.debugging.impl.decompiler.ast.NodePrinter;
import com.sap.jvm.debugging.impl.decompiler.ast.Type;
import com.sap.jvm.util.misc.SignatureHelper;

public class StaticCallOp
extends NodeOp {
    private final Type clazz;
    private final String name;
    private final String signature;

    public StaticCallOp(Type clazz, String name, String signature) {
        super(new Type(signature.substring(signature.indexOf(41) + 1)));
        this.clazz = clazz;
        this.name = name;
        this.signature = signature;
    }

    @Override
    public void printOn(Node node, NodePrinter stream, boolean mayNeedParen) {
        stream.printClassNameOrOmit(this.clazz);
        stream.print(this.name);
        stream.print("(");
        for (int i = 0; i < node.getNrOfChildren(); ++i) {
            if (i != 0) {
                stream.print(", ");
            }
            node.getChild(i).printOn(stream, false);
        }
        stream.print(")");
    }

    @Override
    public boolean simplify(Node node, MethodInfo method) {
        String[] parts = SignatureHelper.toExternalSignature((String)this.signature).trim().split("[(), ]+");
        for (int i = 0; i < node.getNrOfChildren(); ++i) {
            if (!parts[i + 1].trim().equals("boolean")) continue;
            node.getChild(i).getOp().makeBoolean();
        }
        return super.simplify(node, method);
    }
}

