/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler.ast;

import com.sap.jvm.debugging.impl.decompiler.ast.Node;
import com.sap.jvm.debugging.impl.decompiler.ast.NodeOp;
import com.sap.jvm.debugging.impl.decompiler.ast.NodePrinter;
import java.util.Map;

public class SwitchOp
extends NodeOp {
    private final Map<Integer, int[]> cases;
    private final int defaultBci;

    public SwitchOp(Map<Integer, int[]> cases, int defaultBci) {
        this.cases = cases;
        this.defaultBci = defaultBci;
    }

    @Override
    public void printOn(Node node, NodePrinter stream, boolean mayNeedParen) {
        stream.print("switch (");
        node.getChild(0).printOn(stream, false);
        stream.println(") {");
        stream.startBlock();
        int i = 1;
        for (Map.Entry<Integer, int[]> block : this.cases.entrySet()) {
            for (int j = 0; j < block.getValue().length; ++j) {
                stream.println("case " + block.getValue()[j] + ":");
            }
            stream.startBlock();
            if (i < node.getNrOfChildren()) {
                node.getChild(i).printOn(stream, false);
            } else {
                stream.println("Not yet determined");
            }
            stream.endBlock();
            ++i;
        }
        if (i < node.getNrOfChildren()) {
            stream.println("default:");
            stream.startBlock();
            node.getChild(i).printOn(stream, false);
            stream.endBlock();
        }
        stream.endBlock();
        stream.println("}");
    }

    public int[] getTargets() {
        int[] result = new int[this.cases.size()];
        int i = 0;
        for (int target : this.cases.keySet()) {
            result[i++] = target;
        }
        return result;
    }

    public int getDefaulBci() {
        return this.defaultBci;
    }
}

