/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler.ast;

import com.sap.jvm.debugging.impl.decompiler.ast.Node;
import com.sap.jvm.debugging.impl.decompiler.ast.NodeOp;
import com.sap.jvm.debugging.impl.decompiler.ast.NodePrinter;

public class TryCatchFinallyOp
extends NodeOp {
    private final boolean hasFinallyBlock;
    private final String[] exceptionNames;

    public TryCatchFinallyOp(boolean hasFinallyBlock, String ... exceptionNames) {
        this.hasFinallyBlock = hasFinallyBlock;
        this.exceptionNames = exceptionNames;
    }

    @Override
    public void printOn(Node node, NodePrinter stream, boolean mayNeedParen) {
        stream.println("try {");
        stream.startBlock();
        node.getChild(0).printOn(stream, false);
        stream.endBlock();
        for (int i = 0; i < this.exceptionNames.length; ++i) {
            stream.println("} catch (" + this.exceptionNames[i].replace('/', '.') + ") {");
            stream.startBlock();
            node.getChild(i + 1).printOn(stream, false);
            stream.endBlock();
        }
        if (this.hasFinallyBlock) {
            stream.println("} finally {");
            stream.startBlock();
            node.getChild(this.exceptionNames.length + 1).printOn(stream, false);
            stream.endBlock();
        }
        stream.println("}");
    }

    public boolean hasFinally() {
        return this.hasFinallyBlock;
    }

    public String[] getExceptionNames() {
        return this.exceptionNames;
    }
}

