/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.impl.decompiler.ast;

import com.sap.jvm.util.misc.SignatureHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class Type {
    private final String[] types;

    public Type(String type) {
        this.types = new String[]{type};
    }

    private Type(String ... types) {
        this.types = types;
    }

    public Type merge(Type other) {
        HashSet<String> resultTypes = new HashSet<String>();
        resultTypes.addAll(Arrays.asList(this.types));
        resultTypes.addAll(Arrays.asList(other.types));
        return new Type(resultTypes.toArray(new String[resultTypes.size()]));
    }

    public Type getArrayElementType() {
        assert (this.types[0].startsWith("["));
        return new Type(this.types[0].substring(1));
    }

    public String[] getTypes() {
        return this.types;
    }

    public boolean isVoid() {
        return this.types.length == 1 && this.types[0].equals("V");
    }

    public boolean isPrimitive() {
        return this.types.length == 1 && !this.types[0].startsWith("[") && !this.types[0].startsWith("L");
    }

    public String toString() {
        return Type.toExternalName(this.types[0]);
    }

    public String getArrayElements() {
        return Type.toExternalName(this.types[0].substring(1));
    }

    public String getArrayBaseType() {
        return Type.toExternalName(this.types[0].substring(this.getArrayDimension()));
    }

    public int getArrayDimension() {
        return this.types[0].lastIndexOf(91) + 1;
    }

    public String getDefaultValueString() {
        switch (this.types[0].charAt(0)) {
            case 'Z': {
                return "false";
            }
            case 'B': {
                return "(byte) 0";
            }
            case 'S': {
                return "(short) 0";
            }
            case 'C': {
                return "(char) 0";
            }
            case 'I': {
                return "0";
            }
            case 'J': {
                return "0L";
            }
            case 'F': {
                return "0.0f";
            }
            case 'D': {
                return "0.0";
            }
        }
        return null;
    }

    private static String toExternalName(String internalName) {
        return SignatureHelper.fromFieldDescriptor((String)internalName);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Type) {
            Type other = (Type)obj;
            return Arrays.equals(this.types, other.types);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.types);
    }

    public static Type[] createTypes(String signature) {
        ArrayList<Type> result = new ArrayList<Type>();
        String current = signature;
        int index = 0;
        block4: while (current.length() > 0) {
            int end;
            switch (current.charAt(index)) {
                case '[': {
                    ++index;
                    continue block4;
                }
                case 'L': {
                    end = current.indexOf(59) + 1;
                    break;
                }
                default: {
                    end = index + 1;
                }
            }
            result.add(new Type(current.substring(0, end)));
            current = current.substring(end);
            index = 0;
        }
        return result.toArray(new Type[result.size()]);
    }
}

